/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.master.translate.stt;

import android.app.Application;
import android.content.Context;
import android.speech.SpeechRecognizer;
import android.widget.Toast;
import com.talpa.master.MoLContentProvider;
import com.talpa.master.translate.stt.EventListener;
import com.talpa.master.translate.stt.GoogleRecognitionHelper;
import com.talpa.master.translate.stt.STSEngineImpl;
import com.talpa.master.translate.stt.SpeechHelper;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u0012\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/talpa/master/translate/stt/STSEngine;", "Lcom/talpa/master/translate/stt/STSEngineImpl;", "builder", "Lcom/talpa/master/translate/stt/STSEngine$Builder;", "(Lcom/talpa/master/translate/stt/STSEngine$Builder;)V", "getBuilder", "()Lcom/talpa/master/translate/stt/STSEngine$Builder;", "googleRecognitionHelper", "Lcom/talpa/master/translate/stt/GoogleRecognitionHelper;", "getGoogleRecognitionHelper", "()Lcom/talpa/master/translate/stt/GoogleRecognitionHelper;", "googleRecognitionHelper$delegate", "Lkotlin/Lazy;", "speechHelper", "Lcom/talpa/master/translate/stt/SpeechHelper;", "cancelSpeech", "", "recognitionHelper", "release", "setLanguage", "speechLanguage", "", "startSpeech", "stopSpeech", "Builder", "Translate_release"})
public final class STSEngine
extends STSEngineImpl {
    @NotNull
    private final Builder builder;
    @NotNull
    private final Lazy googleRecognitionHelper$delegate;
    @Nullable
    private SpeechHelper speechHelper;

    private STSEngine(Builder builder) {
        super(builder);
        this.builder = builder;
        this.googleRecognitionHelper$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GoogleRecognitionHelper>(this){
            final /* synthetic */ STSEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GoogleRecognitionHelper invoke() {
                return new GoogleRecognitionHelper(this.this$0);
            }
        }));
    }

    @NotNull
    public final Builder getBuilder() {
        return this.builder;
    }

    private final GoogleRecognitionHelper getGoogleRecognitionHelper() {
        Lazy lazy = this.googleRecognitionHelper$delegate;
        return (GoogleRecognitionHelper)lazy.getValue();
    }

    @NotNull
    public final STSEngine setLanguage(@Nullable String speechLanguage) {
        this.builder.setSpeechLanguage(speechLanguage);
        this.speechHelper = null;
        return this;
    }

    public static /* synthetic */ STSEngine setLanguage$default(STSEngine sTSEngine, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = sTSEngine.builder.getSpeechLanguage();
        }
        return sTSEngine.setLanguage(string);
    }

    @Override
    public void startSpeech() {
        super.startSpeech();
        SpeechHelper speechHelper = this.speechHelper = this.recognitionHelper();
        if (speechHelper != null) {
            speechHelper.startSpeech();
        }
    }

    @Override
    public void stopSpeech() {
        super.stopSpeech();
        SpeechHelper speechHelper = this.speechHelper;
        if (speechHelper != null) {
            speechHelper.stopSpeech();
        }
    }

    @Override
    public void cancelSpeech() {
        SpeechHelper speechHelper = this.speechHelper;
        if (speechHelper != null) {
            speechHelper.cancelSpeech();
        }
    }

    @Override
    public void release() {
        SpeechHelper speechHelper = this.speechHelper;
        if (speechHelper != null) {
            speechHelper.release();
        }
        this.speechHelper = null;
        this.builder.setEventListener(null);
    }

    private final SpeechHelper recognitionHelper() {
        if (this.builder.getEventListener() == null) {
            throw new NullPointerException("eventListener is null");
        }
        if (this.builder.getSpeechLanguage() == null) {
            throw new NullPointerException("speechLanguage is null");
        }
        if (SpeechRecognizer.isRecognitionAvailable((Context)((Context)this.builder.getContext()))) {
            GoogleRecognitionHelper googleRecognitionHelper2 = this.getGoogleRecognitionHelper();
            String string = this.builder.getSpeechLanguage();
            Intrinsics.checkNotNull((Object)string);
            if (!googleRecognitionHelper2.isSupportLanguage(string)) {
                Toast.makeText((Context)MoLContentProvider.Companion.getMApplicationContext(), (CharSequence)"\u4e0d\u652f\u6301\u8bc6\u522b\u8be5\u8bed\u8a00", (int)0).show();
                return null;
            }
        } else {
            Toast.makeText((Context)MoLContentProvider.Companion.getMApplicationContext(), (CharSequence)"\u8bf7\u5b89\u88c5 Google APP", (int)0).show();
            return null;
        }
        return this.getGoogleRecognitionHelper();
    }

    public /* synthetic */ STSEngine(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/talpa/master/translate/stt/STSEngine$Builder;", "", "context", "Landroid/app/Application;", "speechLanguage", "", "eventListener", "Lcom/talpa/master/translate/stt/EventListener;", "(Landroid/app/Application;Ljava/lang/String;Lcom/talpa/master/translate/stt/EventListener;)V", "getContext", "()Landroid/app/Application;", "getEventListener", "()Lcom/talpa/master/translate/stt/EventListener;", "setEventListener", "(Lcom/talpa/master/translate/stt/EventListener;)V", "getSpeechLanguage", "()Ljava/lang/String;", "setSpeechLanguage", "(Ljava/lang/String;)V", "build", "Lcom/talpa/master/translate/stt/STSEngine;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Translate_release"})
    public static final class Builder {
        @NotNull
        private final Application context;
        @Nullable
        private String speechLanguage;
        @Nullable
        private EventListener eventListener;

        public Builder(@NotNull Application context, @Nullable String speechLanguage, @Nullable EventListener eventListener) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.speechLanguage = speechLanguage;
            this.eventListener = eventListener;
        }

        public /* synthetic */ Builder(Application application, String string, EventListener eventListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                eventListener = null;
            }
            this(application, string, eventListener);
        }

        @NotNull
        public final Application getContext() {
            return this.context;
        }

        @Nullable
        public final String getSpeechLanguage() {
            return this.speechLanguage;
        }

        public final void setSpeechLanguage(@Nullable String string) {
            this.speechLanguage = string;
        }

        @Nullable
        public final EventListener getEventListener() {
            return this.eventListener;
        }

        public final void setEventListener(@Nullable EventListener eventListener) {
            this.eventListener = eventListener;
        }

        @NotNull
        public final STSEngine build() {
            return new STSEngine(this, null);
        }

        @NotNull
        public final Application component1() {
            return this.context;
        }

        @Nullable
        public final String component2() {
            return this.speechLanguage;
        }

        @Nullable
        public final EventListener component3() {
            return this.eventListener;
        }

        @NotNull
        public final Builder copy(@NotNull Application context, @Nullable String speechLanguage, @Nullable EventListener eventListener) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new Builder(context, speechLanguage, eventListener);
        }

        public static /* synthetic */ Builder copy$default(Builder builder, Application application, String string, EventListener eventListener, int n, Object object) {
            if ((n & 1) != 0) {
                application = builder.context;
            }
            if ((n & 2) != 0) {
                string = builder.speechLanguage;
            }
            if ((n & 4) != 0) {
                eventListener = builder.eventListener;
            }
            return builder.copy(application, string, eventListener);
        }

        @NotNull
        public String toString() {
            return "Builder(context=" + this.context + ", speechLanguage=" + this.speechLanguage + ", eventListener=" + this.eventListener + ')';
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = result * 31 + (this.speechLanguage == null ? 0 : this.speechLanguage.hashCode());
            result = result * 31 + (this.eventListener == null ? 0 : this.eventListener.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)other;
            if (!Intrinsics.areEqual((Object)this.context, (Object)builder.context)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.speechLanguage, (Object)builder.speechLanguage)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.eventListener, (Object)builder.eventListener);
        }
    }
}

