//package com.talpa.tengine.free
//
//import com.talpa.tengine.Exception
//import com.talpa.tengine.TranslateFactory
//import com.talpa.tengine.http.RequestHelper
//import com.talpa.tengine.lang.LANG
//import com.talpa.tengine.lang.tencentCodeToLang
//import com.google.gson.Gson
//import com.google.gson.JsonArray
//import com.google.gson.JsonObject
//import io.reactivex.Flowable
//import okhttp3.ResponseBody
//
///**
// *  @author CY 2019-01-13
// */
//class TencentTranslate : TranslateFactory() {
//    override val isSupportMultiTextTranslate: Boolean = false
//    override fun setLangSupport(langMap: HashMap<String, String>) {
//        langMap[LANG.AUTO] = "auto"
//        langMap[LANG.ZH_CN] = "zh"
//        langMap[LANG.EN] = "en"
//        langMap[LANG.JA] = "jp"
//        langMap[LANG.KO] = "kr"
//        langMap[LANG.FR] = "fr"
//        langMap[LANG.RU] = "ru"
//        langMap[LANG.DE] = "de"
//
//        langMap[LANG.ES] = "es"
//        langMap[LANG.IT] = "it"
//        langMap[LANG.TR] = "tr"
//        langMap[LANG.PT] = "pt"
//        langMap[LANG.VI] = "vi"
//        langMap[LANG.IN] = "id"
//        langMap[LANG.MS] = "ms"
//        langMap[LANG.TH] = "th"
//
//
///*
//https://cloud.tencent.com/document/product/551/15619
//        目标语言，参照支持语言列表
//        zh : 中文
//        en : 英文
//        jp : 日语
//        kr : 韩语
//        de : 德语
//        fr : 法语
//        es : 西班牙文
//        it : 意大利文
//        tr : 土耳其文
//        ru : 俄文
//        pt : 葡萄牙文
//        vi : 越南文
//        id : 印度尼西亚文
//        ms : 马来西亚文
//        th : 泰文
//        auto : 自动识别源语言，只能用于source字段
//        */
//    }
//
//    override fun setFormData(from:String, to:String, text: String): TranslateFactory {
//        formData["source"] = langMap[from]!!
//        formData["target"] = langMap[to]!!
//        formData["sourceText"] = text
//        formData["sessionUuid"] = "translate_uuid" + System.currentTimeMillis().toString()
//        return this
//    }
//
//    override fun execute(): Flowable<retrofit2.Response<ResponseBody>> {
//
//        val headerMap = hashMapOf(
//            "Cookie" to "fy_guid=d4480e20-1644-4a47-a98d-787cfa244fd2; qtv=bbbc7118b32d7a9a; qtk=DTmfpOAn6b6HWTGtjW7w5a/FOommFjJPAre3GpaRUzPCQSaqY3gOSzKYEFyRYwKnjUN3M9D0V59LVNGDKchtj+RBld2oqSAVvEaAQVVLApTHDB52kdQYQYKAsa2NLnl4lIUbr6pYKN5469mS5hjcmQ==;",
//            "Origin" to "http://fanyi.qq.com",
//            "Cache-Control" to "public,max-age=${3600 * 24 * 365}"
//        )
//        return RequestHelper.post(baseUrl = BASE_URL, paths = PATHS, headerMap = headerMap, params = formData)
//    }
//
//    override fun parses(response: retrofit2.Response<ResponseBody>): List<String> {
//
//
//        if (response.isSuccessful) {
//            val responseBody = response.body()!!
//            val text = responseBody.string()
//            //println("text=$text")
//            /*
//            腾讯还会竞购吗？游戏开发商Nexon业绩连续下滑
//            {"sessionUuid":"translate_uuid1554275652991","translate":{"errCode":0,"errMsg":"","sessionUuid":"translate_uuid1554275652991","source":"zh","target":"en","records":[{"sourceText":"腾讯还会竞购吗？","targetText":". ","traceId":"51f4294381334265a19e95e6bfa75e44"},{"sourceText":"游戏开发商Nexon业绩连续下滑","targetText":"","traceId":"51f4294381334265a19e95e6bfa75e44"}],"full":true,"options":{}},"dict":null,"suggest":null,"errCode":0,"errMsg":"ok"}
//             */
//            val jsonObject = Gson().fromJson<JsonObject>(text, JsonObject::class.java)
//            val result = jsonObject.getAsJsonObject("translate")
//
//            if (result.getAsJsonPrimitive("errCode").asInt != 0) {
//                throw Exception("Tencent translator parser exception")
//            }
//            val resultArray = result.getAsJsonArray("records")
//
//            val list = arrayListOf<String>()
//            for (ja in resultArray) {
//                val tran = ja.asJsonObject
//                val sourceText = tran["sourceText"].asString
//                val targetText = tran["targetText"].asString.trim()
//                if (targetText == "." || targetText == "\n" || targetText == "") continue
//                list.add(targetText)
//            }
//
//            val source = result.get("source").asString
//            detectLang = tencentCodeToLang(source)
//            /*
//            val startIndexStr = "\"targetText\":\""
//            val endIndexStr = "\",\""
//            val startIndex = text.indexOf(startIndexStr) + startIndexStr.length
//            val endIndex = text.indexOf(endIndexStr, startIndex)
//            val translation = text.substring(startIndex, endIndex).trim()
//            */
//            if (list.isEmpty()) {
//                throw Exception("Tencent translator parser exception")
//            }
//            return list
//
//            /*
//            {"sessionUuid":"translate_uuid1554273480865","translate":{"errCode":0,"errMsg":"","sessionUuid":"translate_uuid1554273480865","source":"zh","target":"en","records":[{"sourceText":"人社部公布月最低工资标准排名：上海第一","targetText":"","traceId":"883a004ee06f48798d425bd7253f91e7"}],"full":true,"options":{}},"dict":null,"suggest":null,"errCode":0,"errMsg":"ok"}
//             */
//        }
//
//        throw Exception("Tencent Code=${response.code()}")
//
//
//    }
//
//    companion object {
//
//        //private const val URL = "https://fanyi.qq.com/api/translate"
//        private const val BASE_URL = "https://fanyi.qq.com/"
//        private const val PATHS = "api/translate"
//    }
//}
//
//fun main() {
//    val translate = TencentTranslate()
//    val json = JsonArray().apply {
//        add("今天天气如何")
//        add("你")
//        add("今天开心吗")
//    }.toString()
//
//    val text = "今天天气如何#你好#开心吗"
//    translate.setFormData(LANG.AUTO, LANG.EN, text)
//    val d = translate.execute().subscribe({
//
//        println(translate.parses(it))
//    }, Throwable::printStackTrace)
//}