package com.talpa.tengine.tools

import android.content.Context
import android.util.Base64
import java.io.InputStream
import java.nio.charset.Charset

fun googleTk(context: Context): String {
    val inputStream = context.assets.open("tk/Google.js")
    val googleTk = Base64.decode(inputStream.readBytes(), Base64.NO_WRAP).toString(Charset.defaultCharset())
    inputStream.close()
    return googleTk
}

fun baiduTk(context: Context): String {
    val inputStream = context.assets.open("tk/Baidu.js")
    val baiduJs = Base64.decode(inputStream.readBytes(), Base64.NO_WRAP).toString(Charset.defaultCharset())
    inputStream.close()
    return baiduJs
}

fun baiduTk(inputStream: InputStream): String {
    val baiduJs = java.util.Base64.getDecoder().decode(inputStream.readBytes()).toString(Charset.defaultCharset())
    inputStream.close()
    return baiduJs
}