package com.talpa.tengine.store

import android.content.Context
import android.util.Base64
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch

/**
 * @author CY 2020/4/27
 */


/**
 * Store
 */
fun Context.storeTranslation(
    sourceLanguage: String?,
    targetLanguage: String,
    text: String,
    translation: String
) = GlobalScope.launch(context = Dispatchers.IO) {

    val preferKey: String =
        generateKey(sourceLanguage, targetLanguage, text)

    RoomHelper.instance(applicationContext).insertValue(preferKey, translation)
    //KeyValue.put(preferKey, translation)
}

/**
 * Read
 */
fun Context.readTranslation(
    sourceLanguage: String?,
    targetLanguage: String,
    text: String
): String? {

    val preferKey: String =
        generateKey(sourceLanguage, targetLanguage, text)

    return RoomHelper.instance(applicationContext).queryValue(preferKey)
    //return KeyValue.get(preferKey)

}

private fun generateKey(
    sourceLanguage: String?, targetLanguage: String, text: String
): String {
    val content = "$sourceLanguage-$targetLanguage-$text"
    return Base64.encodeToString(content.toByteArray(), Base64.DEFAULT)
}