package com.talpa.overlay.view.menu

import android.animation.Animator
import android.animation.AnimatorSet
import android.animation.ObjectAnimator
import android.animation.ValueAnimator
import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.graphics.Point
import android.os.Handler
import android.view.*
import android.view.animation.AccelerateDecelerateInterpolator
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.talpa.overlay.state.FloatingStateMachine
import com.talpa.overlay.view.FloatingManager
import android.text.TextUtils
import android.util.Log
import androidx.constraintlayout.motion.widget.MotionLayout
import androidx.core.animation.addListener
import androidx.core.view.ViewCompat
import com.talpa.overlay.R
import com.talpa.overlay.view.FloatingManager.BROADCAST_ACTION_FLOATING_CLOSE
import com.talpa.overlay.view.FloatingManager.BROADCAST_ACTION_FLOATING_OPEN
import com.talpa.overlay.view.overlayViewParams
import java.lang.Exception
import java.util.*


/**
 * @author CY 2019-09-27
 */
class FloatingMenu(val context: Context) {

    companion object {
        /**
         * Click Translate All Locale Broadcast Action
         */
        const val ACTION_MENU_CLICK_TRANS_ALL = "ACTION_MENU_CLICK_TRANS_ALL"
        const val ACTION_MENU_CLICK_SETTING = "ACTION_MENU_CLICK_SETTING"
        const val ACTION_MENU_CLICK_CLOSE = "ACTION_MENU_CLICK_CLOSE"
        const val ACTION_MENU_CLICK_MOVE = "ACTION_MENU_CLICK_MOVE"
        const val ACTION_MENU_CLICK_DICT = "ACTION_MENU_CLICK_DICT"
        const val DICT_PACKAGE = "com.talpa.translate"

        /**
         * Show Menu
         */
        const val ACTION_MENU_SHOW = "ACTION_MENU_SHOW"

        const val GLOBAL_TRANSLATE = "android.intent.action.GLOBAL_TRANSLATE"
        const val CAMERA_ACTION = "com.talpa.translate.ACTION_FOR_CARMERA"
        const val SETTING_ACTION = "com.talpa.translate.ACTION_FOR_SETTING"
    }


    private val defaultHeight by lazy { context.resources.getDimensionPixelOffset(R.dimen.dp283) }
    private val defaultWidth by lazy { context.resources.getDimensionPixelOffset(R.dimen.dp283) }

    private val paddingTop by lazy { context.resources.getDimensionPixelOffset(R.dimen.dp35) }
    private val paddingLeft by lazy { context.resources.getDimensionPixelOffset(R.dimen.dp35) }

    /**
     * 本地广播
     */
    private val localBroadcastManager by lazy { LocalBroadcastManager.getInstance(context) }


    private var menuView: MotionLayout? = null

    private val handler by lazy { Handler() }

    private fun createMenuView(context: Context): MotionLayout {

        val menuView = LayoutInflater.from(context)
            .inflate(R.layout.layout_floating_menu, null) as MotionLayout
        val tvTransAll = menuView.findViewById<View>(R.id.tv_trans_all)
        val tvMove = menuView.findViewById<View>(R.id.tv_move)
        val tvSearch = menuView.findViewById<View>(R.id.tv_camera)
        val tvClose = menuView.findViewById<View>(R.id.tv_close)
        val tvSetting = menuView.findViewById<View>(R.id.tv_setting)
        val tvDict = menuView.findViewById<View>(R.id.ib_dict)

        tvMove.setOnClickListener(this::onMenuItemClick)
        tvClose.setOnClickListener(this::onMenuItemClick)
        tvSearch.setOnClickListener(this::onMenuItemClick)
        tvSetting.setOnClickListener(this::onMenuItemClick)
        tvTransAll.setOnClickListener(this::onMenuItemClick)
        tvDict.setOnClickListener(this::onMenuItemClick)

        menuView.setOnTouchListener { v, event ->
            if (event.action == MotionEvent.ACTION_UP) {
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
            }
            return@setOnTouchListener false
        }

        /*(menuView as? MenuView)?.setOnBackClickListener = {
            FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
            true
        }*/

        //tvSearch.visibility = View.GONE


        /*val items = arrayListOf<View>()

        items.add(tvTransAll)
        items.add(tvMove)
        items.add(tvSearch)
        items.add(tvClose)
        items.add(tvSetting)*/


        /*val angle = 360.0F / items.size

        for (i in 0 until items.size) {
            val arc = i * angle
            val params = items[i].layoutParams as ConstraintLayout.LayoutParams
            params.circleAngle = arc
        }*/

        return menuView
    }


    private fun onMenuItemClick(view: View) {
        when (view.id) {
            R.id.tv_move -> {
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_FIND_LOCATION_ENTER)
                localBroadcastManager.sendAction(ACTION_MENU_CLICK_MOVE)
            }
            R.id.tv_close -> {
                localBroadcastManager.sendAction(BROADCAST_ACTION_FLOATING_CLOSE)
                localBroadcastManager.sendAction(ACTION_MENU_CLICK_CLOSE)
            }
            R.id.tv_camera -> {
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
                val intent = Intent(CAMERA_ACTION)
                intent.setPackage(DICT_PACKAGE)
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                //view.context.startActivity(intent)
                val pendingIntent = PendingIntent.getActivity(context, 0, intent, 0);
                pendingIntent.send()
            }
            R.id.tv_setting -> {
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
                //val action = "com.talpa.translate.ACTION_FOR_SETTING"
                //val action = "com.talpa.translate.ACTION_FOR_MAIN"
                //view.context.pendingStartActivity(action)
                val intent = Intent(SETTING_ACTION)
                intent.setPackage(DICT_PACKAGE)
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                //view.context.startActivity(intent)
                val pendingIntent = PendingIntent.getActivity(context, 0, intent, 0);
                pendingIntent.send()
                localBroadcastManager.sendAction(ACTION_MENU_CLICK_SETTING)
            }
            R.id.tv_trans_all -> {
                localBroadcastManager.sendBroadcastSync(Intent(BROADCAST_ACTION_FLOATING_OPEN))
                localBroadcastManager.sendAction(ACTION_MENU_CLICK_TRANS_ALL)
                handler.postDelayed({
                    FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_HIGHLIGHT_ENTER)
                }, 800)

            }
            R.id.ib_dict -> {
                FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
                //val action = "com.talpa.translate.ACTION_FOR_DICTIONARY"
                //view.context.pendingStartActivity(action)
                val intent = Intent(GLOBAL_TRANSLATE)
                intent.setPackage(DICT_PACKAGE)
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
                //view.context.startActivity(intent)

                val pendingIntent = PendingIntent.getActivity(context, 0, intent, 0);
                pendingIntent.send()

                localBroadcastManager.sendAction(ACTION_MENU_CLICK_DICT)
            }
        }

    }


    /**
     * 进入菜单状态
     */
    fun enterMenu(context: Context, point: Point) {

        val menuView = menuView ?: createMenuView(context).apply { menuView = this }


        if (menuView.isAttachedToWindow) {
            return
        }

        val wm = menuView.context.getSystemService(Context.WINDOW_SERVICE) as WindowManager

        val params = overlayViewParams()
        //val point = menuView.context.getSize()
        params.width = defaultWidth//point.x
        params.height = defaultHeight//point.y


        val display = wm.defaultDisplay
        val displayPoint = Point()
        display.getSize(displayPoint)

        if (point.x > displayPoint.x / 2) {
            params.gravity = Gravity.RIGHT or Gravity.TOP
            //右边
            if (point.y < displayPoint.y / 4) {
                //右上
                Log.d("cjslog", "right top")
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_right_top_scene)
                params.y = point.y + paddingTop
                params.windowAnimations = R.style.AnimationOverlay_Right_Top
            } else if (point.y > displayPoint.y * 3 / 4) {
                //右下
                Log.d("cjslog", "right bottom")
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_right_bottom_scene)
                params.y = point.y + paddingTop - defaultHeight
                params.windowAnimations = R.style.AnimationOverlay_Right_Bottom
            } else {
                //右中
                Log.d("cjslog", "right center")
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_right_center_scene)
                params.y = point.y + paddingTop - defaultHeight / 2
                params.windowAnimations = R.style.AnimationOverlay_Right_Center
            }
        } else {
            params.gravity = Gravity.LEFT or Gravity.TOP
            //左边
            if (point.y < displayPoint.y / 4) {
                //左上
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_left_top_scene)
                params.y = point.y + paddingTop
                Log.d("cjslog", "left top")
                params.windowAnimations = R.style.AnimationOverlay_Left_Top
            } else if (point.y > displayPoint.y * 3 / 4) {
                //左下
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_left_bottom_scene)
                params.y = point.y + paddingTop - defaultHeight
                Log.d("cjslog", "left bottom")
                params.windowAnimations = R.style.AnimationOverlay_Left_Bottom
            } else {
                //左中
                menuView.loadLayoutDescription(R.xml.layout_floating_menu_left_center_scene)
                params.y = point.y + paddingTop - defaultHeight / 2
                Log.d("cjslog", "left center")
                params.windowAnimations = R.style.AnimationOverlay_Left_Center
            }
        }

        params.x = paddingLeft

        menuView.post {
            menuView.transitionToEnd()
        }

        try {
            wm.addView(menuView, params)
        } catch (e: Exception) {
            e.printStackTrace()
        }

        menuView.setOnClickListener {
            FloatingStateMachine.sendMessage(FloatingStateMachine.WHAT_LIGHT_ENTER)
        }
        // animMenuEnter2(menuView)
        //animMenuEnter(menuView)

        localBroadcastManager.sendAction(ACTION_MENU_SHOW)
    }

    /**
     * 退出菜单状态
     */
    fun exitMenu() {
        val menuView = this.menuView ?: return
        menuView.transitionToStart()
        val wm = menuView.context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
        wm.removeView(menuView)
    }

    private fun removeMenuFromWindow() {
        val menuView = this.menuView ?: return
        if (!menuView.isAttachedToWindow) {
            return
        }
        val wm = menuView.context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
        try {
            wm.removeViewImmediate(menuView)
        } catch (e: Exception) {
            e.printStackTrace()
        }

        this.menuView = null
    }

    private fun animMenuEnter2(menuView: View) {

        val floatingMenu = menuView.findViewById<View>(R.id.floating_menu)

        /****************************/
        val scaleX1 = ObjectAnimator.ofFloat(floatingMenu, "scaleX", 0F, 0.18F)
        val scaleY1 = ObjectAnimator.ofFloat(floatingMenu, "scaleY", 0F, 0.18F)

        val alpha1 = ObjectAnimator.ofFloat(floatingMenu, "alpha", 0F, 0.3F)

        /****************************/
        //val dp276 = menuView.resources.getDimension(R.dimen.dp276).toInt()

        val location = intArrayOf(0, 0)
        FloatingManager.getLocationOnScreen(location)

        val point = menuView.context.getSize()
        val startX = location[0].toFloat() + 20
        val startY = location[1].toFloat() + 20//- dp60 * 2//floatingParams.y.toFloat() - dp60
        var endX = (point.x - defaultWidth) / 2f
        val endY = (point.y - defaultHeight) / 3F//中部偏上

        if (isRtl()) {
            endX = -endX
        }


        floatingMenu.x = startX //- dp276 * (1 - 0.18F*2)
        floatingMenu.y = startY  //- dp276 * (1 - 0.18F*2)
        floatingMenu.pivotX = 0f

        val animatorSet = AnimatorSet()
        animatorSet.playTogether(scaleX1, scaleY1, alpha1)


        /****************************/
        val scaleX2 = ObjectAnimator.ofFloat(floatingMenu, "scaleX", 0.18F, 1F)
        val scaleY2 = ObjectAnimator.ofFloat(floatingMenu, "scaleY", 0.18F, 1F)

        val alpha2 = ObjectAnimator.ofFloat(floatingMenu, "alpha", 0.3F, 1F)


        val translationX =
            ObjectAnimator.ofFloat(floatingMenu, "translationX", startX, endX)
        val translationY =
            ObjectAnimator.ofFloat(floatingMenu, "translationY", startY, endY)


        val animatorSet2 = AnimatorSet()
        animatorSet2.playTogether(scaleX2, scaleY2, alpha2, translationX, translationY)
        /****************************/

        val anims = AnimatorSet()
        animatorSet.duration = 40
        animatorSet2.duration = 200
        anims.play(animatorSet).before(animatorSet2)

        anims.interpolator = AccelerateDecelerateInterpolator()

        anims.start()
    }

    private fun isRtl(): Boolean {
        return TextUtils.getLayoutDirectionFromLocale(Locale.getDefault()) == View.LAYOUT_DIRECTION_RTL
    }

    private fun animMenuEnter(menuView: View) {//, mx: Float, my: Float
        val floatingMenu = menuView.findViewById<View>(R.id.floating_menu)

        val point = menuView.context.getSize()
        var endX = (point.x - defaultWidth) / 2f
        val endY = (point.y - defaultHeight) / 3F//中部偏上

        if (isRtl()) {
            endX = -endX
        }

        floatingMenu.x = endX
        floatingMenu.y = endY
        floatingMenu.pivotX = defaultWidth / 2f
        floatingMenu.pivotY = defaultHeight / 2f


        val scaleX = ObjectAnimator.ofFloat(menuView, "scaleX", 0.3F, 1F)
        val scaleY = ObjectAnimator.ofFloat(menuView, "scaleY", 0.3F, 1F)

        val alpha = ObjectAnimator.ofFloat(menuView, "alpha", 0.3F, 1F)
        val animatorSet = AnimatorSet()

        //animatorSet.play(startScaleX).with(startScaleY)

        animatorSet.playTogether(scaleX, scaleY, alpha)
        animatorSet.duration = 200
        //animatorSet.interpolator = AccelerateDecelerateInterpolator()
        animatorSet.start()

        //println("fw=$fw fh=$fh  fx=$fx  fy=$fy  mx=$mx  my=$my  mw=$mw  mh=$mh")
    }

    private fun animMenuExit(menuView: View) {//, mx: Float, my: Float

        //val mw = menuView.resources.getDimension(R.dimen.dp276)

        val scaleX = ObjectAnimator.ofFloat(menuView, "scaleX", 1F, 0.3F)
        val scaleY = ObjectAnimator.ofFloat(menuView, "scaleY", 1F, 0.3F)

        val alpha = ObjectAnimator.ofFloat(menuView, "alpha", 1F, 0F)
        val animatorSet = AnimatorSet()


        //animatorSet.play(startScaleX).with(startScaleY)

        animatorSet.playTogether(scaleX, scaleY, alpha)
        animatorSet.duration = 200


        val listener = object : Animator.AnimatorListener {
            override fun onAnimationRepeat(animation: Animator?) {
            }

            override fun onAnimationEnd(animation: Animator?) {
                removeMenuFromWindow()
            }

            override fun onAnimationCancel(animation: Animator?) {
            }

            override fun onAnimationStart(animation: Animator?) {
            }
        }
        animatorSet.addListener(listener)
        animatorSet.start()

    }


}

/**
 * 获取屏幕尺寸
 */
fun Context.getSize(): Point {
    val outSize = Point()
    val wm = getSystemService(Context.WINDOW_SERVICE) as WindowManager
    wm.defaultDisplay.getSize(outSize)
    return outSize
}

private fun Context.pendingStartActivity(action: String) {
    val intent = Intent(action)
    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
    intent.setPackage(packageName)
    val pendingIntent =
        PendingIntent.getActivity(this, 100, intent, PendingIntent.FLAG_UPDATE_CURRENT)
    //pendingIntent.send()
}

/**
 * Send Broadcast
 */
fun LocalBroadcastManager.sendAction(action: String) {
    sendBroadcast(Intent(action))
}