package com.talpa.overlay.data

import android.app.ActivityManager
import android.content.Context
import android.content.SharedPreferences
import android.view.accessibility.AccessibilityNodeInfo
import com.talpa.overlay.service.nodeText
import com.talpa.translate.kv.KeyValue

/**
 * @author CY 2019-10-14
 */

private const val PREFER_NAME = "prefer_overlay"
private const val KEY_OVERLAY_TEXT_LANGUAGE_TAG = "key_overlay_text_language_tag"
private const val KEY_OVERLAY_EDIT_TEXT_LANGUAGE_TAG = "key_overlay_edit_text_language_tag"
private const val KEY_SHOW_TIPS1 = "key_show_tips1"

private fun sharedPrefer(context: Context): SharedPreferences {
    return context.getSharedPreferences(PREFER_NAME, Context.MODE_PRIVATE)
}

/**
 * 写入文本翻译目标语言
 */
fun writeOverlayTextLanguageTag(context: Context, languageTag: String) {
    if (ActivityManager.isUserAMonkey()) {
        return
    }


    //MMKV.defaultMMKV().encode(KEY_OVERLAY_TEXT_LANGUAGE_TAG, languageTag)
    KeyValue.put(KEY_OVERLAY_TEXT_LANGUAGE_TAG, languageTag)
}

/**
 * 写入文本编辑框翻译目标语言
 */
fun writeOverlayEditTextLanguageTag(context: Context, languageTag: String) {
    if (ActivityManager.isUserAMonkey()) {
        return
    }
    //MMKV.defaultMMKV().encode(KEY_OVERLAY_EDIT_TEXT_LANGUAGE_TAG, languageTag)
    KeyValue.put(KEY_OVERLAY_EDIT_TEXT_LANGUAGE_TAG, languageTag)
}

/**
 * 读取文本翻译目标语言
 */
fun readOverlayTextLanguageTag(context: Context, defaultLanguageTag: String? = null): String? {
    if (ActivityManager.isUserAMonkey()) {
        return defaultLanguageTag
    }
    return KeyValue.get(KEY_OVERLAY_TEXT_LANGUAGE_TAG, defaultLanguageTag)
        ?: return sharedPrefer(context)
            .getString(KEY_OVERLAY_TEXT_LANGUAGE_TAG, defaultLanguageTag)?.apply {
                writeOverlayTextLanguageTag(context, this)
            }
}

/**
 * 读取文本编辑框翻译目标语言
 */
fun readOverlayEditTextLanguageTag(context: Context, defaultLanguageTag: String? = null): String? {
    if (ActivityManager.isUserAMonkey()) {
        return defaultLanguageTag
    }
    return KeyValue.get(KEY_OVERLAY_EDIT_TEXT_LANGUAGE_TAG, defaultLanguageTag)
        ?: sharedPrefer(context)
            .getString(KEY_OVERLAY_EDIT_TEXT_LANGUAGE_TAG, defaultLanguageTag)
            ?.apply {
                writeOverlayEditTextLanguageTag(context, this)
            }
}

fun writeEditNodeInfo(
    context: Context,
    text: String,
    translation: String,
    toLanguageTag: String,
    nodeInfo: AccessibilityNodeInfo
) {
    val key = "${nodeInfo.viewIdResourceName}$translation$toLanguageTag"

    if (ActivityManager.isUserAMonkey()) {
        return
    }
    KeyValue.put(key, text)

}

fun readEditNodeInfo(
    context: Context,
    nodeInfo: AccessibilityNodeInfo,
    toLanguageTag: String
): String? {

    val nodeText = nodeInfo.nodeText()

    val key = "${nodeInfo.viewIdResourceName}$nodeText$toLanguageTag"

    if (ActivityManager.isUserAMonkey()) {
        return null
    }
    return KeyValue.get(key)
}

fun writeShowTips1(showTips: Boolean) {
    KeyValue.put(KEY_SHOW_TIPS1, showTips)
}

fun readShowTips1() : Boolean {
    return KeyValue.get(KEY_SHOW_TIPS1, true) ?: true
}
