package com.talpa.overlay.tools

import android.accessibilityservice.AccessibilityService
import android.accessibilityservice.AccessibilityServiceInfo
import android.accessibilityservice.AccessibilityServiceInfo.FEEDBACK_GENERIC
import android.content.Context
import android.provider.Settings
import android.provider.Settings.Secure.ENABLED_ACCESSIBILITY_SERVICES
import android.text.TextUtils
import android.util.Log
import android.view.accessibility.AccessibilityManager
import com.talpa.overlay.service.AccessService


/**
 * https://stackoverflow.com/questions/36974898/how-to-check-accessibilityservice
 * @author CY 2019-09-09
 */

/**
 * 检测无障碍服务是否启动
 */
fun isAccessibilitySettingsOn(
    context: Context
): Boolean {

    val accessibilityManager = context.getSystemService(Context.ACCESSIBILITY_SERVICE) as AccessibilityManager
    val list: List<AccessibilityServiceInfo>? = accessibilityManager.getEnabledAccessibilityServiceList(FEEDBACK_GENERIC)
    //println("assManager.isEnabled=${assManager.isEnabled}")
    list?.let {
        it.forEach { info ->
            if (info.resolveInfo.serviceInfo.name == AccessService::class.java.name &&
                    info.resolveInfo.serviceInfo.packageName == context.packageName) {
                return info.resolveInfo.serviceInfo.enabled
            }
        }
    }

    return false
}

/**
 * 检测无障碍服务开关是否开启 1 open
 */
fun accessibilityEnabled(context: Context): Boolean {
    try {
        val accessibilityEnabled: String? = Settings.Secure.getString(
            context.applicationContext.contentResolver,
            Settings.Secure.ENABLED_ACCESSIBILITY_SERVICES
        )
        val services = accessibilityEnabled?.split(":") ?: return false
        services.forEach {
            if (it == "${context.packageName}/${AccessService::class.java.name}") {
                return true
            }
        }

        Log.v(TAG, "accessibilityEnabled = $accessibilityEnabled")
        return false
    } catch (e: Settings.SettingNotFoundException) {
        Log.e(TAG, "Error finding setting, default accessibility to not found: " + e.message)
    }
    return false
}

/**
 * 检测无障碍服务是否启动
 */
fun accessibilityServiceEnabled(
    context: Context,
    accessibility: Class<out AccessibilityService> = AccessService::class.java
): Boolean {
    Log.v(TAG, "***ACCESSIBILITY IS ENABLED*** -----------------")

    val service = context.packageName + "/" + accessibility.canonicalName

    val mStringColonSplitter = TextUtils.SimpleStringSplitter(':')


    val settingValue = Settings.Secure.getString(
        context.applicationContext.contentResolver,
        ENABLED_ACCESSIBILITY_SERVICES
    )

    if (settingValue != null) {
        mStringColonSplitter.setString(settingValue)
        while (mStringColonSplitter.hasNext()) {
            val accessibilityService = mStringColonSplitter.next()

            Log.v(TAG, "-------------- > accessibilityService :: $accessibilityService $service")
            if (accessibilityService.equals(service, ignoreCase = true)) {
                Log.v(TAG, "We've found the correct setting - accessibility is switched on!")
                return true
            }
        }
    }
    return false
}

private const val TAG = "Hi-Accessibility"