package com.talpa.overlay.translate

import android.content.Context
import android.content.SharedPreferences
import android.widget.TextView
import com.talpa.overlay.R
import com.talpa.tengine.Trans
import com.talpa.tengine.lang.LANG
import com.talpa.tengine.lang.languageTagToLangMap
import com.talpa.translate.MultiTextTranslator
import com.talpa.translator.link.translate
import com.trello.rxlifecycle3.kotlin.bindToLifecycle
import io.reactivex.Flowable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.functions.Consumer


/**
 * 局部翻译执行翻译逻辑
 */
fun translateForDetect(
    tvTranslation: TextView,
    sourceText: String,
    toLanguageTag: String,
    onNext: Consumer<Trans>
): Disposable {

    //tvTranslation.setTextColor(Color.BLACK)
    tvTranslation.text = ""//"翻译中..."

    val fromLanguage: String? = null

    val onError = Consumer<Throwable> { throwable ->
        throwable?.printStackTrace()
        val trans = Trans(from = LANG.AUTO, to = toLanguageTag, text = sourceText)
        trans.result = Trans.Result(code = Trans.ERROR_OTHER, errorMessage = throwable?.message)
        onNext.accept(trans)
    }

    return translateForTextView(
        tvTranslation,
        fromLanguage,
        toLanguageTag,
        sourceText,
        onNext,
        onError
    )

}


/**
 * 全局翻译执行翻译逻辑
 */
fun translateForAllNodes(
    tvTranslation: TextView,
    sourceText: String,
    toLanguageTag: String,
    onNext: Consumer<Trans>,
    onError: Consumer<Throwable>
): Disposable {

    //tvTranslation.textColorResource = R.color.color_floating_translation
    //tvTranslation.setText(R.string.text_translating)

    val fromLanguageTag: String? = null
    /*val toLanguage: String = Locale.ENGLISH.language*/

    //val onlyOfflineTranslate = true

    return translateForTextView(
        tvTranslation,
        fromLanguageTag,
        toLanguageTag,
        sourceText,
        onNext,
        onError
    )

}


/**
 * 输入框执行翻译逻辑
 */
fun translateForEditText(
    sourceText: String,
    toLanguageTag: String,
    onNext: Consumer<Trans>,
    onError: Consumer<Throwable>,
    context: Context
): Disposable {


    val fromLanguageTag: String? = null
    /*val toLanguage: String = Locale.ENGLISH.language*/

    /*val onNext = Consumer<Trans> { trans ->

        when (trans.result?.code) {
            Trans.SUCCESS -> {
            }
            else -> {
            }
        }
    }*/
    /*val onError = Consumer<Throwable> { throwable ->
        throwable?.printStackTrace()
    }*/

    val flow = translate(
        fromLanguageTag = fromLanguageTag,
        toLanguageTag = toLanguageTag,
        sourceText = sourceText,
        context = context
    )

    /*val onCompleted = Action {

    }*/
    /*val onSubscribe = Consumer<Subscription> { sub ->

    }*/
    return flow.subscribe(onNext, onError)//, onCompleted, onSubscribe

}


/**
 * 基于　TextView 翻译
 */
private fun translateForTextView(
    tvTranslation: TextView,
    fromLanguageTag: String? = null,
    toLanguageTag: String,
    sourceText: String,
    onNext: Consumer<Trans>,
    onError: Consumer<Throwable>,
    onlyOfflineTranslate: Boolean = false
): Disposable {

    var disposable =
        tvTranslation.getTag(R.id.id_translation_view_disposable) as? Disposable
    if (disposable?.isDisposed == false) {
        disposable.dispose()
    }

    val flow = translate(
        fromLanguageTag = fromLanguageTag,
        toLanguageTag = toLanguageTag,
        sourceText = sourceText,
        context = tvTranslation.context,
        onlyOfflineTranslate = onlyOfflineTranslate
    ).observeOn(AndroidSchedulers.mainThread())
    disposable = flow.bindToLifecycle(tvTranslation).subscribe(onNext, onError)

    tvTranslation.setTag(R.id.id_translation_view_disposable, disposable)
    return disposable
}

/**
 * Locale Language
 */
private fun translate(
    fromLanguageTag: String? = null,
    toLanguageTag: String,
    sourceText: String,
    context: Context,
    onlyOfflineTranslate: Boolean = false
): Flowable<Trans> {

    val langMap = languageTagToLangMap()

    val fromLang = if (fromLanguageTag == null) {
        LANG.AUTO
    } else {
        langMap[fromLanguageTag] ?: LANG.AUTO
    }
    val toLang = langMap[toLanguageTag] ?: LANG.EN

   /* val offlineModel: Boolean
    var onlyOffline: Boolean
    val downloadModelIfNeeded: Boolean

    if (isOfflineModel()) {
        offlineModel = true
        onlyOffline = true
        downloadModelIfNeeded = true
    } else {
        offlineModel = context.readOfflineMode()
        onlyOffline = false
        downloadModelIfNeeded = false
    }

    if (onlyOfflineTranslate) {
        onlyOffline = onlyOfflineTranslate
    }*/

    val trans = Trans(fromLang, toLang, sourceText)
    return context.translate(trans)
}

//private fun Context.readOfflineMode(defValue: Boolean = true): Boolean {
//    val prefer = getSettingSharedPreferences()
//    return prefer.getBoolean("prefer_offline_mode", defValue)
//}

//fun Context.getSettingSharedPreferences(): SharedPreferences {
//    val sharedName = "${packageName}_preferences"
//    return getSharedPreferences(sharedName, Context.MODE_PRIVATE)
//}


