package com.talpa.overlay.view.overlay

import android.annotation.SuppressLint
import android.app.PendingIntent
import android.content.ActivityNotFoundException
import android.content.Context
import android.content.Intent
import android.graphics.Color
import android.graphics.Rect
import android.text.TextUtils
import android.util.Log
import android.view.*
import android.view.accessibility.AccessibilityNodeInfo
import android.widget.*
import androidx.core.content.ContextCompat
import androidx.core.view.updateLayoutParams
import com.talpa.overlay.R
import com.talpa.overlay.data.readOverlayTextLanguageTag
import com.talpa.overlay.data.readShowTips1
import com.talpa.overlay.data.writeShowTips1
import com.talpa.overlay.databinding.LayoutContentViewFirstBinding
import com.talpa.overlay.databinding.LayoutContentViewNormalBinding
import com.talpa.overlay.service.nodeText
import com.talpa.overlay.state.FloatingStateMachine
import com.talpa.overlay.state.FloatingStateMachine.grammarCheckEnable
import com.talpa.overlay.view.SmoothMovement
import com.talpa.tengine.STORE
import com.talpa.tengine.Trans
import com.talpa.tengine.UNKNOWN
import com.talpa.tengine.lang.LANG
import com.talpa.translate.network.TransResponse
import com.talpa.translate.ocr.result.OcrResult
import com.talpa.translate.repository.box.translate.CombinedTrans
import com.trello.rxlifecycle3.kotlin.bindToLifecycle
import org.jetbrains.anko.find
import org.jetbrains.anko.textColorResource
import java.util.*

/**
 *
 * @author CY 2019-10-22
 */
class GeneralOverlayView(context: Context) : OverlayImpl(context), View.OnClickListener,
    GestureDetector.OnGestureListener {

    companion object {
        /**
         * Click Copy Locale Broadcast Action
         */
        const val ACTION_CLICK_COPY = "ACTION_CLICK_COPY"
        const val ACTION_CLICK_PLAY = "ACTION_CLICK_PLAY"
        const val ACTION_CLICK_FAVOR = "ACTION_CLICK_FAVOR"
        const val ACTION_CLICK_SHARE = "ACTION_CLICK_SHARE"
        const val ACTION_LONG_CLICK = "ACTION_LONG_CLICK"
    }

    private val rectInScreen = Rect()

    private lateinit var bindingNormal: LayoutContentViewNormalBinding

    /**
     * 创建内容视图
     */
    @SuppressLint("ClickableViewAccessibility")
    override fun createContentView(): View {
        bindingNormal = LayoutContentViewNormalBinding.inflate(LayoutInflater.from(context))

        bindingNormal.root.setOnBackClickListener = object : BaseOverlayView.BackClickListener {
            override fun onBackClickListener(): Boolean {
                try {
                    if (bindingNormal.root.isAttachedToWindow) {
                        removeContentView()
                        //windowManager.removeView(view)
                        return true
                    } else {
                        return false
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
                return false
            }

        }

        bindingNormal.root.setOnTouchListener { v, event ->

            when (event.action) {
                MotionEvent.ACTION_OUTSIDE -> {
                    removeContentView()
                }
            }

            return@setOnTouchListener false
        }

        bindingNormal.btnCopy.setOnClickListener(this)
        bindingNormal.btnVoice.setOnClickListener(this)
        bindingNormal.btnStar.setOnClickListener(this)
        bindingNormal.btnShared.setOnClickListener(this)
        bindingNormal.btnSettingLanguage.setOnClickListener(this)

        return bindingNormal.root

    }

    override fun addContentView(x: Int, y: Int) {
        super.addContentView(x, y)
        val params = overlayParams(contentView.layoutParams as? WindowManager.LayoutParams)
        params.x = x
        params.y = y

        contentView.visibility = View.GONE

        /*if (grammarCheckEnable) {
            bindingNormal.cardView.setCardBackgroundColor(ContextCompat.getColor(context, R.color.normal_general_grammar_card_color))
        } else {
            bindingNormal.cardView.setCardBackgroundColor(ContextCompat.getColor(context, R.color.normal_general_card_color))
        }*/

        try {
            if (!contentView.isAttachedToWindow) {
                windowManager.addView(contentView, params)
            } else {
                windowManager.updateViewLayout(contentView, params)
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    fun updateTransFailed(location: Rect) {
        val originLoc = contentView.getTag(R.id.id_content_view_node_info) as? Rect
        if (originLoc == location) {
            bindingNormal.tvTranslation.setText(R.string.text_translating_error)
            hideProgressBar(contentView)
        }
    }

    fun updateTransResult(index: Int, location: Rect, ocrResult: OcrResult?, response: TransResponse?) {
        val originLoc = contentView.getTag(R.id.id_content_view_node_info) as? Rect
        if (originLoc == location) {
            val voice = contentView.findViewById<View>(R.id.btn_voice)
            val copy = contentView.findViewById<View>(R.id.btn_copy)
            val star = contentView.findViewById<CheckBox>(R.id.btn_star)
            val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)
            /*val menu = contentView.find<View>(R.id.ll_menu)
            menu.visibility = View.VISIBLE*/

            if (textSpeech.isLanguageAvailable(
                    Locale.forLanguageTag(
                        readOverlayTextLanguageTag(
                            context
                        ) ?: LANG.EN
                    )
                )
            ) {
                voice.visibility = View.VISIBLE
            }

            //  val translation = trans.result?.translation
            if (response == null) {
                tvTranslation.setText(R.string.translate_fail)
            } else {
                val stringBuilder = StringBuilder()
                response.result?.texts?.forEachIndexed { index, s ->
                    stringBuilder.append(s)
                    if (index < response.result?.texts?.size?.minus(1) ?: 0) {
                        stringBuilder.append(",")
                    }
                }
                /*if (stringBuilder.isNotBlank()) {
                    stringBuilder.dropLast(1)
                }*/
                if (stringBuilder.isNotEmpty()) {
                    copy.setTag(R.id.id_translation_view_trans_result, stringBuilder.toString())
                    copy.visibility = View.VISIBLE
                }
                star.visibility = View.VISIBLE
                star.isChecked = false
                tvTranslation.text = stringBuilder.toString()
                tvTranslation.textColorResource = R.color.color_floating_translation
                tvTranslation.setTag(R.id.id_translation_view_trans_result, tvTranslation.text)
            }

            val tvContent = contentView.findViewById<TextView>(R.id.tv_content)

            val size = ocrResult?.blocks?.size ?: 0
            val sb = StringBuilder(ocrResult?.blocks?.get(index)?.text ?: return)

            /*ocrResult?.blocks?.forEachIndexed { index, block ->
                sb.append(block.text)
                if (index < size - 1) {
                    sb.append(",")
                }
            }*/
            val text = sb.toString()
            tvContent.text = text

            tvTranslation.movementMethod = SmoothMovement(context)

            hideProgressBar(contentView)
        }
    }

    fun updateContentView(rect: Rect) {
        if (!contentView.isAttachedToWindow) {
            val params = overlayParams(contentView.layoutParams as? WindowManager.LayoutParams)
            try {
                windowManager.addView(contentView, params)
            } catch (e: Exception) {
                e.printStackTrace()
            }

        }

        //println("contentView==${contentView.parent}")
        val tempNode = contentView.getTag(R.id.id_content_view_node_info)
        if (tempNode == rect && contentView.visibility == View.VISIBLE) {

            return
        }

        contentView.findViewById<TextView>(R.id.tv_translation).setText("")
        contentView.findViewById<TextView>(R.id.tv_content).setText("")
        contentView.findViewById<View>(R.id.loading_progress_bar).visibility = View.VISIBLE
        contentView.setTag(R.id.id_content_view_node_info, rect)
        if (contentView.visibility != View.VISIBLE) {
            contentView.visibility = View.VISIBLE
        }
        //println("nodeInfo#hashCode=${nodeInfo.hashCode()}")
        val contentParams = contentView.layoutParams as WindowManager.LayoutParams

        //val width = screenSize.x - R.dimen.dp24 * 2
        contentParams.width = WindowManager.LayoutParams.MATCH_PARENT
        contentParams.height = WindowManager.LayoutParams.WRAP_CONTENT//200
        contentParams.gravity = Gravity.TOP or Gravity.START
        //contentParams.horizontalMargin=0.5f//context.resources.getDimension(R.dimen.dp80)
        //val tvContent = contentView.findViewById<TextView>(R.id.tv_content)

        //val text = "123"
        //tvContent.text = text

        contentParams.y = contentViewY(rect)
        try {
            windowManager.updateViewLayout(contentView, contentParams)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    @SuppressLint("ClickableViewAccessibility")
    override fun updateContentView(nodeInfo: AccessibilityNodeInfo) {

        if (!contentView.isAttachedToWindow) {
            val params = overlayParams(contentView.layoutParams as? WindowManager.LayoutParams)
            try {
                windowManager.addView(contentView, params)
            } catch (e: Exception) {
                e.printStackTrace()
            }

        }

        //println("contentView==${contentView.parent}")
        val tempNode = contentView.getTag(R.id.id_content_view_node_info)
        if (tempNode == nodeInfo && contentView.visibility == View.VISIBLE) {

            return
        }

        contentView.setTag(R.id.id_content_view_node_info, nodeInfo)
        if (contentView.visibility != View.VISIBLE) {
            contentView.visibility = View.VISIBLE
        }
        //println("nodeInfo#hashCode=${nodeInfo.hashCode()}")
        val contentParams = contentView.layoutParams as WindowManager.LayoutParams

        //val width = screenSize.x - R.dimen.dp24 * 2
        contentParams.width = WindowManager.LayoutParams.MATCH_PARENT
        contentParams.height = WindowManager.LayoutParams.WRAP_CONTENT//200
        contentParams.gravity = Gravity.TOP or Gravity.START
        //contentParams.horizontalMargin=0.5f//context.resources.getDimension(R.dimen.dp80)
        val tvContent = contentView.findViewById<TextView>(R.id.tv_content)

        val text = nodeInfo.nodeText()
        tvContent.text = text


        val sourceText = text.toString().trim()
        if (!TextUtils.isEmpty(sourceText)) {

            val packageName = nodeInfo.packageName?.toString() ?: ""

            val targetLanguageTag = readOverlayTextLanguageTag(context) ?: LANG.EN
            //targetLanguageTag
            //    ?: throw Exception("please set text translate targetLanguage,to see writeOverlayTextLanguageTag()")
            preTranslate()
            dealNodeInfo(sourceText, targetLanguageTag, packageName, grammarCheckEnable)
        }

        contentParams.y = contentViewY(nodeInfo)

        try {
            windowManager.updateViewLayout(contentView, contentParams)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    override fun removeContentView() {
        if (contentView.isAttachedToWindow) {
            //windowManager.removeView(contentView)
            try {
                bindingNormal.tvTranslation.movementMethod = null
                //bindingNormal.llMenu.visibility = View.GONE
                //bindingNormal.tvContent.visibility = View.GONE
                windowManager.removeViewImmediate(contentView)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }

        super.removeContentView()
    }

    private fun contentViewY(rect: Rect): Int {

        contentView.measure(0, 0)

        //nodeInfo.getBoundsInScreen(rectInScreen)
        val rectViewY: Int = rect.top
        val rectViewHeight: Int = rect.height()
        val contentViewHeight: Int = contentView.measuredHeight
        val yOffset = context.resources.getDimension(R.dimen.dp30).toInt()

        val topHeight = contentViewHeight + yOffset

        val bottomHeight = rectViewHeight + yOffset

        var y = rectViewY - topHeight

        if (y <= 0) {
            y = rectViewY + bottomHeight
        }

        return y
    }

    /**
     * 计算内容视图Y轴
     */
    private fun contentViewY(nodeInfo: AccessibilityNodeInfo): Int {

        contentView.measure(0, 0)


        nodeInfo.getBoundsInScreen(rectInScreen)
        val rectViewY: Int = rectInScreen.top
        val rectViewHeight: Int = rectInScreen.height()
        val contentViewHeight: Int = contentView.measuredHeight
        val yOffset = context.resources.getDimension(R.dimen.dp30).toInt()

        val topHeight = contentViewHeight + yOffset

        val bottomHeight = rectViewHeight + yOffset

        var y = rectViewY - topHeight

        if (y <= 0) {
            y = rectViewY + bottomHeight
        }

        return y
    }


    /**
     * 处理节点信息
     */
    private fun dealNodeInfo(sourceText: String, targetLanguageTag: String, packageName: String, needGrammarCheck: Boolean) {

        val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)

        tvTranslation.text = ""

        logStartTranslate(
            sourceText = sourceText,
            targetLanguageTag = targetLanguageTag,
            packageName = packageName
        )

        /**
         *  it.text,
         *  it.translation,
         *  it.sourceLanguageLocaleTag,
         *  it.targetLanguageLocaleTag,
         *  it.star
         */
        val d = readTranslateHistory(sourceText, targetLanguageTag)
            .bindToLifecycle(tvTranslation)
            .subscribe({

                if (!TextUtils.isEmpty(it.text) && !TextUtils.isEmpty(it.translation)) {

                    //val (text, translation, sourceLanguageLocaleTag, targetLanguageLocaleTag, isChecked) = it
                    postTranslate(
                        sourceText,
                        it.targetLanguageTag,
                        it.translation,
                        it.star
                    )
                    logSuccessTranslate(
                        sourceText = sourceText,
                        sourceLanguage = it.sourceLanguageTag,
                        targetLanguage = it.targetLanguageTag,
                        packageName = packageName,
                        isCached = true,
                        source = STORE
                    )
                } else {
                    translate(sourceText, targetLanguageTag, packageName, needGrammarCheck)
                }
            }, {
                translate(sourceText, targetLanguageTag, packageName, needGrammarCheck)
            })
    }


    private fun translate(sourceText: String, targetLanguageTag: String, packageName: String, needGrammarCheck: Boolean) {

        val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)

//        if (!context.isNetworkConnected()) {
//            tvTranslation.setText(R.string.network_no_connect)
//            tvTranslation.textColorResource = R.color.color_floating_failure
//            hideProgressBar(contentView)
//            return
//        }


        //  val targetLanguageTag = readOverlayTextLanguageTag(tvTranslation.context) ?: return
        val onSuccess = { combinedTrans: CombinedTrans ->
            val translation = combinedTrans.trans?.result?.translation
            if (!TextUtils.isEmpty(translation)) {
                postTranslate(sourceText, targetLanguageTag, translation!!, isStar = false)
                val sourceLanguage = combinedTrans.trans?.result!!.detectLang ?: "AUTO"
                logSuccessTranslate(
                    sourceText = sourceText,
                    sourceLanguage = sourceLanguage,
                    targetLanguage = targetLanguageTag,
                    packageName = packageName,
                    source = combinedTrans.trans?.result?.source ?: UNKNOWN
                )

            } else {
                hideProgressBar(contentView)
            }

        }

        val onError = { combinedTrans: CombinedTrans ->
            logFailTranslate(
                sourceText = sourceText,
                targetLanguageTag = targetLanguageTag,
                packageName = packageName,
                errorMessage = combinedTrans.trans?.result?.errorMessage ?: "unknown"
            )
            hideProgressBar(contentView)
        }
        translateForOverlayText(tvTranslation, sourceText, targetLanguageTag, onSuccess, onError, needGrammarCheck)
    }

    private fun showProgressBar(contentView: View?) {
        bindingNormal.loadingProgressBar.visibility = View.VISIBLE
    }

    private fun hideProgressBar(contentView: View?) {
        bindingNormal.loadingProgressBar.visibility = View.GONE
    }

    /**
     * 翻译前
     */
    private fun preTranslate() {

        bindingNormal.llMenu.visibility = View.GONE
        bindingNormal.tvTranslation.setText("")
        bindingNormal.tvContent.text = ""

        showProgressBar(contentView)
    }

    /**
     * 翻译后
     */
    private fun postTranslate(
        sourceText: String,
        targetLanguageTag: String,
        translation: String,
        isStar: Boolean
    ) {
        bindingNormal.tvContent.setText(sourceText)
        val menu = contentView.find<View>(R.id.ll_menu)
        menu.visibility = View.VISIBLE

        if (textSpeech.isLanguageAvailable(Locale.forLanguageTag(targetLanguageTag))) {
            bindingNormal.btnVoice.visibility = View.VISIBLE
        } else {
            bindingNormal.btnVoice.visibility = View.GONE
        }

        //  val translation = trans.result?.translation
        if (!TextUtils.isEmpty(translation)) {
            bindingNormal.btnCopy.setTag(R.id.id_translation_view_trans_result, translation)
            bindingNormal.btnCopy.visibility = View.VISIBLE
        }
        bindingNormal.btnStar.visibility = View.VISIBLE
        bindingNormal.btnStar.isChecked = isStar

        bindingNormal.tvTranslation.setText(translation)
        bindingNormal.tvTranslation.textColorResource = R.color.color_floating_translation
        bindingNormal.tvTranslation.setTag(R.id.id_translation_view_trans_result, translation)

        bindingNormal.tvTranslation.movementMethod = SmoothMovement(context)
            .also {
                //it.setGestureListener(this)
            }

        hideProgressBar(contentView)
    }

    override fun onClick(v: View?) {

        when (v?.id) {
            R.id.btn_copy -> {


                val translation = v.getTag(R.id.id_translation_view_trans_result) as String
                val intent = Intent("BROADCAST_ACTION_CLIPBOARD_TEXT")
                intent.putExtra("label", "floating")
                intent.putExtra("text", translation)

                Toast.makeText(
                    context.applicationContext,
                    R.string.text_copy_success,
                    Toast.LENGTH_SHORT
                ).show()

                localBroadcastManager.sendBroadcast(intent)
                localBroadcastManager.sendBroadcast(Intent(ACTION_CLICK_COPY))
            }
            R.id.btn_voice -> {
                val tvTranslation = bindingNormal.tvTranslation
                val languageTag = readOverlayTextLanguageTag(context)
                if (languageTag != null) {

                    if (!textSpeech.isSpeaking()) {
                        val state =
                            textSpeech.speak(tvTranslation.text.toString(), Locale.forLanguageTag(languageTag))
                        if (!state) {
                            Toast.makeText(
                                context.applicationContext,
                                R.string.playback_error,
                                Toast.LENGTH_SHORT
                            )
                                .show()
                        }
                    } else {
                        textSpeech.stopSpeak()
                    }

                }

                localBroadcastManager.sendBroadcast(Intent(ACTION_CLICK_PLAY))
            }
            R.id.btn_star -> {


                val isChecked = (v as Checkable).isChecked

                val tvContent = contentView.findViewById<TextView>(R.id.tv_content)
                val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)
                val text = tvContent.text.toString().trim()
                val translation = tvTranslation.text.toString().trim()

                updateTranslateHistory(text, translation, isChecked)

                localBroadcastManager.sendBroadcast(Intent(ACTION_CLICK_FAVOR))
            }
            R.id.btn_setting_language -> {
                val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)
                val sourceText = tvTranslation.text.toString()
            }
            R.id.btn_shared -> {
                //send()
                //val intent = Intent(Intent.ACTION_SEND)
                val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)
                val sourceText = tvTranslation.text.toString()
                v.context.pendingShare(sourceText)

                localBroadcastManager.sendBroadcast(Intent(ACTION_CLICK_SHARE))
                v.postDelayed(this::removeContentView, 400)
            }
        }
    }

    override fun onDown(e: MotionEvent?): Boolean {
        return false
    }

    override fun onShowPress(e: MotionEvent?) {

    }

    override fun onSingleTapUp(e: MotionEvent): Boolean {
        /*if (readShowTips1() && binding.bubble.visibility == View.GONE) {
            if (!isTouchPointInView(binding.card, e.rawX.toInt(), e.rawY.toInt())) {
                if (binding.root.isAttachedToWindow) {
                    removeContentView()
                    //windowManager.removeView(view)
                }
            }
        }*/
        return true
    }

    override fun onScroll(
        e1: MotionEvent?,
        e2: MotionEvent?,
        distanceX: Float,
        distanceY: Float
    ): Boolean {
        return true
    }

    override fun onLongPress(e: MotionEvent) {
        localBroadcastManager.sendBroadcast(Intent(ACTION_LONG_CLICK))
        if (bindingNormal.llMenu.visibility == View.VISIBLE) {
            bindingNormal.llMenu.visibility = View.GONE
        } else {
            bindingNormal.llMenu.visibility = View.VISIBLE
        }
        if (bindingNormal.tvContent.visibility == View.VISIBLE) {
            bindingNormal.tvContent.visibility = View.GONE
        } else {
            bindingNormal.tvContent.visibility = View.VISIBLE
        }

    }

    /**
     * (x,y)是否在view的区域内
     *
     * @param view
     * @param x
     * @param y
     * @return
     */
/*    private fun isTouchPointInView(view: View, x: Int, y: Int): Boolean {
        val location = IntArray(2)
        view.getLocationOnScreen(location)
        val left = location[0]
        val top = location[1]
        val right = left + view.measuredWidth
        val bottom = top + view.measuredHeight

        return y in top..bottom && x >= left && x <= right
    }*/

    override fun onFling(
        e1: MotionEvent?,
        e2: MotionEvent?,
        velocityX: Float,
        velocityY: Float
    ): Boolean {
        return true
    }

}

fun Context.pendingShare(text: String, subject: String = ""): Boolean {
    return try {
        val intent = Intent(Intent.ACTION_SEND)
        intent.type = "text/plain"
        intent.putExtra(Intent.EXTRA_SUBJECT, subject)
        intent.putExtra(Intent.EXTRA_TEXT, text)
        val selectIntent = Intent.createChooser(intent, null)
        selectIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        val pendingIntent =
            PendingIntent.getActivity(this, 100, selectIntent, PendingIntent.FLAG_CANCEL_CURRENT)
        pendingIntent.send()
        true
    } catch (e: ActivityNotFoundException) {
        e.printStackTrace()
        false
    }
}
