package com.talpa.translate.activity

import android.content.Context
import android.content.Intent
import android.media.projection.MediaProjectionManager
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.talpa.overlay.view.FloatingContainer.Companion.STATE_INITIALIZE
import com.talpa.overlay.view.FloatingContainer.Companion.STATE_PERMISSION_GRANTED
import com.talpa.translate.RecordTranslation
import com.talpa.translate.alert.AlertView
import com.talpa.translate.alert.OnItemClickListener
import com.talpa.translate.base.utils.TB_screen_trans_dialog
import com.talpa.translate.base.utils.logEvent
import com.talpa.translate.service.RecordService

/**
 * Create by chenjunsheng on 2021/6/15
 */
class ScreenRecordActivity : AppCompatActivity() {
    companion object {
        fun start(context: Context) {
            val intent = Intent(context, ScreenRecordActivity::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK
            context.startActivity(intent)
        }
        const val REQUEST_CODE = 100
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        AlertView(this, object : OnItemClickListener {
            override fun onConfirm(view: AlertView) {
                view.dismissImmediately()
                val projectionManager =
                    getSystemService(MEDIA_PROJECTION_SERVICE) as MediaProjectionManager
                val captureIntent = projectionManager.createScreenCaptureIntent()
                startActivityForResult(captureIntent, REQUEST_CODE)
                //logEvent(TB_screen_trans_dialog, "state", "YES")
            }

            override fun onCancel(view: AlertView) {
                logEvent(TB_screen_trans_dialog, "state", "NO")
                view.dismiss()
                RecordTranslation.mCurrentState = STATE_INITIALIZE
                //PhotoTranslateController.getCaptureManager()?.setCurrentState(STATE_INITIALIZE)
                finish()
            }

        }).show()
    }

    override fun finish() {
        super.finish()
        overridePendingTransition(android.R.anim.fade_in,android.R.anim.fade_out)
    }

    override fun onBackPressed() {
        super.onBackPressed()
        logEvent(TB_screen_trans_dialog, "state", "NO")
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (data == null) {
            logEvent(TB_screen_trans_dialog, "state", "NO")
            //PhotoTranslateController.getCaptureManager()?.setCurrentState(STATE_INITIALIZE)
            RecordTranslation.mCurrentState = STATE_INITIALIZE
            finish()
            return
        }

        startRecordService(this, resultCode, data)
        RecordTranslation.mCurrentState = STATE_PERMISSION_GRANTED
        //PhotoTranslateController.getCaptureManager()?.setCurrentState(STATE_PERMISSION_GRANTED)
        //RecordManager.startRecord(this, resultCode, data)
        logEvent(TB_screen_trans_dialog, "state", "YES")
        finish()
    }

    private fun startRecordService(context: Context, resultCode: Int, data: Intent) {
        val serviceIntent = Intent(context, RecordService::class.java)
        serviceIntent.putExtra(RecordService.PROJECT_INTENT, data)
        serviceIntent.putExtra(RecordService.PROJECT_CODE, resultCode)
        context.applicationContext.bindService(serviceIntent, RecordTranslation, Context.BIND_AUTO_CREATE)
    }
}