package com.talpa.overlay.view.overlay

import android.content.Context
import android.graphics.Rect
import android.text.TextUtils
import android.util.Log
import android.view.Gravity
import android.view.MotionEvent
import android.view.View
import android.view.WindowManager
import android.view.accessibility.AccessibilityNodeInfo
import android.widget.ProgressBar
import android.widget.TextView
import com.talpa.overlay.R
import com.talpa.overlay.data.readOverlayTextLanguageTag
import com.talpa.overlay.service.nodeText
import com.talpa.tengine.STORE
import com.talpa.tengine.Trans
import com.talpa.tengine.UNKNOWN
import com.talpa.tengine.lang.LANG
import com.talpa.translate.network.TransResponse
import com.talpa.translate.ocr.result.OcrResult
import com.trello.rxlifecycle3.kotlin.bindToLifecycle
import org.jetbrains.anko.find
import org.jetbrains.anko.layoutInflater
import org.jetbrains.anko.textColorResource
import org.w3c.dom.Text
import java.lang.StringBuilder

/**
 * @author CY 2019-10-21
 */
open class SimpleOverlayView(context: Context) : OverlayImpl(context), View.OnClickListener {

    override fun createContentView(): View {
        val view = context.layoutInflater.inflate(R.layout.layout_content_view_simple, null)
        view.setOnTouchListener { v, event ->

            when (event.action) {
                MotionEvent.ACTION_OUTSIDE -> {
                    removeContentView()
                }
            }

            return@setOnTouchListener false
        }
        return view
    }

    override fun addContentView(x: Int, y: Int) {
        super.addContentView(x, y)
        val params = overlayParams(contentView.layoutParams as? WindowManager.LayoutParams)
        params.x = x
        params.y = y

        contentView.visibility = View.GONE
        try {
            if (!contentView.isAttachedToWindow) {
                windowManager.addView(contentView, params)
            } else {
                windowManager.updateViewLayout(contentView, params)
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    fun updateContentView(bounds: Rect) {
        if (!contentView.isAttachedToWindow) {

            try {
                windowManager.addView(contentView, contentView.layoutParams)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        val tempNode = contentView.getTag(R.id.id_content_view_node_info)
        if (tempNode == bounds && contentView.visibility == View.VISIBLE) {

            return
        }

        contentView.setTag(R.id.id_content_view_node_info, bounds)

        if (contentView.visibility != View.VISIBLE) {
            contentView.visibility = View.VISIBLE
        }

        //val bounds = Rect()
        //nodeInfo.getBoundsInScreen(bounds)

        val contentParams = contentView.layoutParams as WindowManager.LayoutParams
        contentParams.width = bounds.width()//WindowManager.LayoutParams.MATCH_PARENT
        contentParams.height = bounds.height()//WindowManager.LayoutParams.WRAP_CONTENT//200
        contentParams.x = bounds.left
        contentParams.y = bounds.top
        contentParams.gravity = Gravity.TOP or Gravity.START

        //val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)


        try {
            /*val sourceText = nodeInfo.nodeText().toString().trim()//nodeInfo.text.toString()
            if (!TextUtils.isEmpty(sourceText)) {
                val packageName = nodeInfo.packageName?.toString() ?: ""
                val targetLanguageTag =
                    readOverlayTextLanguageTag(context)?: LANG.EN //Locale.ENGLISH.toLanguageTag()
                //targetLanguageTag
                //    ?: throw Exception("please set text translate targetLanguage,to see writeOverlayTextLanguageTag()")
                dealNodeInfo(sourceText, targetLanguageTag, packageName)
            }*/
            preTranslate()
            windowManager.updateViewLayout(contentView, contentParams)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    fun updateTransResult(location: Rect, ocrResult: OcrResult?, response: TransResponse) {
        val originLoc = contentView.getTag(R.id.id_content_view_node_info) as? Rect
        if (originLoc == location) {
            val stringBuilder = StringBuilder()
            response.result?.texts?.forEach {
                stringBuilder.append(it)
                stringBuilder.append("\n")
            }
            if (stringBuilder.isNotBlank()) {
                stringBuilder.dropLast(1)
            }
            Log.d("cjslog", "trans result:${stringBuilder.toString()}")
            val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)
            tvTranslation.text = stringBuilder.toString()
            tvTranslation.textColorResource = R.color.color_floating_translation
            tvTranslation.setTag(R.id.id_translation_view_trans_result, tvTranslation.text)

            hideProgressBar(contentView)

            //postTranslate(translation, targetLanguageTag, tvTranslation)
            Log.d("cjslog", "draw result")
        }
    }

    override fun updateContentView(nodeInfo: AccessibilityNodeInfo) {
        if (!contentView.isAttachedToWindow) {

            try {
                windowManager.addView(contentView, contentView.layoutParams)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        val tempNode = contentView.getTag(R.id.id_content_view_node_info)
        if (tempNode == nodeInfo && contentView.visibility == View.VISIBLE) {

            return
        }

        contentView.setTag(R.id.id_content_view_node_info, nodeInfo)

        if (contentView.visibility != View.VISIBLE) {
            contentView.visibility = View.VISIBLE
        }

        val bounds = Rect()
        nodeInfo.getBoundsInScreen(bounds)

        val contentParams = contentView.layoutParams as WindowManager.LayoutParams
        contentParams.width = bounds.width()//WindowManager.LayoutParams.MATCH_PARENT
        contentParams.height = bounds.height()//WindowManager.LayoutParams.WRAP_CONTENT//200
        contentParams.x = bounds.left
        contentParams.y = bounds.top
        contentParams.gravity = Gravity.TOP or Gravity.START

        //val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)


        try {
            val sourceText = nodeInfo.nodeText().toString().trim()//nodeInfo.text.toString()
            if (!TextUtils.isEmpty(sourceText)) {
                val packageName = nodeInfo.packageName?.toString() ?: ""
                val targetLanguageTag =
                    readOverlayTextLanguageTag(context)?: LANG.EN //Locale.ENGLISH.toLanguageTag()
                //targetLanguageTag
                //    ?: throw Exception("please set text translate targetLanguage,to see writeOverlayTextLanguageTag()")
                dealNodeInfo(sourceText, targetLanguageTag, packageName)
            }
            windowManager.updateViewLayout(contentView, contentParams)
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    override fun removeContentView() {
        if (contentView.isAttachedToWindow) {
            try {
                windowManager.removeViewImmediate(contentView)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        super.removeContentView()
    }

    override fun onClick(v: View?) {
    }

    private fun showProgressBar(contentView: View?) {
        val progressBar = contentView?.find<ProgressBar>(R.id.loading_progress_bar)
        progressBar?.visibility = View.VISIBLE
    }

    private fun hideProgressBar(contentView: View?) {
        val progressBar = contentView?.find<ProgressBar>(R.id.loading_progress_bar)
        progressBar?.visibility = View.GONE
    }

    /**
     * 翻译前
     */
    private fun preTranslate() {
        showProgressBar(contentView)
    }


    /**
     * 翻译后
     */
    private fun postTranslate(translation: String, targetLanguageTag: String) {
        val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)
        tvTranslation.text = translation
        tvTranslation.textColorResource = R.color.color_floating_translation
        tvTranslation.setTag(R.id.id_translation_view_trans_result, tvTranslation.text)


        hideProgressBar(contentView)

        postTranslate(translation, targetLanguageTag, tvTranslation)
    }

    open fun postTranslate(
        translation: String,
        targetLanguageTag: String,
        tvTranslation: TextView
    ) {

    }

    private fun dealNodeInfo(sourceText: String, targetLanguageTag: String, packageName: String) {

        val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)

        preTranslate()

        logStartTranslate(
            sourceText = sourceText,
            targetLanguageTag = targetLanguageTag,
            packageName = packageName
        )

        /**
         *  it.text,
         *  it.translation,
         *  it.sourceLanguageLocaleTag,
         *  it.targetLanguageLocaleTag,
         *  it.star
         */
        val d = readTranslateHistory(sourceText, targetLanguageTag)
            .bindToLifecycle(tvTranslation)
            .subscribe({

                if (it.size == 5 && it[4] is Boolean) {

                    val (text, translation, sourceLanguageLocaleTag, targetLanguageLocaleTag, isChecked) = it

                    logSuccessTranslate(
                        sourceText = sourceText,
                        sourceLanguage = sourceLanguageLocaleTag.toString(),
                        targetLanguage = targetLanguageLocaleTag.toString(),
                        packageName = packageName,
                        isCached = true,
                        source = STORE
                    )
                    postTranslate(translation.toString(), targetLanguageTag)
                } else {
                    translate(sourceText, targetLanguageTag, packageName)
                }
            }, {
                translate(sourceText, targetLanguageTag, packageName)
            })
    }

    private fun translate(sourceText: String, targetLanguageTag: String, packageName: String) {

        val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)

        /*if (!context.isNetworkConnected()) {
            tvTranslation.setText(R.string.network_no_connect)
            tvTranslation.textColorResource = R.color.color_floating_failure
            hideProgressBar(contentView)
            return
        }*/

        val onSuccess = { trans: Trans ->
            val translation = trans.result?.translation?.trim()
            if (!TextUtils.isEmpty(translation)) {
                val sourceLanguage = trans.result!!.detectLang ?: "AUTO"
                logSuccessTranslate(
                    sourceText = sourceText,
                    sourceLanguage = sourceLanguage,
                    targetLanguage = targetLanguageTag,
                    packageName = packageName,
                    source = trans.result?.source ?: UNKNOWN
                )
                postTranslate(translation!!, targetLanguageTag)
            } else {
                hideProgressBar(contentView)
            }


        }

        val onError = { trans: Trans ->
            logFailTranslate(
                sourceText = sourceText,
                targetLanguageTag = targetLanguageTag,
                packageName = packageName,
                errorMessage = trans.result?.errorMessage ?: "unknown"
            )
            hideProgressBar(contentView)
        }
        translateForOverlayText(tvTranslation, sourceText, targetLanguageTag, onSuccess, onError)
    }
}