package com.talpa.overlay.view.overlay

import android.content.Context
import android.widget.TextView
import android.widget.Toast
import com.talpa.overlay.R
import org.jetbrains.anko.textColorResource
import java.util.*

/**
 * @author CY 2019-12-02
 */
class SpeechOverlayView(context: Context) : SimpleOverlayView(context) {

    override fun postTranslate(
        translation: String,
        targetLanguageTag: String,
        tvTranslation: TextView
    ) {
        super.postTranslate(translation, targetLanguageTag, tvTranslation)

        tvTranslation.textColorResource = R.color.color_floating_translation_speech_default

        if (textSpeech.isSpeaking()) {
            textSpeech.stopSpeak()
        }

        val locale = Locale.forLanguageTag(targetLanguageTag)

        if (textSpeech.isLanguageAvailable(locale)) {
            if (!textSpeech.speak(translation, locale)) {
                Toast.makeText(context.applicationContext, R.string.playback_error, Toast.LENGTH_SHORT).show()
            }
        }

    }

    override fun removeContentView() {
        super.removeContentView()
        if (textSpeech.isSpeaking()) {
            textSpeech.stopSpeak()
        }
    }
}