package com.talpa.overlay.tools

import android.content.Context
import android.util.Log

/**
 * Create by chenjunsheng on 2020/8/25
 */
object IntentRecord {
    /**
     * 记录用户开关悬浮球意图
     */
    const val INTENT_FLOAT_BTN_OPEN = "intent_float_btn_open"

    const val INTENT_RECORD = "intent_record"

    fun markOpenIntent(context: Context) {
        Log.d("cjslog", "markOpenIntent")
        val sp = context.getSharedPreferences(INTENT_RECORD, Context.MODE_PRIVATE)
        val edit = sp.edit()
        edit.putBoolean(INTENT_FLOAT_BTN_OPEN, true)
        edit.apply()
    }

    fun markCloseIntent(context: Context) {
        Log.d("cjslog", "markCloseIntent")
        val sp = context.getSharedPreferences(INTENT_RECORD, Context.MODE_PRIVATE)
        val edit = sp.edit()
        edit.putBoolean(INTENT_FLOAT_BTN_OPEN, false)
        edit.apply()
    }

    fun getFloatIntent(context: Context) : Boolean {
        val sp = context.getSharedPreferences(INTENT_RECORD, Context.MODE_PRIVATE)
        return sp.getBoolean(INTENT_FLOAT_BTN_OPEN, false)
    }
}