/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view;

import android.content.Context;
import android.graphics.Rect;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.ScrollingMovementMethod;
import android.text.style.ClickableSpan;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import android.widget.OverScroller;
import android.widget.TextView;
import androidx.core.view.VelocityTrackerCompat;
import androidx.core.view.ViewCompat;
import com.talpa.overlay.view.SmoothMovement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00029:B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J,\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010 2\b\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016J\u0012\u0010'\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J,\u0010(\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010 2\b\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020%H\u0016J\u0012\u0010+\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010,\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J \u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020 H\u0016J&\u00102\u001a\u00020\u001e2\b\u0010.\u001a\u0004\u0018\u00010\u001a2\b\u00103\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u00010 H\u0016J\b\u00104\u001a\u00020\u0018H\u0002J\u000e\u00105\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u0002J\u0010\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0018\u00010\u0014R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/talpa/overlay/view/SmoothMovement;", "Landroid/text/method/ScrollingMovementMethod;", "Landroid/view/GestureDetector$OnGestureListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mContext", "mGestureDetector", "Landroid/view/GestureDetector;", "mGestureListener", "mLastTouchY", "", "mMaxFlingVelocity", "mMinFlingVelocity", "mScrollPointerId", "mScrollState", "mTouchSlop", "mVelocityTracker", "Landroid/view/VelocityTracker;", "mViewFlinger", "Lcom/talpa/overlay/view/SmoothMovement$ViewFlinger;", "sQuinticInterpolator", "Landroid/view/animation/Interpolator;", "constrainScrollBy", "", "view", "Landroid/widget/TextView;", "dx", "dy", "onDown", "", "e", "Landroid/view/MotionEvent;", "onFling", "e1", "e2", "velocityX", "", "velocityY", "onLongPress", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "onTouchEvent", "widget", "buffer", "Landroid/text/Spannable;", "event", "onTrackballEvent", "text", "resetTouch", "setGestureListener", "listener", "setScrollState", "state", "Companion", "ViewFlinger", "overlay_hwRelease"})
public final class SmoothMovement
extends ScrollingMovementMethod
implements GestureDetector.OnGestureListener {
    private Context mContext;
    private int mScrollState;
    private int mScrollPointerId;
    private VelocityTracker mVelocityTracker;
    private int mLastTouchY;
    private final int mTouchSlop;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    private ViewFlinger mViewFlinger;
    private GestureDetector mGestureDetector;
    private GestureDetector.OnGestureListener mGestureListener;
    private final Interpolator sQuinticInterpolator;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    public static final int INVALID_POINTER = -1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void setGestureListener(@NotNull GestureDetector.OnGestureListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.mGestureListener = listener2;
    }

    private final void setScrollState(int state) {
        block2: {
            if (state == this.mScrollState) {
                return;
            }
            this.mScrollState = state;
            if (state == 2) break block2;
            ViewFlinger viewFlinger = this.mViewFlinger;
            if (viewFlinger != null) {
                viewFlinger.stop();
            }
        }
    }

    private final void constrainScrollBy(TextView view, int dx, int dy) {
        int dx2 = dx;
        int dy2 = dy;
        Rect viewport = new Rect();
        view.getGlobalVisibleRect(viewport);
        int height = viewport.height();
        int width = viewport.width();
        int scrollX = view.getScrollX();
        int scrollY = view.getScrollY();
        if (view.getWidth() - scrollX - dx2 < width) {
            dx2 = view.getWidth() - scrollX - width;
        }
        if (-scrollX - dx2 > 0) {
            dx2 = -scrollX;
        }
        Layout layout2 = view.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)layout2, (String)"view.layout");
        if (layout2.getHeight() + view.getPaddingBottom() + view.getPaddingTop() - scrollY - dy2 < height) {
            Layout layout3 = view.getLayout();
            Intrinsics.checkNotNullExpressionValue((Object)layout3, (String)"view.layout");
            dy2 = layout3.getHeight() + view.getPaddingBottom() + view.getPaddingTop() - scrollY - height;
        }
        if (scrollY + dy2 < 0) {
            dy2 = -scrollY;
        }
        view.scrollBy(dx2, dy2);
    }

    public boolean onTouchEvent(@NotNull TextView widget, @NotNull Spannable buffer, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.mGestureDetector.onTouchEvent(event);
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        if (this.mViewFlinger == null) {
            this.mViewFlinger = new ViewFlinger(widget);
        }
        boolean eventAddedToVelocityTracker = false;
        int action = event.getActionMasked();
        int actionIndex = event.getActionIndex();
        MotionEvent vtev = MotionEvent.obtain((MotionEvent)event);
        switch (action) {
            case 0: {
                this.setScrollState(0);
                this.mScrollPointerId = event.getPointerId(0);
                this.mLastTouchY = (int)(event.getY() + 0.5f);
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= widget.getTotalPaddingLeft();
                y -= widget.getTotalPaddingTop();
                Layout layout2 = widget.getLayout();
                int line = layout2.getLineForVertical(y += widget.getScrollY());
                int off = layout2.getOffsetForHorizontal(line, (float)(x += widget.getScrollX()));
                ClickableSpan[] links = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
                Intrinsics.checkNotNullExpressionValue((Object)links, (String)"links");
                ClickableSpan[] clickableSpanArray = links;
                boolean bl = false;
                ClickableSpan[] clickableSpanArray2 = clickableSpanArray;
                boolean bl2 = false;
                if (!(!(clickableSpanArray2.length == 0))) break;
                ClickableSpan link = links[0];
                Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link), (int)buffer.getSpanEnd((Object)link));
                break;
            }
            case 5: {
                this.mScrollPointerId = event.getPointerId(actionIndex);
                this.mLastTouchY = (int)(event.getY(actionIndex) + 0.5f);
                break;
            }
            case 2: {
                int index = event.findPointerIndex(this.mScrollPointerId);
                if (index < 0) {
                    Log.e((String)"cjslog", (String)("Error processing scroll; pointer index for id " + String.valueOf(this.mScrollPointerId) + " not found. Did any MotionEvents get skipped?"));
                    return false;
                }
                int y = (int)(event.getY(index) + 0.5f);
                int dy = this.mLastTouchY - y;
                if (this.mScrollState != 1) {
                    boolean startScroll = false;
                    if (Math.abs(dy) > this.mTouchSlop) {
                        dy = dy > 0 ? (dy -= this.mTouchSlop) : (dy += this.mTouchSlop);
                        startScroll = true;
                    }
                    if (startScroll) {
                        this.setScrollState(1);
                    }
                }
                if (this.mScrollState != 1) break;
                this.mLastTouchY = y;
                this.constrainScrollBy(widget, 0, dy);
                break;
            }
            case 6: {
                if (event.getPointerId(actionIndex) != this.mScrollPointerId) break;
                int newIndex = actionIndex == 0 ? 1 : 0;
                this.mScrollPointerId = event.getPointerId(newIndex);
                this.mLastTouchY = (int)(event.getY(newIndex) + 0.5f);
                break;
            }
            case 1: {
                ClickableSpan links;
                if (this.mScrollState == 1) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker);
                    velocityTracker.addMovement(vtev);
                    eventAddedToVelocityTracker = true;
                    VelocityTracker velocityTracker2 = this.mVelocityTracker;
                    Intrinsics.checkNotNull((Object)velocityTracker2);
                    velocityTracker2.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                    float yVelocity = -VelocityTrackerCompat.getYVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mScrollPointerId);
                    float f = yVelocity = Math.abs(yVelocity) < (float)this.mMinFlingVelocity ? 0.0f : Math.max(-((float)this.mMaxFlingVelocity), Math.min(yVelocity, (float)this.mMaxFlingVelocity));
                    if (yVelocity != 0.0f) {
                        ViewFlinger viewFlinger = this.mViewFlinger;
                        if (viewFlinger != null) {
                            viewFlinger.fling((int)yVelocity);
                        }
                    } else {
                        this.setScrollState(0);
                    }
                    this.resetTouch();
                    break;
                }
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= widget.getTotalPaddingLeft();
                y -= widget.getTotalPaddingTop();
                Layout layout3 = widget.getLayout();
                int line = layout3.getLineForVertical(y += widget.getScrollY());
                int off = layout3.getOffsetForHorizontal(line, (float)(x += widget.getScrollX()));
                ClickableSpan clickableSpan = links = (ClickableSpan)buffer.getSpans(off, off, ClickableSpan.class);
                Intrinsics.checkNotNullExpressionValue((Object)clickableSpan, (String)"links");
                ClickableSpan link = clickableSpan;
                boolean bl = false;
                ClickableSpan clickableSpan2 = link;
                boolean bl3 = false;
                if (!(!(((ClickableSpan[])clickableSpan2).length == 0))) break;
                link = links[0];
                link.onClick((View)widget);
                break;
            }
            case 3: {
                this.resetTouch();
                break;
            }
        }
        if (!eventAddedToVelocityTracker) {
            VelocityTracker velocityTracker = this.mVelocityTracker;
            if (velocityTracker != null) {
                velocityTracker.addMovement(vtev);
            }
        }
        vtev.recycle();
        return true;
    }

    private final void resetTouch() {
        if (this.mVelocityTracker != null) {
            VelocityTracker velocityTracker = this.mVelocityTracker;
            Intrinsics.checkNotNull((Object)velocityTracker);
            velocityTracker.clear();
        }
    }

    public boolean onTrackballEvent(@Nullable TextView widget, @Nullable Spannable text, @Nullable MotionEvent event) {
        return super.onTrackballEvent(widget, text, event);
    }

    public boolean onDown(@Nullable MotionEvent e) {
        GestureDetector.OnGestureListener onGestureListener2 = this.mGestureListener;
        return onGestureListener2 != null ? onGestureListener2.onDown(e) : false;
    }

    public void onShowPress(@Nullable MotionEvent e) {
        block0: {
            GestureDetector.OnGestureListener onGestureListener2 = this.mGestureListener;
            if (onGestureListener2 == null) break block0;
            onGestureListener2.onShowPress(e);
        }
    }

    public boolean onSingleTapUp(@Nullable MotionEvent e) {
        GestureDetector.OnGestureListener onGestureListener2 = this.mGestureListener;
        return onGestureListener2 != null ? onGestureListener2.onSingleTapUp(e) : false;
    }

    public boolean onScroll(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float distanceX, float distanceY) {
        GestureDetector.OnGestureListener onGestureListener2 = this.mGestureListener;
        return onGestureListener2 != null ? onGestureListener2.onScroll(e1, e2, distanceX, distanceY) : false;
    }

    public void onLongPress(@Nullable MotionEvent e) {
        block0: {
            GestureDetector.OnGestureListener onGestureListener2 = this.mGestureListener;
            if (onGestureListener2 == null) break block0;
            onGestureListener2.onLongPress(e);
        }
    }

    public boolean onFling(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float velocityX, float velocityY) {
        GestureDetector.OnGestureListener onGestureListener2 = this.mGestureListener;
        return onGestureListener2 != null ? onGestureListener2.onFling(e1, e2, velocityX, velocityY) : false;
    }

    public SmoothMovement(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mScrollPointerId = -1;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.mContext = context2;
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        ViewConfiguration vc = ViewConfiguration.get((Context)this.mContext);
        this.mTouchSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.sQuinticInterpolator = sQuinticInterpolator.1.INSTANCE;
    }

    public static final /* synthetic */ void access$setMContext$p(SmoothMovement $this, Context context) {
        $this.mContext = context;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\bJ\u0006\u0010\u0011\u001a\u00020\rJ\b\u0010\u0012\u001a\u00020\rH\u0016J\u0006\u0010\u0013\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/talpa/overlay/view/SmoothMovement$ViewFlinger;", "Ljava/lang/Runnable;", "mView", "Landroid/widget/TextView;", "(Lcom/talpa/overlay/view/SmoothMovement;Landroid/widget/TextView;)V", "mEatRunOnAnimationRequest", "", "mLastFlingY", "", "mReSchedulePostAnimationCallback", "mScroller", "Landroid/widget/OverScroller;", "disableRunOnAnimationRequests", "", "enableRunOnAnimationRequests", "fling", "velocityY", "postOnAnimation", "run", "stop", "overlay_hwRelease"})
    private final class ViewFlinger
    implements Runnable {
        private int mLastFlingY;
        private final OverScroller mScroller;
        private boolean mEatRunOnAnimationRequest;
        private boolean mReSchedulePostAnimationCallback;
        private TextView mView;

        @Override
        public void run() {
            this.disableRunOnAnimationRequests();
            OverScroller scroller = this.mScroller;
            if (scroller.computeScrollOffset()) {
                int y = scroller.getCurrY();
                int dy = y - this.mLastFlingY;
                this.mLastFlingY = y;
                SmoothMovement.this.constrainScrollBy(this.mView, 0, dy);
                this.postOnAnimation();
            }
            this.enableRunOnAnimationRequests();
        }

        public final void fling(int velocityY) {
            this.mLastFlingY = 0;
            SmoothMovement.this.setScrollState(2);
            this.mScroller.fling(0, 0, 0, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.postOnAnimation();
        }

        public final void stop() {
            this.mView.removeCallbacks((Runnable)this);
            this.mScroller.abortAnimation();
        }

        private final void disableRunOnAnimationRequests() {
            this.mReSchedulePostAnimationCallback = false;
            this.mEatRunOnAnimationRequest = true;
        }

        private final void enableRunOnAnimationRequests() {
            this.mEatRunOnAnimationRequest = false;
            if (this.mReSchedulePostAnimationCallback) {
                this.postOnAnimation();
            }
        }

        public final void postOnAnimation() {
            if (this.mEatRunOnAnimationRequest) {
                this.mReSchedulePostAnimationCallback = true;
            } else {
                this.mView.removeCallbacks((Runnable)this);
                ViewCompat.postOnAnimation((View)((View)this.mView), (Runnable)this);
            }
        }

        public ViewFlinger(TextView mView) {
            Intrinsics.checkNotNullParameter((Object)mView, (String)"mView");
            this.mView = mView;
            this.mScroller = new OverScroller(SmoothMovement.this.mContext, SmoothMovement.this.sQuinticInterpolator);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/talpa/overlay/view/SmoothMovement$Companion;", "", "()V", "INVALID_POINTER", "", "SCROLL_STATE_DRAGGING", "SCROLL_STATE_IDLE", "SCROLL_STATE_SETTLING", "overlay_hwRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

