/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view.overlay;

import android.content.Context;
import android.graphics.Rect;
import android.widget.TextView;
import android.widget.Toast;
import com.talpa.overlay.R;
import com.talpa.overlay.data.SharedPreferKt;
import com.talpa.overlay.view.overlay.SimpleOverlayView;
import com.talpa.translate.network.TransResponse;
import com.talpa.translate.ocr.result.OcrResult;
import com.tapla.textspeech.TextSpeech;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.CustomViewPropertiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J$\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/talpa/overlay/view/overlay/SpeechOverlayView;", "Lcom/talpa/overlay/view/overlay/SimpleOverlayView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "postTranslate", "", "translation", "", "targetLanguageTag", "tvTranslation", "Landroid/widget/TextView;", "removeContentView", "updateTransResult", "location", "Landroid/graphics/Rect;", "ocrResult", "Lcom/talpa/translate/ocr/result/OcrResult;", "response", "Lcom/talpa/translate/network/TransResponse;", "overlay_hwRelease"})
public final class SpeechOverlayView
extends SimpleOverlayView {
    @Override
    public void postTranslate(@NotNull String translation, @NotNull String targetLanguageTag, @NotNull TextView tvTranslation) {
        Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
        Intrinsics.checkNotNullParameter((Object)targetLanguageTag, (String)"targetLanguageTag");
        Intrinsics.checkNotNullParameter((Object)tvTranslation, (String)"tvTranslation");
        super.postTranslate(translation, targetLanguageTag, tvTranslation);
        CustomViewPropertiesKt.setTextColorResource((TextView)tvTranslation, (int)R.color.color_floating_translation_speech_default);
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
        Locale locale = Locale.forLanguageTag(targetLanguageTag);
        TextSpeech textSpeech2 = this.getTextSpeech();
        Locale locale2 = locale;
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"locale");
        if (textSpeech2.isLanguageAvailable(locale2) && !this.getTextSpeech().speak((CharSequence)translation, locale)) {
            Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.playback_error, (int)0).show();
        }
    }

    @Override
    public void removeContentView() {
        super.removeContentView();
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
    }

    @Override
    public void updateTransResult(@NotNull Rect location, @Nullable OcrResult ocrResult, @Nullable TransResponse response) {
        String targetLanguageTag;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super.updateTransResult(location, ocrResult, response);
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
        String string2 = targetLanguageTag = SharedPreferKt.readOverlayTextLanguageTag$default(this.getContext(), null, 2, null);
        if (string2 == null) {
            return;
        }
        Locale locale = Locale.forLanguageTag(string2);
        if (response != null) {
            StringBuilder sb = new StringBuilder();
            Object object = response.getResult();
            if (object != null && (object = object.getTexts()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    sb.append(it);
                    sb.append(",");
                }
            }
            TextSpeech textSpeech2 = this.getTextSpeech();
            Locale locale2 = locale;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"locale");
            if (textSpeech2.isLanguageAvailable(locale2)) {
                TextSpeech textSpeech3 = this.getTextSpeech();
                String string3 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sb.toString()");
                if (!textSpeech3.speak((CharSequence)string3, locale)) {
                    Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.playback_error, (int)0).show();
                }
            }
        }
    }

    public SpeechOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }
}

