package com.talpa.overlay.translate

import android.content.Context
import android.util.Log
import android.widget.TextView
import com.google.mlkit.nl.languageid.LanguageIdentification
import com.talpa.overlay.R
import com.talpa.tengine.Trans
import com.talpa.tengine.lang.LANG
import com.talpa.tengine.lang.languageTagToLangMap
import com.talpa.translate.repository.box.grammar.GrammarNew
import com.talpa.translate.repository.box.grammar.Operation
import com.talpa.translate.repository.box.grammar.ResultsV2
import com.talpa.translate.repository.box.grammar.getOperation
import com.talpa.translate.repository.box.translate.CombinedTrans
import com.talpa.translate.repository.grammar.GrammarRepo
import com.talpa.translator.link.translate
import com.trello.rxlifecycle3.kotlin.bindToLifecycle
import io.reactivex.*
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.functions.Consumer
import io.reactivex.schedulers.Schedulers
import kotlinx.coroutines.runBlocking
import java.util.*
import kotlin.coroutines.suspendCoroutine


/**
 * 局部翻译执行翻译逻辑
 */
fun translateForDetect(
    tvTranslation: TextView,
    sourceText: String,
    toLanguageTag: String,
    onNext: Consumer<CombinedTrans>,
    needGrammarCheck: Boolean
): Disposable {

    //tvTranslation.setTextColor(Color.BLACK)
    tvTranslation.text = ""//"翻译中..."

    val fromLanguage: String? = null

    val onError = Consumer<Throwable> { throwable ->
        throwable?.printStackTrace()
        val trans = Trans(from = LANG.AUTO, to = toLanguageTag, text = sourceText)
        trans.result = Trans.Result(code = Trans.ERROR_OTHER, errorMessage = throwable?.message)
        val result = CombinedTrans()
        result.trans = trans
        onNext.accept(result)
    }

    return translateForTextView(
        tvTranslation,
        fromLanguage,
        toLanguageTag,
        sourceText,
        onNext,
        onError,
        needGrammarCheck = needGrammarCheck
    )

}


/**
 * 全局翻译执行翻译逻辑
 */
fun translateForAllNodes(
    tvTranslation: TextView,
    sourceText: String,
    toLanguageTag: String,
    onNext: Consumer<CombinedTrans>,
    onError: Consumer<Throwable>,
    needGrammarCheck: Boolean
): Disposable {

    //tvTranslation.textColorResource = R.color.color_floating_translation
    //tvTranslation.setText(R.string.text_translating)

    val fromLanguageTag: String? = null
    /*val toLanguage: String = Locale.ENGLISH.language*/

    //val onlyOfflineTranslate = true

    return translateForTextView(
        tvTranslation,
        fromLanguageTag,
        toLanguageTag,
        sourceText,
        onNext,
        onError,
        needGrammarCheck = needGrammarCheck
    )

}


/**
 * 输入框执行翻译逻辑
 */
fun translateForEditText(
    sourceText: String,
    toLanguageTag: String,
    onNext: Consumer<CombinedTrans>,
    onError: Consumer<Throwable>,
    context: Context,
    needGrammarCheck: Boolean
): Disposable {


    val fromLanguageTag: String? = null
    /*val toLanguage: String = Locale.ENGLISH.language*/

    /*val onNext = Consumer<Trans> { trans ->

        when (trans.result?.code) {
            Trans.SUCCESS -> {
            }
            else -> {
            }
        }
    }*/
    /*val onError = Consumer<Throwable> { throwable ->
        throwable?.printStackTrace()
    }*/

    val flow: Flowable<CombinedTrans>

    if (needGrammarCheck) {
        flow = Flowable.create(object : FlowableOnSubscribe<String> {
            override fun subscribe(emitter: FlowableEmitter<String>) {
                emitter.onNext(runBlocking {
                    detectLanguage(sourceText)
                })
            }

        }, BackpressureStrategy.BUFFER).flatMap {
            val combinedTrans = CombinedTrans()
            combinedTrans.targetLocale = it
            if (it == "en") {
                Flowable.create(object : FlowableOnSubscribe<CombinedTrans> {
                    override fun subscribe(emitter: FlowableEmitter<CombinedTrans>) {
                        val repo = GrammarRepo()
                        val result = try {
                            runBlocking { repo.requestGrammarCheck(sourceText) }
                        } catch (e: Exception) {
                            GrammarNew(ResultsV2(emptyList()))
                        }
                        Log.d("cjslog", "grammar new:${result}")
                        emitter.onNext(combinedTrans.apply { grammarNew = result })
                    }

                }, BackpressureStrategy.BUFFER).flatMap { combinedTrans ->
                    val sb = StringBuilder()
                    if (combinedTrans.grammarNew?.results?.alerts.isNullOrEmpty()) {
                        sb.append(sourceText)
                    } else {
                        sb.append(sourceText)
                        val parseList = combinedTrans.grammarNew?.results?.alerts!!.filter {
                            !it.title.isNullOrEmpty()
                        }

                        val sortList = parseList?.sortedByDescending {
                            it.highlightBegin
                        }

                        sortList.forEach {
                            when (getOperation(it)) {
                                Operation.Replace -> {
                                    if (!it.replacements.isNullOrEmpty()) {
                                        sb.replace(
                                            it.highlightBegin,
                                            it.highlightEnd,
                                            it.replacements?.get(0) ?: ""
                                        )
                                    }
                                }
                                Operation.Add -> {
                                    if (!it.replacements.isNullOrEmpty()) {
                                        sb.indexOf(it.replacements?.get(0) ?: "", it.highlightBegin)
                                    }
                                }

                            }
                        }
                    }
                    Log.d("cjslog", "grammar new2:${sb.toString()}")
                    translate(
                        fromLanguageTag = fromLanguageTag,
                        toLanguageTag = toLanguageTag,
                        sourceText = sb.toString(),
                        context = context
                    ).flatMap {
                        Flowable.create(object : FlowableOnSubscribe<CombinedTrans> {
                            override fun subscribe(emitter: FlowableEmitter<CombinedTrans>) {
                                emitter.onNext(combinedTrans.apply {
                                    trans = it
                                })
                            }

                        }, BackpressureStrategy.BUFFER)
                    }
                }.flatMap { combinedTrans ->
                    //翻译完之后语法检查
                    combinedTrans.trans?.result?.translation?.let { grammarResult ->
                        if (toLanguageTag == Locale.ENGLISH.language) {
                            val repo = GrammarRepo()
                            val result = try {
                                runBlocking {
                                    repo.requestGrammarCheck(grammarResult)
                                }
                            } catch (e: Exception) {
                                GrammarNew(ResultsV2(emptyList()))
                            }

                            Log.d("cjslog", "grammar new3:${result}")

                            val sb = StringBuilder()
                            sb.append(grammarResult)
                            val parseList = result.results?.alerts!!.filter {
                                !it.title.isNullOrEmpty()
                            }

                            val sortList = parseList?.sortedByDescending {
                                it.highlightBegin
                            }

                            sortList.forEach {
                                when (getOperation(it)) {
                                    Operation.Replace -> {
                                        if (!it.replacements.isNullOrEmpty()) {
                                            sb.replace(
                                                it.highlightBegin,
                                                it.highlightEnd,
                                                it.replacements?.get(0) ?: ""
                                            )
                                        }
                                    }
                                    Operation.Add -> {
                                        if (!it.replacements.isNullOrEmpty()) {
                                            sb.indexOf(
                                                it.replacements?.get(0) ?: "",
                                                it.highlightBegin
                                            )
                                        }
                                    }

                                }
                            }
                            val transResult = Trans.Result(
                                code = combinedTrans.trans!!.result!!.code,
                                translation = sb.toString(),
                                errorMessage = combinedTrans.trans!!.result!!.errorMessage,
                                detectLang = combinedTrans.trans?.result!!.detectLang,
                                isCached = combinedTrans.trans?.result!!.isCached,
                                source = combinedTrans.trans?.result!!.source
                            )
                            combinedTrans.trans?.result = transResult

                        }
                    }
                    Flowable.create(object : FlowableOnSubscribe<CombinedTrans> {
                        override fun subscribe(emitter: FlowableEmitter<CombinedTrans>) {
                            Log.d("cjslog", "grammar new3:${combinedTrans}")
                            emitter.onNext(combinedTrans)
                        }

                    }, BackpressureStrategy.BUFFER)
                }
            } else {
                translate(
                    fromLanguageTag = fromLanguageTag,
                    toLanguageTag = toLanguageTag,
                    sourceText = sourceText,
                    context = context
                ).flatMap {
                    //val result = CombinedTrans()
                    Flowable.create(object : FlowableOnSubscribe<CombinedTrans> {
                        override fun subscribe(emitter: FlowableEmitter<CombinedTrans>) {
                            emitter.onNext(combinedTrans.apply {
                                trans = it
                            })
                        }

                    }, BackpressureStrategy.BUFFER)
                }
            }

        }.subscribeOn(Schedulers.io(), true)
            .observeOn(AndroidSchedulers.mainThread())
    } else {
        flow = translate(
            fromLanguageTag = fromLanguageTag,
            toLanguageTag = toLanguageTag,
            sourceText = sourceText,
            context = context
        ).map { trans ->
            return@map CombinedTrans().also {
                it.trans = trans
            }
        }
    }


    /*val onCompleted = Action {

    }*/
    /*val onSubscribe = Consumer<Subscription> { sub ->

    }*/
    return flow.subscribe(onNext, onError)//, onCompleted, onSubscribe

}

suspend fun detectLanguage(text: String) =
    suspendCoroutine<String> { continuation ->
        //logEvent(PT_ocr_with_firebase)
        val languageIdentifier = LanguageIdentification.getClient()

        languageIdentifier.identifyLanguage(text)
            .addOnSuccessListener { languageCode ->
                if (languageCode == "und") {
                    Log.i("cjslog", "Can't identify language.")
                    //emitter.onNext(languageCode)

                } else {
                    Log.i("cjslog", "Language: $languageCode")
                    //emitter.onNext(languageCode)
                }
                continuation.resumeWith(kotlin.Result.success(languageCode))
            }
            .addOnFailureListener {
                // Model couldn’t be loaded or other internal error.
                // ...
                continuation.resumeWith(kotlin.Result.failure(it))

            }
    }

/**
 * 基于　TextView 翻译
 */
private fun translateForTextView(
    tvTranslation: TextView,
    fromLanguageTag: String? = null,
    toLanguageTag: String,
    sourceText: String,
    onNext: Consumer<CombinedTrans>,
    onError: Consumer<Throwable>,
    onlyOfflineTranslate: Boolean = false,
    needGrammarCheck: Boolean
): Disposable {

    var disposable =
        tvTranslation.getTag(R.id.id_translation_view_disposable) as? Disposable
    if (disposable?.isDisposed == false) {
        disposable.dispose()
    }


    val flow = translate(
        fromLanguageTag = fromLanguageTag,
        toLanguageTag = toLanguageTag,
        sourceText = sourceText,
        context = tvTranslation.context,
        onlyOfflineTranslate = onlyOfflineTranslate
    ).map { trans ->
        CombinedTrans().also { it.trans = trans }
    }
    disposable = flow.bindToLifecycle(tvTranslation).subscribe(onNext, onError)

    tvTranslation.setTag(R.id.id_translation_view_disposable, disposable)
    return disposable
}

/**
 * Locale Language
 */
private fun translate(
    fromLanguageTag: String? = null,
    toLanguageTag: String,
    sourceText: String,
    context: Context,
    onlyOfflineTranslate: Boolean = false
): Flowable<Trans> {

    val langMap = languageTagToLangMap()

    val fromLang = if (fromLanguageTag == null) {
        LANG.AUTO
    } else {
        langMap[fromLanguageTag] ?: LANG.AUTO
    }
    val toLang = langMap[toLanguageTag] ?: LANG.EN

    /* val offlineModel: Boolean
     var onlyOffline: Boolean
     val downloadModelIfNeeded: Boolean

     if (isOfflineModel()) {
         offlineModel = true
         onlyOffline = true
         downloadModelIfNeeded = true
     } else {
         offlineModel = context.readOfflineMode()
         onlyOffline = false
         downloadModelIfNeeded = false
     }

     if (onlyOfflineTranslate) {
         onlyOffline = onlyOfflineTranslate
     }*/

    val trans = Trans(fromLang, toLang, sourceText)
    return context.translate(trans)
}

//private fun Context.readOfflineMode(defValue: Boolean = true): Boolean {
//    val prefer = getSettingSharedPreferences()
//    return prefer.getBoolean("prefer_offline_mode", defValue)
//}

//fun Context.getSettingSharedPreferences(): SharedPreferences {
//    val sharedName = "${packageName}_preferences"
//    return getSharedPreferences(sharedName, Context.MODE_PRIVATE)
//}


