/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view.alert;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.talpa.overlay.R;
import com.talpa.overlay.view.FloatingManagerKt;
import com.talpa.translate.base.view.alert.AlertAnimateUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class AlertView {
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    public static final int HORIZONTAL_BUTTONS_MAXCOUNT = 2;
    public static final int CANCELPOSITION = -1;
    private String title;
    private String msg;
    private String[] destructive;
    private String[] others;
    private List<String> mDestructive;
    private List<String> mOthers;
    private String cancel;
    private ArrayList<String> mDatas = new ArrayList();
    private WeakReference<Context> contextWeak;
    private ViewGroup contentContainer;
    private ViewGroup decorView;
    private ViewGroup rootView;
    private ViewGroup loAlertHeader;
    private OnDismissListener onDismissListener;
    private OnItemClickListener onItemClickListener;
    private boolean isShowing;
    private Animation outAnim;
    private Animation inAnim;
    private int gravity = 17;
    private LocalBroadcastManager localBroadcastManager;
    private Animation.AnimationListener outAnimListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            AlertView.this.dismissImmediately();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                AlertView.this.dismiss();
            }
            return false;
        }
    };

    public AlertView(Builder builder) {
        this.contextWeak = new WeakReference<Context>(builder.context);
        this.title = builder.title;
        this.msg = builder.msg;
        this.cancel = builder.cancel;
        this.destructive = builder.destructive;
        this.others = builder.others;
        this.onItemClickListener = builder.onItemClickListener;
        this.initViews();
        this.init();
        this.initEvents();
    }

    public AlertView(String title, String msg, String cancel, String[] destructive, String[] others, Context context, OnItemClickListener onItemClickListener) {
        this.contextWeak = new WeakReference<Context>(context);
        this.onItemClickListener = onItemClickListener;
        this.initViews();
        this.init();
        this.initEvents();
    }

    protected void initViews() {
        final Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.float_alert_view, null);
        View permission = this.rootView.findViewById(R.id.set_permission);
        permission.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent("com.talpa.overlay.service#BROADCAST_ACTION_REQUEST"));
                AlertView.this.dismiss();
            }
        });
        View close = this.rootView.findViewById(R.id.close);
        close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlertView.this.dismiss();
            }
        });
    }

    protected void init() {
        this.inAnim = this.getInAnimation();
        this.outAnim = this.getOutAnimation();
    }

    protected void initEvents() {
    }

    public AlertView addExtView(View extView) {
        this.loAlertHeader.addView(extView);
        return this;
    }

    private void onAttached(View view) {
        this.isShowing = true;
        Context context = (Context)this.contextWeak.get();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        WindowManager.LayoutParams params = FloatingManagerKt.overlayViewParams();
        params.width = -1;
        params.height = -1;
        params.x = 0;
        params.y = 0;
        params.gravity = 17;
        params.dimAmount = 0.3f;
        try {
            wm.addView(view, (ViewGroup.LayoutParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show() {
        if (this.isShowing()) {
            return;
        }
        this.onAttached((View)this.rootView);
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public void dismiss() {
        this.isShowing = false;
        Context context = (Context)this.contextWeak.get();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        try {
            wm.removeView((View)this.rootView);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismissImmediately() {
        this.decorView.removeView((View)this.rootView);
        this.isShowing = false;
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismiss(this);
        }
    }

    public Animation getInAnimation() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return null;
        }
        int res = AlertAnimateUtil.getAnimationResource((int)this.gravity, (boolean)true);
        return AnimationUtils.loadAnimation((Context)context, (int)res);
    }

    public Animation getOutAnimation() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return null;
        }
        int res = AlertAnimateUtil.getAnimationResource((int)this.gravity, (boolean)false);
        return AnimationUtils.loadAnimation((Context)context, (int)res);
    }

    public AlertView setOnDismissListener(OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
        return this;
    }

    public void setMarginBottom(int marginBottom) {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        int margin_alert_left_right = context.getResources().getDimensionPixelSize(R.dimen.margin_alert_left_right);
        this.params.setMargins(margin_alert_left_right, 0, margin_alert_left_right, marginBottom);
        this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    public AlertView setCancelable(boolean isCancelable) {
        View view = this.rootView.findViewById(R.id.outmost_container);
        if (isCancelable) {
            view.setOnTouchListener(this.onCancelableTouchListener);
        } else {
            view.setOnTouchListener(null);
        }
        return this;
    }

    public static class Builder {
        private Context context;
        private String title;
        private String msg;
        private String cancel;
        private String[] destructive;
        private String[] others;
        private OnItemClickListener onItemClickListener;

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setMessage(String msg) {
            this.msg = msg;
            return this;
        }

        public Builder setCancelText(String cancel) {
            this.cancel = cancel;
            return this;
        }

        public Builder setDestructive(String ... destructive) {
            this.destructive = destructive;
            return this;
        }

        public Builder setOthers(String[] others) {
            this.others = others;
            return this;
        }

        public Builder setOnItemClickListener(OnItemClickListener onItemClickListener) {
            this.onItemClickListener = onItemClickListener;
            return this;
        }

        public AlertView build() {
            return new AlertView(this);
        }
    }

    class OnTextClickListener
    implements View.OnClickListener {
        private int position;

        public OnTextClickListener(int position) {
            this.position = position;
        }

        public void onClick(View view) {
            if (AlertView.this.onItemClickListener != null) {
                AlertView.this.onItemClickListener.onItemClick(AlertView.this, this.position);
            }
            AlertView.this.dismiss();
        }
    }

    public static interface OnDismissListener {
        public void onDismiss(Object var1);
    }

    public static interface OnItemClickListener {
        public void onItemClick(AlertView var1, int var2);
    }
}

