package com.talpa.overlay.tools

import android.app.Activity
import android.app.AppOpsManager
import android.content.Context
import android.content.Intent
import android.os.Binder
import android.os.Build
import android.provider.Settings
import android.util.Log
import com.talpa.overlay.service.AccessService
import java.lang.reflect.Method

/**
 * @author CY 2019-10-11
 */

/**
 * 检测悬浮权限
 */
fun Context.canDrawOverlays(): Boolean {

    return when {
        Build.VERSION.SDK_INT >= Build.VERSION_CODES.M -> Settings.canDrawOverlays(
            applicationContext
        )
        isXiaoMi() -> xiaoMiAlertWindowAllowed(applicationContext)
        else -> true
    }

}

fun Context.requestAccessPermission() {
    try {
        val accessibilityIntent = Intent(Settings.ACTION_ACCESSIBILITY_SETTINGS)
        //val guideIntent = Intent(this, AccessGuideActivity::class.java)
        accessibilityIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        startActivity(accessibilityIntent)
    } catch (e: Exception) {
        e.printStackTrace()
    }
}

/**
 * 无障碍服务权限
 */
fun Context.isAccessibilityEnabled() =
    /*AccessService.isAccessibilityServiceRun && */isAccessibilitySettingsOn(applicationContext)


//        val value = "$packageName/${AccessService::class.java.name}"
//        Settings.Secure.putString(
//            contentResolver,
//            Settings.Secure.ENABLED_ACCESSIBILITY_SERVICES, value
//        )
//        Settings.Secure.putString(
//            contentResolver,
//            Settings.Secure.ACCESSIBILITY_ENABLED, "1"
//        )

//showPrivacy()

/* ****************Xiao Mi 悬浮球权限　START*******************************/

private fun isXiaoMi(): Boolean {
    return "XiaoMi".equals(Build.MANUFACTURER, true)
}

private fun xiaoMiAlertWindowAllowed(context: Context): Boolean {
    try {
        val mAppOpsService = context.getSystemService(Context.APP_OPS_SERVICE)
            ?: return true
        val localClass = mAppOpsService.javaClass
        val paramsClass = arrayOfNulls<Class<*>>(3)
        paramsClass[0] = Integer.TYPE
        paramsClass[1] = Integer.TYPE
        paramsClass[2] = String::class.java
        val mCheckOpMethod = localClass.getMethod("checkOp", *paramsClass)
        return invokeCheckOp(context, mCheckOpMethod, mAppOpsService)
    } catch (e: Exception) {
        Log.e("PermissionHelper", "isAlertWindowAllowed exception", e)
    }
    return true
}

private fun invokeCheckOp(context: Context, method: Method, appOpsService: Any): Boolean {
    try {
        val paramsValues = arrayOfNulls<Any>(3)
        paramsValues[0] = Integer.valueOf(24)
        paramsValues[1] = Integer.valueOf(Binder.getCallingUid())
        paramsValues[2] = context.packageName
        val result = method.invoke(appOpsService, *paramsValues)
        if (result != null) {
            return (result as Int).toInt() == AppOpsManager.MODE_ALLOWED
        }
    } catch (e: Exception) {
        Log.i("PermissionHelper", "invokeCheckOp exception ", e)
    }
    return true
}
/* ****************Xiao Mi 悬浮球权限　END*******************************/