package com.talpa.overlay.view.overlay

import android.content.Context
import android.content.Intent
import android.graphics.Rect
import android.text.TextUtils
import android.util.Log
import android.view.Gravity
import android.view.MotionEvent
import android.view.View
import android.view.WindowManager
import android.view.accessibility.AccessibilityNodeInfo
import android.widget.ProgressBar
import android.widget.TextView
import com.talpa.overlay.R
import com.talpa.overlay.data.readOverlayTextLanguageTag
import com.talpa.overlay.service.nodeText
import com.talpa.overlay.state.FloatingStateMachine
import com.talpa.overlay.state.FloatingStateMachine.grammarCheckEnable
import com.talpa.tengine.STORE
import com.talpa.tengine.Trans
import com.talpa.tengine.UNKNOWN
import com.talpa.tengine.lang.LANG
import com.talpa.translate.network.TransResponse
import com.talpa.translate.ocr.result.OcrResult
import com.talpa.translate.repository.box.grammar.GrammarNew
import com.talpa.translate.repository.box.translate.CombinedTrans
import com.trello.rxlifecycle3.kotlin.bindToLifecycle
import org.jetbrains.anko.find
import org.jetbrains.anko.layoutInflater
import org.jetbrains.anko.textColorResource

/**
 * @author CY 2019-10-21
 */
open class SimpleOverlayView(context: Context) : OverlayImpl(context), View.OnClickListener {

    override fun createContentView(): View {
        val view = context.layoutInflater.inflate(R.layout.layout_content_view_simple, null)

        view.setOnTouchListener { v, event ->

            when (event.action) {
                MotionEvent.ACTION_OUTSIDE -> {
                    removeContentView()
                }
            }

            return@setOnTouchListener false
        }
        (view as BaseOverlayView).setOnBackClickListener =
            object : BaseOverlayView.BackClickListener {
                override fun onBackClickListener(): Boolean {
                    try {
                        if (view.isAttachedToWindow) {
                            removeContentView()
                            return true
                        } else {
                            return false
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                    return false
                }

            }
        return view
    }

    override fun addContentView(x: Int, y: Int) {
        super.addContentView(x, y)
        if (grammarCheckEnable) {
            contentView.setBackgroundResource(R.drawable.shape_overlay_grammar_bg)
        } else {
            contentView.setBackgroundResource(R.drawable.shape_overlay_bg)
        }
        val params = overlayParams(contentView.layoutParams as? WindowManager.LayoutParams)
        params.x = x
        params.y = y

        contentView.visibility = View.GONE
        try {
            if (!contentView.isAttachedToWindow) {
                windowManager.addView(contentView, params)
            } else {
                windowManager.updateViewLayout(contentView, params)
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    fun updateTransFailed(location: Rect) {
        val originLoc = contentView.getTag(R.id.id_content_view_node_info) as? Rect
        if (location == originLoc) {
            contentView.findViewById<TextView>(R.id.tv_translation)
                .setText(R.string.text_translating_error)
            hideProgressBar(contentView)
        }
    }

    fun updateContentView(bounds: Rect) {
        if (!contentView.isAttachedToWindow) {
            try {
                windowManager.addView(contentView, contentView.layoutParams)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        val tempNode = contentView.getTag(R.id.id_content_view_node_info)
        if (tempNode == bounds && contentView.visibility == View.VISIBLE) {

            return
        }

        contentView.setTag(R.id.id_content_view_node_info, bounds)

        contentView.findViewById<TextView>(R.id.tv_translation).setText("")
        if (contentView.visibility != View.VISIBLE) {
            contentView.visibility = View.VISIBLE
        }

        //val bounds = Rect()
        //nodeInfo.getBoundsInScreen(bounds)

        val contentParams = contentView.layoutParams as WindowManager.LayoutParams
        contentParams.width = bounds.width()//WindowManager.LayoutParams.MATCH_PARENT
        contentParams.height = bounds.height()//WindowManager.LayoutParams.WRAP_CONTENT//200
        contentParams.x = bounds.left
        contentParams.y = bounds.top
        contentParams.gravity = Gravity.TOP or Gravity.START

        //val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)

        try {
            /*val sourceText = nodeInfo.nodeText().toString().trim()//nodeInfo.text.toString()
            if (!TextUtils.isEmpty(sourceText)) {
                val packageName = nodeInfo.packageName?.toString() ?: ""
                val targetLanguageTag =
                    readOverlayTextLanguageTag(context)?: LANG.EN //Locale.ENGLISH.toLanguageTag()
                //targetLanguageTag
                //    ?: throw Exception("please set text translate targetLanguage,to see writeOverlayTextLanguageTag()")
                dealNodeInfo(sourceText, targetLanguageTag, packageName)
            }*/
            preTranslate()
            windowManager.updateViewLayout(contentView, contentParams)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    open fun updateTransResult(location: Rect, response: TransResponse?) {
        val originLoc = contentView.getTag(R.id.id_content_view_node_info) as? Rect
        if (originLoc == location) {
            val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)
            if (response == null) {
                tvTranslation.setText(R.string.translate_fail)
            } else {
                val stringBuilder = StringBuilder()
                response.result?.texts?.forEach {
                    stringBuilder.append(it)
                    stringBuilder.append(",")
                }
                if (stringBuilder.isNotBlank()) {
                    stringBuilder.dropLast(1)
                }
                tvTranslation.text = stringBuilder.toString()
            }
            tvTranslation.textColorResource = R.color.color_floating_translation
            tvTranslation.setTag(R.id.id_translation_view_trans_result, tvTranslation.text)
            hideProgressBar(contentView)

            if (grammarCheckEnable) {
                response?.grammarNew?.let { grammarNew ->
                    grammarDetailView.measure(
                        View.MeasureSpec.makeMeasureSpec(
                            0,
                            View.MeasureSpec.UNSPECIFIED
                        ), View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED)
                    )

                    val params = overlayParams(grammarDetailView.layoutParams as? WindowManager.LayoutParams)

                    params.width = grammarDetailView.measuredWidth
                    params.height = grammarDetailView.measuredHeight
                    params.x = location.left + location.width() - grammarDetailView.measuredWidth
                    params.y = location.top - GRAMMAR_PADDING_TOP - grammarDetailView.measuredHeight
                    if (!grammarDetailView.isAttachedToWindow) {
                        windowManager.addView(grammarDetailView, params)
                    } else {
                        windowManager.updateViewLayout(grammarDetailView, params)
                    }
                    grammarDetailView.setOnClickListener {
                        it.context.startActivity(Intent(GRAMMAR_CHECK_RESULT).apply {
                            putExtra(GRAMMAR_RESULT, grammarNew)
                            putExtra(GRAMMAR_SOURCE, response.sourceText)
                            addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                        })
                        removeContentView()
                    }
                }
            }
        }
    }

    override fun updateContentView(nodeInfo: AccessibilityNodeInfo) {
        if (!contentView.isAttachedToWindow) {
            try {
                windowManager.addView(contentView, contentView.layoutParams)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        val tempNode = contentView.getTag(R.id.id_content_view_node_info)
        if (tempNode == nodeInfo && contentView.visibility == View.VISIBLE) {

            return
        }

        contentView.setTag(R.id.id_content_view_node_info, nodeInfo)

        if (contentView.visibility != View.VISIBLE) {
            contentView.visibility = View.VISIBLE
        }

        val bounds = Rect()
        nodeInfo.getBoundsInScreen(bounds)

        val contentParams = contentView.layoutParams as WindowManager.LayoutParams
        contentParams.width = bounds.width()//WindowManager.LayoutParams.MATCH_PARENT
        contentParams.height = bounds.height()//WindowManager.LayoutParams.WRAP_CONTENT//200
        contentParams.x = bounds.left
        contentParams.y = bounds.top
        contentParams.gravity = Gravity.TOP or Gravity.START

        //val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)

        try {
            val sourceText = nodeInfo.nodeText().toString().trim()//nodeInfo.text.toString()
            if (!TextUtils.isEmpty(sourceText)) {
                val packageName = nodeInfo.packageName?.toString() ?: ""
                val targetLanguageTag =
                    readOverlayTextLanguageTag(context) ?: LANG.EN //Locale.ENGLISH.toLanguageTag()
                //targetLanguageTag
                //    ?: throw Exception("please set text translate targetLanguage,to see writeOverlayTextLanguageTag()")
                dealNodeInfo(sourceText, targetLanguageTag, packageName, nodeInfo, grammarCheckEnable)
            }
            windowManager.updateViewLayout(contentView, contentParams)

        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

    override fun removeContentView() {
        if (contentView.isAttachedToWindow) {
            try {
                windowManager.removeViewImmediate(contentView)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        if (grammarDetailView.isAttachedToWindow) {
            try {
                windowManager.removeViewImmediate(grammarDetailView)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        super.removeContentView()
    }

    override fun onClick(v: View?) {}

    private fun showProgressBar(contentView: View?) {
        val progressBar = contentView?.find<ProgressBar>(R.id.loading_progress_bar)
        progressBar?.visibility = View.VISIBLE
    }

    private fun hideProgressBar(contentView: View?) {
        val progressBar = contentView?.find<ProgressBar>(R.id.loading_progress_bar)
        progressBar?.visibility = View.GONE
    }

    /**
     * 翻译前
     */
    private fun preTranslate() {
        showProgressBar(contentView)
    }

    /**
     * 翻译后
     */
    private fun postTranslate(
        sourceText: String,
        translation: String,
        targetLanguageTag: String,
        nodeInfo: AccessibilityNodeInfo,
        combinedTrans: CombinedTrans? = null
    ) {
        val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)
        tvTranslation.text = translation
        tvTranslation.textColorResource = R.color.color_floating_translation
        tvTranslation.setTag(R.id.id_translation_view_trans_result, tvTranslation.text)

        hideProgressBar(contentView)

        postTranslate(translation, targetLanguageTag, tvTranslation)

        if (grammarCheckEnable) {
            combinedTrans?.grammarNew?.let { grammarNew ->
                //grammarDetailView.visibility = View.VISIBLE
                grammarDetailView.setOnClickListener {
                    it.context.startActivity(Intent(GRAMMAR_CHECK_RESULT).apply {
                        putExtra(GRAMMAR_RESULT, grammarNew)
                        putExtra(GRAMMAR_SOURCE, sourceText)
                        addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                    })
                    removeContentView()
                }

            } ?: let {
                grammarDetailView.visibility = View.INVISIBLE
                combinedTrans?.targetLocale?.let {
                    if (!"en".equals(it)) {
                        grammarDetailView.setText(R.string.eng_support)
                    }
                } ?: let {
                    grammarDetailView.setText(R.string.grammar_check_error)
                }

            }

            grammarDetailView.measure(
                View.MeasureSpec.makeMeasureSpec(
                    0,
                    View.MeasureSpec.UNSPECIFIED
                ), View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED)
            )

            val bounds = Rect()
            nodeInfo.getBoundsInScreen(bounds)

            val params = overlayParams(grammarDetailView.layoutParams as? WindowManager.LayoutParams)

            params.width = grammarDetailView.measuredWidth
            params.height = grammarDetailView.measuredHeight
            params.x = bounds.left + bounds.width() - grammarDetailView.measuredWidth
            params.y = bounds.top - GRAMMAR_PADDING_TOP - grammarDetailView.measuredHeight
            if (!grammarDetailView.isAttachedToWindow) {
                //grammarDetailView.visibility = View.INVISIBLE
                windowManager.addView(grammarDetailView, params)
            }
        }

    }

    open fun postTranslate(
        translation: String,
        targetLanguageTag: String,
        tvTranslation: TextView
    ) {

    }

    private fun dealNodeInfo(
        sourceText: String,
        targetLanguageTag: String,
        packageName: String,
        nodeInfo: AccessibilityNodeInfo,
        needGrammarCheck: Boolean
    ) {

        val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)

        preTranslate()

        logStartTranslate(
            sourceText = sourceText,
            targetLanguageTag = targetLanguageTag,
            packageName = packageName
        )

        /**
         *  it.text,
         *  it.translation,
         *  it.sourceLanguageLocaleTag,
         *  it.targetLanguageLocaleTag,
         *  it.star
         */
        val d = readTranslateHistory(sourceText, targetLanguageTag)
            .bindToLifecycle(tvTranslation)
            .subscribe({

                if (it.size == 5 && it[4] is Boolean) {

                    val (text, translation, sourceLanguageLocaleTag, targetLanguageLocaleTag, isChecked) = it

                    logSuccessTranslate(
                        sourceText = sourceText,
                        sourceLanguage = sourceLanguageLocaleTag.toString(),
                        targetLanguage = targetLanguageLocaleTag.toString(),
                        packageName = packageName,
                        isCached = true,
                        source = STORE
                    )
                    postTranslate(sourceText, translation.toString(), targetLanguageTag, nodeInfo)
                } else {
                    translate(sourceText, targetLanguageTag, packageName, nodeInfo, needGrammarCheck)
                }
            }, {
                translate(sourceText, targetLanguageTag, packageName, nodeInfo, needGrammarCheck)
            })
    }

    private fun translate(
        sourceText: String,
        targetLanguageTag: String,
        packageName: String,
        nodeInfo: AccessibilityNodeInfo,
        needGrammarCheck: Boolean
    ) {

        val tvTranslation = contentView.findViewById<TextView>(R.id.tv_translation)

        /*if (!context.isNetworkConnected()) {
            tvTranslation.setText(R.string.network_no_connect)
            tvTranslation.textColorResource = R.color.color_floating_failure
            hideProgressBar(contentView)
            return
        }*/

        val onSuccess = { combinedTrans: CombinedTrans ->
            val translation = combinedTrans.trans?.result?.translation?.trim()
            if (!TextUtils.isEmpty(translation)) {
                val sourceLanguage = combinedTrans.trans?.result!!.detectLang ?: "AUTO"
                logSuccessTranslate(
                    sourceText = sourceText,
                    sourceLanguage = sourceLanguage,
                    targetLanguage = targetLanguageTag,
                    packageName = packageName,
                    source = combinedTrans.trans?.result?.source ?: UNKNOWN
                )
                postTranslate(sourceText, translation!!, targetLanguageTag, nodeInfo, combinedTrans)
            } else {
                hideProgressBar(contentView)
            }


        }

        val onError = { combinedTrans: CombinedTrans ->
            logFailTranslate(
                sourceText = sourceText,
                targetLanguageTag = targetLanguageTag,
                packageName = packageName,
                errorMessage = combinedTrans.trans?.result?.errorMessage ?: "unknown"
            )
            hideProgressBar(contentView)
        }
        translateForOverlayText(
            tvTranslation,
            sourceText,
            targetLanguageTag,
            onSuccess,
            onError,
            needGrammarCheck
        )
    }
}