/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.service;

import android.accessibilityservice.AccessibilityService;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Build;
import android.os.Message;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.VideoView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.talpa.overlay.RxRelay;
import com.talpa.overlay.data.SharedPreferKt;
import com.talpa.overlay.service.AccessService;
import com.talpa.overlay.service.AccessServiceKt;
import com.talpa.overlay.service.AccessibilityServiceState;
import com.talpa.overlay.state.FloatingStateMachine;
import com.talpa.overlay.tools.PermissionHelperKt;
import com.talpa.overlay.view.FloatingManager;
import com.zaz.translate.log.LoggerKt;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0001MB\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020#0*j\b\u0012\u0004\u0012\u00020#`+H\u0002J\"\u0010,\u001a\u0012\u0012\u0004\u0012\u00020#0-j\b\u0012\u0004\u0012\u00020#`.2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\b\u0010/\u001a\u00020\nH\u0002J\b\u00100\u001a\u00020%H\u0002J\u0010\u00101\u001a\u00020%2\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020%H\u0002J\b\u00105\u001a\u00020%H\u0002J\b\u00106\u001a\u00020%H\u0002J\b\u00107\u001a\u00020%H\u0002J\u0010\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020\u0005H\u0002J(\u0010:\u001a\u00020%2\u0006\u0010&\u001a\u00020#2\u0016\u0010;\u001a\u0012\u0012\u0004\u0012\u00020#0-j\b\u0012\u0004\u0012\u00020#`.H\u0002J\u0012\u0010<\u001a\u00020%2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\b\u0010?\u001a\u00020%H\u0016J\b\u0010@\u001a\u00020%H\u0016J\u0010\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u00020\u0007H\u0014J\b\u0010C\u001a\u00020%H\u0016J\u0012\u0010D\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u0010E\u001a\u00020%H\u0014J\"\u0010F\u001a\u00020\u00072\b\u00102\u001a\u0004\u0018\u0001032\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u0007H\u0016J\u0012\u0010I\u001a\u00020\n2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\b\u0010J\u001a\u00020%H\u0016J \u0010K\u001a\u00020\n2\u0016\u0010;\u001a\u0012\u0012\u0004\u0012\u00020#0-j\b\u0012\u0004\u0012\u00020#`.H\u0002J\b\u0010L\u001a\u00020%H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001bj\b\u0012\u0004\u0012\u00020\u0005`\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0012\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/talpa/overlay/service/AccessService;", "Landroid/accessibilityservice/AccessibilityService;", "Ljava/lang/Runnable;", "()V", "currentAction", "", "currentWindowId", "", "Ljava/lang/Integer;", "isAccessibilityEvent", "", "lastPackageName", "", "localBroadcastManager", "Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "getLocalBroadcastManager", "()Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "localBroadcastManager$delegate", "Lkotlin/Lazy;", "mainScope", "Lkotlinx/coroutines/CoroutineScope;", "getMainScope", "()Lkotlinx/coroutines/CoroutineScope;", "mainScope$delegate", "multiDisposable", "Lio/reactivex/disposables/Disposable;", "nodeRectSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getNodeRectSet", "()Ljava/util/HashSet;", "nodeRectSet$delegate", "pointNodeBound", "Landroid/graphics/Rect;", "rootNodeInfo", "Landroid/view/accessibility/AccessibilityNodeInfo;", "findNodeByPoint", "", "nodeInfo", "x", "y", "nodeInfoList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "findNodes", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "floatingVisible", "handleActionDown", "handleActionPoint", "intent", "Landroid/content/Intent;", "handleActionStartMultiNode", "handleActionStartSingleMultiNode", "handleActionStopMultiNode", "invisibleFloating", "log", "message", "nodeCate", "nodeSet", "onAccessibilityEvent", "event", "Landroid/view/accessibility/AccessibilityEvent;", "onCreate", "onDestroy", "onGesture", "gestureId", "onInterrupt", "onRebind", "onServiceConnected", "onStartCommand", "flags", "startId", "onUnbind", "run", "shouldRefresh", "visibleFloating", "Companion", "ht-overlay_release"})
@StabilityInferred(parameters=0)
public final class AccessService
extends AccessibilityService
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Rect pointNodeBound = new Rect();
    @Nullable
    private String currentAction;
    @Nullable
    private Disposable multiDisposable;
    private boolean isAccessibilityEvent;
    @Nullable
    private AccessibilityNodeInfo rootNodeInfo;
    @Nullable
    private CharSequence lastPackageName;
    @NotNull
    private final Lazy nodeRectSet$delegate = LazyKt.lazy((Function0)nodeRectSet.2.INSTANCE);
    @Nullable
    private Integer currentWindowId;
    @NotNull
    private final Lazy localBroadcastManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LocalBroadcastManager>(this){
        final /* synthetic */ AccessService this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final LocalBroadcastManager invoke() {
            return LocalBroadcastManager.getInstance((Context)this.this$0.getApplicationContext());
        }
    }));
    @NotNull
    private final Lazy mainScope$delegate = LazyKt.lazy((Function0)mainScope.2.INSTANCE);
    public static final int $stable = 8;
    @NotNull
    public static final String TAG = "AccessService";
    @NotNull
    private static final String ACTION_DOWN = "com.talpa.overlay.core.AccessService#ACTION_DOWN";
    @NotNull
    private static final String ACTION_POINT = "com.talpa.overlay.core.AccessService#ACTION_POINT";
    @NotNull
    private static final String ACTION_NODES_START = "com.talpa.overlay.core.AccessService#ACTION_NODES_START";
    @NotNull
    private static final String ACTION_NODES_STOP = "com.talpa.overlay.core.AccessService#ACTION_NODES_STOP";
    @NotNull
    private static final String EXTRA_POINT_X = "point_x";
    @NotNull
    private static final String EXTRA_POINT_Y = "point_y";
    @NotNull
    public static final String BROADCAST_ACTION_SERVICE_CONNECTED = "com.talpa.overlay.service#BROADCAST_ACTION_CONNECTED";
    @NotNull
    private static final String BROADCAST_ACTION_UN_BIND = "com.talpa.overlay.service#BROADCAST_ACTION_UN_BIND";
    @NotNull
    private static final String BROADCAST_ACTION_RE_BIND = "com.talpa.overlay.service#BROADCAST_ACTION_RE_BIND";
    @NotNull
    public static final String BROADCAST_ACTION_DESTROY = "com.talpa.overlay.service#BROADCAST_ACTION_DESTROY";
    @NotNull
    public static final String BROADCAST_ACTION_PACKAGE_CHANGED = "com.talpa.overlay.service#BROADCAST_ACTION_PACKAGE_CHANGED";
    @NotNull
    public static final String EXTRA_PACKAGE_NAME = "extra_package_name";
    private static final long MILLIS_DELAY = 1000L;
    private static boolean isAccessibilityServiceRun;
    @Nullable
    private static CharSequence currentPackageName;
    @NotNull
    private static final String BROADCAST_ACTION_FLOATING_OPEN = "BROADCAST_ACTION_FLOATING_OPEN";
    @NotNull
    private static final String BROADCAST_ACTION_FLOATING_CLOSE = "BROADCAST_ACTION_FLOATING_CLOSE";

    private final HashSet<String> getNodeRectSet() {
        Lazy lazy = this.nodeRectSet$delegate;
        boolean bl = false;
        return (HashSet)lazy.getValue();
    }

    private final LocalBroadcastManager getLocalBroadcastManager() {
        Lazy lazy = this.localBroadcastManager$delegate;
        boolean bl = false;
        return (LocalBroadcastManager)lazy.getValue();
    }

    private final void log(String message) {
        LoggerKt.log$default((boolean)false, (String)TAG, (String)message, null, (int)9, null);
    }

    private final CoroutineScope getMainScope() {
        Lazy lazy = this.mainScope$delegate;
        boolean bl = false;
        return (CoroutineScope)lazy.getValue();
    }

    public void onCreate() {
        super.onCreate();
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        Intent intent2 = intent;
        this.currentAction = intent2 == null ? null : intent2.getAction();
        BuildersKt.launch$default((CoroutineScope)this.getMainScope(), (CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(intent, this, null){
            int label;
            final /* synthetic */ Intent $intent;
            final /* synthetic */ AccessService this$0;
            {
                this.$intent = $intent;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string2;
                        ResultKt.throwOnFailure((Object)object);
                        Intent intent = this.$intent;
                        String string3 = string2 = intent == null ? null : intent.getAction();
                        if (string2 == null) return Unit.INSTANCE;
                        int n = -1;
                        switch (string2.hashCode()) {
                            case 2015780739: {
                                if (string2.equals("com.talpa.overlay.core.AccessService#ACTION_NODES_START")) {
                                    n = 1;
                                }
                                break;
                            }
                            case -1458995039: {
                                if (string2.equals("com.talpa.overlay.core.AccessService#ACTION_NODES_STOP")) {
                                    n = 2;
                                }
                                break;
                            }
                            case -1322867937: {
                                if (string2.equals("com.talpa.overlay.core.AccessService#ACTION_POINT")) {
                                    n = 3;
                                }
                                break;
                            }
                            case -1151408877: {
                                if (string2.equals("com.talpa.overlay.core.AccessService#ACTION_DOWN")) {
                                    n = 4;
                                }
                                break;
                            }
                        }
                        switch (n) {
                            case 3: {
                                AccessService.access$handleActionPoint(this.this$0, this.$intent);
                                return Unit.INSTANCE;
                            }
                            case 1: {
                                AccessService.access$handleActionStartSingleMultiNode(this.this$0);
                                return Unit.INSTANCE;
                            }
                            case 2: {
                                AccessService.access$handleActionStopMultiNode(this.this$0);
                                return Unit.INSTANCE;
                            }
                            case 4: {
                                AccessService.access$handleActionDown(this.this$0);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return super.onStartCommand(intent, flags, startId);
    }

    private final void handleActionPoint(Intent intent) {
        int x = intent.getIntExtra(EXTRA_POINT_X, -1);
        int y = intent.getIntExtra(EXTRA_POINT_Y, -1);
        AccessibilityNodeInfo nodeInfo = this.getRootInActiveWindow();
        if (x != -1 && y != -1 && nodeInfo != null) {
            ArrayList<AccessibilityNodeInfo> nodeInfoList = new ArrayList<AccessibilityNodeInfo>();
            this.findNodeByPoint(nodeInfo, x, y, nodeInfoList);
        }
    }

    private final void handleActionStartSingleMultiNode() {
        this.handleActionStopMultiNode();
        AccessibilityNodeInfo accessibilityNodeInfo = this.rootNodeInfo();
        if (accessibilityNodeInfo != null) {
            AccessibilityNodeInfo accessibilityNodeInfo2 = accessibilityNodeInfo;
            boolean bl = false;
            boolean bl2 = false;
            AccessibilityNodeInfo it = accessibilityNodeInfo2;
            boolean bl3 = false;
            BuildersKt.launch$default((CoroutineScope)this.getMainScope(), (CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, it, null){
                int label;
                final /* synthetic */ AccessService this$0;
                final /* synthetic */ AccessibilityNodeInfo $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            LinkedHashSet nodes = AccessService.access$findNodes(this.this$0, this.$it);
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((LinkedHashSet<AccessibilityNodeInfo>)nodes, null){
                                int label;
                                final /* synthetic */ LinkedHashSet<AccessibilityNodeInfo> $nodes;
                                {
                                    this.$nodes = $nodes;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Message message = Message.obtain(null, (int)20, this.$nodes);
                                            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"obtain(null, EVENT_NODE_INFO_MULTI, nodes)");
                                            RxRelay.INSTANCE.postByEventBus(message);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private final void handleActionStartMultiNode() {
        this.handleActionStopMultiNode();
        Function mapper1 = arg_0 -> AccessService.handleActionStartMultiNode$lambda-1(this, arg_0);
        Predicate predicate = arg_0 -> AccessService.handleActionStartMultiNode$lambda-2(this, arg_0);
        Function mapper2 = arg_0 -> AccessService.handleActionStartMultiNode$lambda-3(this, arg_0);
        long initialDelay = 0L;
        this.multiDisposable = Flowable.interval((long)initialDelay, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS).onBackpressureLatest().map(mapper1).filter(AccessService::handleActionStartMultiNode$lambda-4).map(AccessService::handleActionStartMultiNode$lambda-5).takeWhile(predicate).map(mapper2).filter(arg_0 -> AccessService.handleActionStartMultiNode$lambda-6(this, arg_0)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doOnNext(AccessService::handleActionStartMultiNode$lambda-7).subscribe(AccessService::handleActionStartMultiNode$lambda-8, Throwable::printStackTrace);
    }

    private final void handleActionStopMultiNode() {
        Disposable disposable = this.multiDisposable;
        if (Intrinsics.areEqual((Object)(disposable == null ? null : Boolean.valueOf(disposable.isDisposed())), (Object)false) && (disposable = this.multiDisposable) != null) {
            disposable.dispose();
        }
        if ((disposable = this.rootNodeInfo) != null) {
            disposable.recycle();
        }
        this.rootNodeInfo = null;
        this.getNodeRectSet().clear();
        this.lastPackageName = null;
    }

    private final void handleActionDown() {
        Disposable dis = Flowable.create(arg_0 -> AccessService.handleActionDown$lambda-9(this, arg_0), (BackpressureStrategy)BackpressureStrategy.LATEST).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(AccessService::handleActionDown$lambda-10, Throwable::printStackTrace);
    }

    private final AccessibilityNodeInfo rootNodeInfo() {
        CharSequence nodePackage;
        AccessibilityNodeInfo nodeInfo;
        AccessibilityNodeInfo accessibilityNodeInfo = this.rootNodeInfo;
        AccessibilityNodeInfo accessibilityNodeInfo2 = nodeInfo = accessibilityNodeInfo == null ? this.getRootInActiveWindow() : accessibilityNodeInfo;
        CharSequence charSequence = nodePackage = accessibilityNodeInfo2 == null ? null : accessibilityNodeInfo2.getPackageName();
        if (nodePackage != null && !Intrinsics.areEqual((Object)nodePackage, (Object)currentPackageName)) {
            this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_PACKAGE_CHANGED).putExtra(EXTRA_PACKAGE_NAME, nodePackage));
            currentPackageName = nodePackage;
        }
        return nodeInfo;
    }

    private final LinkedHashSet<AccessibilityNodeInfo> findNodes(AccessibilityNodeInfo rootNodeInfo) {
        LinkedHashSet<AccessibilityNodeInfo> nodes = new LinkedHashSet<AccessibilityNodeInfo>();
        this.rootNodeInfo = rootNodeInfo;
        AccessibilityNodeInfo accessibilityNodeInfo = rootNodeInfo;
        this.lastPackageName = accessibilityNodeInfo == null ? null : accessibilityNodeInfo.getPackageName();
        accessibilityNodeInfo = rootNodeInfo;
        if (accessibilityNodeInfo != null) {
            AccessibilityNodeInfo accessibilityNodeInfo2 = accessibilityNodeInfo;
            boolean bl = false;
            boolean bl2 = false;
            AccessibilityNodeInfo $this$findNodes_u24lambda_u2d11 = accessibilityNodeInfo2;
            boolean bl3 = false;
            AccessibilityNodeInfo nodeInfo = AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)$this$findNodes_u24lambda_u2d11);
            Intrinsics.checkNotNullExpressionValue((Object)nodeInfo, (String)"nodeInfo");
            this.nodeCate(nodeInfo, nodes);
        }
        return nodes;
    }

    private final void findNodeByPoint(AccessibilityNodeInfo nodeInfo, int x, int y, ArrayList<AccessibilityNodeInfo> nodeInfoList) {
        int childCount = nodeInfo.getChildCount();
        String viewIdResourceName = nodeInfo.getViewIdResourceName();
        int n = 0;
        if (n < childCount) {
            do {
                int index;
                AccessibilityNodeInfo accessibilityNodeInfo;
                if ((accessibilityNodeInfo = nodeInfo.getChild(index = n++)) == null) continue;
                AccessibilityNodeInfo child = accessibilityNodeInfo;
                this.findNodeByPoint(child, x, y, nodeInfoList);
                return;
            } while (n < childCount);
        }
        nodeInfo.getBoundsInScreen(this.pointNodeBound);
        if (this.pointNodeBound.contains(x, y)) {
            nodeInfoList.add(nodeInfo);
        }
    }

    private final void nodeCate(AccessibilityNodeInfo nodeInfo, LinkedHashSet<AccessibilityNodeInfo> nodeSet) {
        CharSequence charSequence;
        CharSequence charSequence2;
        String string2;
        int childCount = nodeInfo.getChildCount();
        CharSequence charSequence3 = nodeInfo.getText();
        if (charSequence3 == null) {
            string2 = null;
        } else {
            charSequence2 = ((Object)charSequence3).toString();
            if (charSequence2 == null) {
                string2 = null;
            } else {
                CharSequence charSequence4 = charSequence2;
                boolean bl = false;
                string2 = ((Object)StringsKt.trim((CharSequence)charSequence4)).toString();
            }
        }
        String text = string2;
        charSequence2 = nodeInfo.getContentDescription();
        CharSequence contentDescription = charSequence2 == null ? null : StringsKt.trim((CharSequence)charSequence2);
        CharSequence className = nodeInfo.getClassName();
        CharSequence packageName = nodeInfo.getPackageName();
        boolean isVisibleToUser = nodeInfo.isVisibleToUser();
        boolean isContentInvalid = nodeInfo.isContentInvalid();
        String viewIdResourceName = nodeInfo.getViewIdResourceName();
        if (!(!isVisibleToUser || Intrinsics.areEqual((Object)(charSequence = className), (Object)ImageView.class.getName()) || Intrinsics.areEqual((Object)charSequence, (Object)ImageButton.class.getName()) || Intrinsics.areEqual((Object)charSequence, (Object)WebView.class.getName()) || Intrinsics.areEqual((Object)charSequence, (Object)SeekBar.class.getName()) || Intrinsics.areEqual((Object)charSequence, (Object)ProgressBar.class.getName()) || Intrinsics.areEqual((Object)charSequence, (Object)VideoView.class.getName()))) {
            if (!TextUtils.isEmpty((CharSequence)text) && (childCount == 0 || Intrinsics.areEqual((Object)className, (Object)TextView.class.getName()))) {
                nodeSet.add(nodeInfo);
            } else if (!TextUtils.isEmpty((CharSequence)contentDescription) && (childCount == 0 || Intrinsics.areEqual((Object)className, (Object)TextView.class.getName()))) {
                if (Build.VERSION.SDK_INT >= 24) {
                    int drawingOrder = nodeInfo.getDrawingOrder();
                    if (drawingOrder > 0) {
                        nodeSet.add(nodeInfo);
                    }
                } else {
                    nodeSet.add(nodeInfo);
                }
            }
        }
        int n = 0;
        if (n < childCount) {
            do {
                int index;
                AccessibilityNodeInfo accessibilityNodeInfo;
                if ((accessibilityNodeInfo = nodeInfo.getChild(index = n++)) == null) continue;
                AccessibilityNodeInfo child = accessibilityNodeInfo;
                this.nodeCate(child, nodeSet);
            } while (n < childCount);
        }
    }

    private final boolean shouldRefresh(LinkedHashSet<AccessibilityNodeInfo> nodeSet) {
        int size = nodeSet.size();
        float percent = 0.5f;
        float progress = 0.0f;
        boolean bl = false;
        HashSet<String> temp = new HashSet<String>();
        for (AccessibilityNodeInfo info : nodeSet) {
            Rect rectInScreen = new Rect();
            info.getBoundsInScreen(rectInScreen);
            Intrinsics.checkNotNullExpressionValue((Object)info, (String)"info");
            String key = AccessServiceKt.nodeKey(info, rectInScreen);
            if (this.getNodeRectSet().contains(key)) {
                float f = progress;
                progress = f + 1.0f;
            }
            temp.add(key);
        }
        this.getNodeRectSet().clear();
        this.getNodeRectSet().addAll((Collection<String>)temp);
        temp.clear();
        if (size == 0) {
            return true;
        }
        return progress / (float)this.getNodeRectSet().size() < percent;
    }

    protected boolean onGesture(int gestureId) {
        return super.onGesture(gestureId);
    }

    public void onInterrupt() {
    }

    public void onAccessibilityEvent(@Nullable AccessibilityEvent event) {
        BuildersKt.launch$default((CoroutineScope)this.getMainScope(), (CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(event, this, null){
            int label;
            final /* synthetic */ AccessibilityEvent $event;
            final /* synthetic */ AccessService this$0;
            {
                this.$event = $event;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AccessibilityEvent accessibilityEvent = this.$event;
                        CharSequence packageName = accessibilityEvent == null ? null : accessibilityEvent.getPackageName();
                        accessibilityEvent = this.$event;
                        if (!Intrinsics.areEqual((Object)(accessibilityEvent == null ? null : Boxing.boxInt((int)accessibilityEvent.getWindowId())), (Object)AccessService.access$getCurrentWindowId$p(this.this$0)) && !TextUtils.isEmpty((CharSequence)packageName)) {
                            Message message = Message.obtain(null, (int)30, (Object)packageName);
                            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                            RxRelay.INSTANCE.post(message);
                        }
                        AccessService.access$setCurrentWindowId$p(this.this$0, (accessibilityEvent = this.$event) == null ? null : Boxing.boxInt((int)accessibilityEvent.getWindowId()));
                        AccessService.access$setAccessibilityEvent$p(this.this$0, true);
                        AccessService.access$setRootNodeInfo$p(this.this$0, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    protected void onServiceConnected() {
        super.onServiceConnected();
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_SERVICE_CONNECTED));
        isAccessibilityServiceRun = true;
        AccessibilityServiceState.INSTANCE.setAccessibilityServiceSetupCount(SharedPreferKt.updateAccessibilityServiceSetupCount((Context)this));
        AccessibilityServiceState.INSTANCE.isAccessibilityServiceRunning().postValue((Object)true);
    }

    public boolean onUnbind(@Nullable Intent intent) {
        isAccessibilityServiceRun = false;
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_UN_BIND));
        AccessibilityServiceState.INSTANCE.isAccessibilityServiceRunning().postValue((Object)false);
        return true;
    }

    public void onRebind(@Nullable Intent intent) {
        super.onRebind(intent);
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_RE_BIND));
        isAccessibilityServiceRun = true;
        AccessibilityServiceState.INSTANCE.isAccessibilityServiceRunning().postValue((Object)true);
    }

    @Override
    public void run() {
    }

    public void onDestroy() {
        super.onDestroy();
        isAccessibilityServiceRun = false;
        this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_DESTROY));
        AccessibilityServiceState.INSTANCE.isAccessibilityServiceRunning().postValue((Object)false);
    }

    private final void visibleFloating() {
        if (!this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_FLOATING_OPEN)) && PermissionHelperKt.canDrawOverlays((Context)this)) {
            FloatingStateMachine.INSTANCE.sendMessage(110);
        }
    }

    private final void invisibleFloating() {
        if (!this.getLocalBroadcastManager().sendBroadcast(new Intent(BROADCAST_ACTION_FLOATING_CLOSE))) {
            FloatingStateMachine.INSTANCE.sendMessage(170);
        }
    }

    private final boolean floatingVisible() {
        return FloatingManager.INSTANCE.isFloatingVisible((Context)this) && !Intrinsics.areEqual((Object)FloatingStateMachine.INSTANCE.currentState(), (Object)FloatingStateMachine.FloatingState.InvisibleState.INSTANCE);
    }

    private static final Object handleActionStartMultiNode$lambda-1(AccessService this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AccessibilityNodeInfo accessibilityNodeInfo = this$0.rootNodeInfo();
        return accessibilityNodeInfo == null ? Unit.INSTANCE : accessibilityNodeInfo;
    }

    private static final boolean handleActionStartMultiNode$lambda-2(AccessService this$0, AccessibilityNodeInfo rootNodeInfo) {
        boolean packageNameChanged;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)rootNodeInfo, (String)"rootNodeInfo");
        boolean bl = packageNameChanged = this$0.lastPackageName != null && !Intrinsics.areEqual((Object)rootNodeInfo.getPackageName(), (Object)this$0.lastPackageName);
        if (packageNameChanged) {
            FloatingStateMachine.INSTANCE.sendMessage(110);
        }
        return !packageNameChanged;
    }

    private static final LinkedHashSet handleActionStartMultiNode$lambda-3(AccessService this$0, AccessibilityNodeInfo rootNodeInfo) {
        LinkedHashSet<Object> linkedHashSet;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            linkedHashSet = this$0.findNodes(rootNodeInfo);
        }
        catch (Throwable e) {
            boolean bl = false;
            linkedHashSet = new LinkedHashSet();
        }
        return linkedHashSet;
    }

    private static final boolean handleActionStartMultiNode$lambda-4(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof AccessibilityNodeInfo;
    }

    private static final AccessibilityNodeInfo handleActionStartMultiNode$lambda-5(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (AccessibilityNodeInfo)it;
    }

    private static final boolean handleActionStartMultiNode$lambda-6(AccessService this$0, LinkedHashSet nodeSet) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)nodeSet, (String)"nodeSet");
        return this$0.shouldRefresh(nodeSet);
    }

    private static final void handleActionStartMultiNode$lambda-7(LinkedHashSet nodes) {
        Message message = Message.obtain(null, (int)20, (Object)nodes);
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"obtain(null, EVENT_NODE_INFO_MULTI, nodes)");
        RxRelay.INSTANCE.postByEventBus(message);
    }

    private static final void handleActionStartMultiNode$lambda-8(LinkedHashSet it) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void handleActionDown$lambda-9(AccessService this$0, FlowableEmitter emitter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        try {
            if (!emitter.isCancelled()) {
                AccessibilityNodeInfo rootNodeInfo = this$0.rootNodeInfo();
                emitter.onNext(this$0.findNodes(rootNodeInfo));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (!emitter.isCancelled()) {
                emitter.tryOnError(t);
            }
        }
        finally {
            if (!emitter.isCancelled()) {
                emitter.onComplete();
            }
        }
    }

    private static final void handleActionDown$lambda-10(LinkedHashSet nodes) {
        Message message = Message.obtain(null, (int)10, (Object)nodes);
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"obtain(null, EVENT_NODE_INFO_DOWN, nodes)");
        RxRelay.INSTANCE.post(message);
    }

    public static final /* synthetic */ void access$handleActionPoint(AccessService $this, Intent intent) {
        $this.handleActionPoint(intent);
    }

    public static final /* synthetic */ void access$log(AccessService $this, String message) {
        $this.log(message);
    }

    public static final /* synthetic */ void access$handleActionStartSingleMultiNode(AccessService $this) {
        $this.handleActionStartSingleMultiNode();
    }

    public static final /* synthetic */ void access$handleActionStopMultiNode(AccessService $this) {
        $this.handleActionStopMultiNode();
    }

    public static final /* synthetic */ void access$handleActionDown(AccessService $this) {
        $this.handleActionDown();
    }

    public static final /* synthetic */ Integer access$getCurrentWindowId$p(AccessService $this) {
        return $this.currentWindowId;
    }

    public static final /* synthetic */ void access$setCurrentWindowId$p(AccessService $this, Integer n) {
        $this.currentWindowId = n;
    }

    public static final /* synthetic */ void access$setAccessibilityEvent$p(AccessService $this, boolean bl) {
        $this.isAccessibilityEvent = bl;
    }

    public static final /* synthetic */ void access$setRootNodeInfo$p(AccessService $this, AccessibilityNodeInfo accessibilityNodeInfo) {
        $this.rootNodeInfo = accessibilityNodeInfo;
    }

    public static final /* synthetic */ LinkedHashSet access$findNodes(AccessService $this, AccessibilityNodeInfo rootNodeInfo) {
        return $this.findNodes(rootNodeInfo);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%J\u000e\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010(\u001a\u00020 2\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lcom/talpa/overlay/service/AccessService$Companion;", "", "()V", "ACTION_DOWN", "", "ACTION_NODES_START", "ACTION_NODES_STOP", "ACTION_POINT", "BROADCAST_ACTION_DESTROY", "BROADCAST_ACTION_FLOATING_CLOSE", "BROADCAST_ACTION_FLOATING_OPEN", "BROADCAST_ACTION_PACKAGE_CHANGED", "BROADCAST_ACTION_RE_BIND", "BROADCAST_ACTION_SERVICE_CONNECTED", "BROADCAST_ACTION_UN_BIND", "EXTRA_PACKAGE_NAME", "EXTRA_POINT_X", "EXTRA_POINT_Y", "MILLIS_DELAY", "", "TAG", "<set-?>", "", "currentPackageName", "getCurrentPackageName", "()Ljava/lang/CharSequence;", "isAccessibilityServiceRun", "", "()Z", "setAccessibilityServiceRun", "(Z)V", "startServiceForDown", "", "context", "Landroid/content/Context;", "startServiceForPoint", "x", "", "y", "startServiceForStartMultiNodes", "startServiceForStopMultiNodes", "ht-overlay_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAccessibilityServiceRun() {
            return isAccessibilityServiceRun;
        }

        public final void setAccessibilityServiceRun(boolean bl) {
            isAccessibilityServiceRun = bl;
        }

        @Nullable
        public final CharSequence getCurrentPackageName() {
            return currentPackageName;
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForPoint(@NotNull Context context, int x, int y) {
            void $this$startServiceForPoint_u24lambda_u2d0;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, AccessService.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            Context context2 = context;
            boolean bl3 = false;
            $this$startServiceForPoint_u24lambda_u2d0.setAction(AccessService.ACTION_POINT);
            $this$startServiceForPoint_u24lambda_u2d0.putExtra(AccessService.EXTRA_POINT_X, x);
            $this$startServiceForPoint_u24lambda_u2d0.putExtra(AccessService.EXTRA_POINT_Y, y);
            Unit unit = Unit.INSTANCE;
            context2.startService(intent);
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForStartMultiNodes(@NotNull Context context) {
            void $this$startServiceForStartMultiNodes_u24lambda_u2d1;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, AccessService.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            Context context2 = context;
            boolean bl3 = false;
            $this$startServiceForStartMultiNodes_u24lambda_u2d1.setAction(AccessService.ACTION_NODES_START);
            Unit unit = Unit.INSTANCE;
            context2.startService(intent);
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForStopMultiNodes(@NotNull Context context) {
            void $this$startServiceForStopMultiNodes_u24lambda_u2d2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, AccessService.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            Context context2 = context;
            boolean bl3 = false;
            $this$startServiceForStopMultiNodes_u24lambda_u2d2.setAction(AccessService.ACTION_NODES_STOP);
            Unit unit = Unit.INSTANCE;
            context2.startService(intent);
        }

        /*
         * WARNING - void declaration
         */
        public final void startServiceForDown(@NotNull Context context) {
            void $this$startServiceForDown_u24lambda_u2d3;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, AccessService.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            Context context2 = context;
            boolean bl3 = false;
            $this$startServiceForDown_u24lambda_u2d3.setAction(AccessService.ACTION_DOWN);
            Unit unit = Unit.INSTANCE;
            context2.startService(intent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

