/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.overlay.view.overlay;

import android.content.Context;
import android.widget.TextView;
import android.widget.Toast;
import androidx.compose.runtime.internal.StabilityInferred;
import com.talpa.overlay.R;
import com.talpa.overlay.tools.TextSpeech;
import com.talpa.overlay.view.overlay.SimpleOverlayView;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/talpa/overlay/view/overlay/SpeechOverlayView;", "Lcom/talpa/overlay/view/overlay/SimpleOverlayView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "postTranslate", "", "translation", "", "targetLanguageTag", "tvTranslation", "Landroid/widget/TextView;", "removeContentView", "ht-overlay_release"})
@StabilityInferred(parameters=0)
public final class SpeechOverlayView
extends SimpleOverlayView {
    public static final int $stable;

    public SpeechOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @Override
    public void postTranslate(@NotNull String translation, @NotNull String targetLanguageTag, @NotNull TextView tvTranslation) {
        Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
        Intrinsics.checkNotNullParameter((Object)targetLanguageTag, (String)"targetLanguageTag");
        Intrinsics.checkNotNullParameter((Object)tvTranslation, (String)"tvTranslation");
        super.postTranslate(translation, targetLanguageTag, tvTranslation);
        tvTranslation.setTextColor(this.getContext().getResources().getColor(R.color.color_floating_translation_speech_default));
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
        Locale locale = Locale.forLanguageTag(targetLanguageTag);
        TextSpeech textSpeech2 = this.getTextSpeech();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"locale");
        if (textSpeech2.isLanguageAvailable(locale)) {
            if (!this.getTextSpeech().speak(translation, locale)) {
                Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.playback_error, (int)0).show();
            }
        } else {
            Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.playback_error, (int)0).show();
        }
    }

    @Override
    public void removeContentView() {
        super.removeContentView();
        if (this.getTextSpeech().isSpeaking()) {
            this.getTextSpeech().stopSpeak();
        }
    }
}

