package com.talpa.translate.base.trace

import android.content.Context
import android.content.Intent
import android.util.Log
import androidx.annotation.RestrictTo
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.talpa.translate.base.BaseApp
import com.talpa.translate.base.utils.ACTION_DATA_ANALYSIS
import com.talpa.translate.base.utils.EXTRA_EVENT_ID
import com.talpa.translate.base.utils.EXTRA_EVENT_PARAMS

private const val TAG = "hitranslation_event"

/**
 * Create by chenjunsheng on 2020/5/14
 */
@RestrictTo(RestrictTo.Scope.LIBRARY)
object HiTranslateTrace {

    private val dataMap = HashMap<String, String>()

    fun logEvent(context: Context, eventName: String, key: String?, value: String?) {
        Log.d(
            TAG,
            "event:${eventName} key:${key} value:${value}"
        )
        dataMap.clear()
        LocalBroadcastManager.getInstance(context)
            .sendBroadcast(
                Intent(ACTION_DATA_ANALYSIS)
                .also {
                    it.putExtra(EXTRA_EVENT_ID, eventName)
                    if (key != null && value != null) {
                        it.putExtra(EXTRA_EVENT_PARAMS, dataMap.apply { put(key, value) })
                    }
                })
    }

    fun logEvent(context: Context, eventName: String, map: HashMap<String, String>) {
        LocalBroadcastManager.getInstance(context)
            .sendBroadcast(
                Intent(ACTION_DATA_ANALYSIS)
                    .also {
                        it.putExtra(EXTRA_EVENT_ID, eventName)
                        it.putExtra(EXTRA_EVENT_PARAMS, map)
                    })
    }
}