package com.talpa.translate.ocr.result

import android.text.Html
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import android.widget.Toast
import androidx.recyclerview.widget.RecyclerView
import com.photo.translation.R
import com.talpa.translate.base.utils.PT_contrast_copy
import com.talpa.translate.base.utils.clipboard
import com.talpa.translate.base.utils.logEvent
import com.talpa.translate.ocr.datasource.CompleteResult
import kotlin.math.min

/**
 * Create by chenjunsheng on 2020/10/14
 */
class ContrastAdapter(completeResult: CompleteResult) : RecyclerView.Adapter<ContrastAdapter.ContrastHolder>() {

    private val blockList = completeResult.ocrResult?.blocks
    private val responseList = completeResult.transResponse?.result?.texts

    class ContrastHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val source = itemView.findViewById<TextView>(R.id.source)
        val target = itemView.findViewById<TextView>(R.id.target)
        val copy = itemView.findViewById<View>(R.id.ic_copy)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ContrastHolder {
        val view = LayoutInflater.from(parent.context).inflate(R.layout.contrast_item, parent, false)
        return ContrastHolder(view)
    }

    override fun onBindViewHolder(holder: ContrastHolder, position: Int) {
        val ocrText = blockList?.get(position)?.text
        val translation = responseList?.get(position)
        if (!ocrText.isNullOrEmpty() && !translation.isNullOrEmpty()) {
            holder.source.setText(ocrText)
            holder.target.setText(Html.fromHtml(translation))
        }
        holder.copy.setOnClickListener {
            it.context.clipboard(label = "Contrast", text = "${holder.source.text} ${holder.target.text}")
            logEvent(it.context, PT_contrast_copy)
            Toast.makeText(it.context, R.string.copied_toast_contrast, Toast.LENGTH_SHORT).show()
        }
    }

    override fun getItemCount(): Int {
        return min(blockList?.size ?: 0, responseList?.size ?: 0)
    }
}