package com.talpa.translate.ocr

import android.content.Context
import android.graphics.Bitmap
import com.talpa.translate.factory.TranslatorFactory
import com.talpa.translate.ocr.result.OcrResult
import kotlinx.coroutines.runBlocking

/**
 * Create by chenjunsheng on 2020/8/5
 */
class OcrController(private val context: Context) : IOcrController {

    private var ocrResult: OcrResult? = null

    override fun setImage(bitmap: Bitmap) {
        ocrResult = runBlocking {
            val recognizer = TranslatorFactory.getFirebaseRecognizer(context)
            recognizer.doOcr(bitmap)
        }

    }

    override fun getOcrResult(): OcrResult? {
        return ocrResult
    }

    override fun clearImage() {}

    override fun destroy() {}

}