package com.talpa.translate.render

import android.content.Context
import android.graphics.*
import android.text.Layout
import android.text.StaticLayout
import android.text.TextPaint
import android.util.Log
import android.util.TypedValue
import com.talpa.translate.base.utils.MAX_TEXT_SIZE
import com.talpa.translate.base.utils.SPACINGMULT
import com.talpa.translate.base.utils.getAutofitTextSize
import com.talpa.translate.ocr.PhotoAnalyzer
import com.talpa.translate.ocr.datasource.CompleteResult
import kotlin.math.min
import kotlin.math.sqrt


/**
 * Create by chenjunsheng on 2020/7/14
 */
class TranslatorRender(val context: Context) : Render {

    private var mTextPaint: TextPaint = TextPaint(Paint.ANTI_ALIAS_FLAG)
    private val mPath = Path()
    private val mPathMeasure = PathMeasure()

    override fun renderOverlay(renderSource: Bitmap?, completeResult: CompleteResult) {
        renderSource ?: return
        val canvas = Canvas(renderSource)

        completeResult.ocrResult!!.blocks.forEachIndexed { index, block ->
            val rect = block.rect
            mTextPaint.color = Color.BLACK
            val border01_x = block.blockCorners.getOrNull(0)?.x ?: rect.left
            val border01_y = block.blockCorners.getOrNull(0)?.y ?: rect.top

            val border02_x = block.blockCorners.getOrNull(1)?.x ?: rect.right
            val border02_y = block.blockCorners.getOrNull(1)?.y ?: rect.top

            val border03_x = block.blockCorners.getOrNull(2)?.x ?: rect.right
            val border03_y = block.blockCorners.getOrNull(2)?.y ?: rect.bottom

            val border04_x = block.blockCorners.getOrNull(3)?.x ?: rect.left
            val border04_y = block.blockCorners.getOrNull(3)?.y ?: rect.bottom

            val borderTopLen = sqrt(
                ((border01_x - border02_x) * (border01_x - border02_x)
                        + (border01_y - border02_y) * (border01_y - border02_y)).toDouble()
            )
            val borderRightLen = sqrt(
                ((border02_x - border03_x) * (border02_x - border03_x)
                        + (border02_y - border03_y) * (border02_y - border03_y)).toDouble()
            )
            val borderBottomLen = sqrt(
                ((border03_x - border04_x) * (border03_x - border04_x)
                        + (border03_y - border04_y) * (border03_y - border04_y)).toDouble()
            )
            val borderLeftLen = sqrt(
                ((border01_x - border04_x) * (border01_x - border04_x)
                        + (border01_y - border04_y) * (border01_y - border04_y)).toDouble()
            )

            val textRectWidth = (borderTopLen + borderBottomLen) / 2
            val textRectHeight = (borderRightLen + borderLeftLen) / 2

            val textSize = getAutofitTextSize(
                completeResult.transResponse!!.result!!.texts!![index],
                mTextPaint,
                Rect(0, 0, textRectWidth.toInt(), textRectHeight.toInt()),
                MAX_TEXT_SIZE,
                context
            )
            mTextPaint.textSize = TypedValue.applyDimension(
                TypedValue.COMPLEX_UNIT_SP, textSize.toFloat(),
                context.resources.displayMetrics
            )
            val translation = completeResult.transResponse!!.result!!.texts!![index]
            val staticLayout = StaticLayout(
                translation,
                mTextPaint, rect.width(),
                Layout.Alignment.ALIGN_NORMAL,
                SPACINGMULT,
                0.0f,
                false
            )

            repeat(staticLayout.lineCount) {
                mPath.reset()
                //left
                mPath.moveTo(border01_x.toFloat(), border01_y.toFloat())
                mPath.lineTo(border04_x.toFloat(), border04_y.toFloat())
                mPathMeasure.setPath(mPath, false)

                val left_each_len = borderLeftLen / staticLayout.lineCount

                val childPath = Path()
                mPathMeasure.getSegment((it * left_each_len).toFloat(),
                    min((it * left_each_len).toFloat() + left_each_len.toFloat(), mPathMeasure.length),
                    childPath, true)

                mPathMeasure.setPath(childPath, false)

                val posLeft = FloatArray(2)
                mPathMeasure.getPosTan(mPathMeasure.length / 2, posLeft, null)

                //right
                mPath.reset()
                mPath.moveTo(border02_x.toFloat(), border02_y.toFloat())
                mPath.lineTo(border03_x.toFloat(), border03_y.toFloat())
                mPathMeasure.setPath(mPath, false)

                val right_each_len = borderLeftLen / staticLayout.lineCount

                childPath.reset()
                mPathMeasure.getSegment((it * right_each_len).toFloat(),
                    min((it * right_each_len).toFloat() + right_each_len.toFloat(), mPathMeasure.length),
                    childPath, true)

                mPathMeasure.setPath(childPath, false)

                val posRight = FloatArray(2)
                mPathMeasure.getPosTan(mPathMeasure.length / 2, posRight, null)

                val centerLinePath = Path()
                centerLinePath.moveTo(posLeft[0], posLeft[1])
                centerLinePath.lineTo(posRight[0], posRight[1])

                val drawingTextSb = StringBuilder(translation.substring(staticLayout.getLineStart(it),
                    staticLayout.getLineEnd(it)))

                val fm = mTextPaint.fontMetrics

                canvas.drawTextOnPath(
                    drawingTextSb.toString(), centerLinePath, 0f,
                    (fm.bottom - fm.top) / 2 - fm.bottom, mTextPaint
                )

                /*val path01 = Path()
                path01.moveTo(border01_x.toFloat(), border01_y.toFloat())
                path01.lineTo(border02_x.toFloat(), border02_y.toFloat())
                path01.lineTo(border03_x.toFloat(), border03_y.toFloat())
                path01.lineTo(border04_x.toFloat(), border04_y.toFloat())
                path01.close()

                val p = Paint()
                p.style = Paint.Style.STROKE
                p.setColor(Color.RED)
                p.strokeWidth = 2f
                canvas.drawPath(path01, p)

                p.setColor(Color.GREEN)
                canvas.drawRect(block.rect, p)*/

            }

        }
    }


}