package com.talpa.translate.test

import android.content.Intent
import android.graphics.*
import android.net.Uri
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import com.bumptech.glide.Glide
import com.bumptech.glide.load.DataSource
import com.bumptech.glide.load.engine.GlideException
import com.bumptech.glide.request.RequestListener
import com.bumptech.glide.request.target.Target
import com.photo.translation.databinding.TestLayoutBinding
import com.talpa.translate.camera.CameraFragment
import com.talpa.translate.camera.view.CameraListener
import com.talpa.translate.camera.view.CameraView
import com.talpa.translate.camera.view.PictureResult
import com.talpa.translate.camera.view.controls.*
import com.talpa.translate.camera.view.gesture.Gesture
import com.talpa.translate.camera.view.gesture.GestureAction
import com.talpa.translate.camera.view.markers.DefaultAutoFocusMarker
import com.talpa.translate.ocr.OcrDispatcher
import com.talpa.translate.ocr.PhotoAnalyzer
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

/**
 * Create by chenjunsheng on 2020/8/18
 */
class TestActivity : AppCompatActivity() {

    companion object {
        init {
            System.loadLibrary("imgprocessor")
        }
    }

    private lateinit var mCamera: CameraView
    //private val tessBaseApi: TessBaseAPI = TessBaseAPI()
    private lateinit var binding: TestLayoutBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = TestLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)
        //tessBaseApi.init("", "eng")
        mCamera = binding.camera
            .apply {
                engine = Engine.CAMERA2
                setExperimental(true)
                preview = Preview.GL_SURFACE
                playSounds = false
                grid = Grid.OFF
                flash = Flash.OFF
                audio = Audio.OFF
                facing = Facing.BACK
                mapGesture(Gesture.TAP, GestureAction.AUTO_FOCUS)
                mapGesture(Gesture.LONG_TAP, GestureAction.NONE)
                mapGesture(Gesture.PINCH, GestureAction.ZOOM)
                mode = Mode.PICTURE
                setAutoFocusMarker(DefaultAutoFocusMarker())
                useDeviceOrientation = false
                frameProcessingFormat = ImageFormat.YUV_420_888
            }
        //parent.addView(mCamera, FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT))
        mCamera.setLifecycleOwner(this)
        mCamera.addCameraListener(object : CameraListener() {
            override fun onPictureTaken(result: PictureResult) {
                mCamera.visibility = View.INVISIBLE
                lifecycleScope.launch {
                    val bitmap = withContext(Dispatchers.IO) {
                        Glide.with(this@TestActivity)
                            .asBitmap()
                            .load(result.data)
                            .submit()
                            .get()
                    }
                    binding.imageView3.setImageBitmap(bitmap)
                    val dealBitmap = withContext(Dispatchers.IO) {

                        //tessBaseApi.setImage(bitmap)
                        //dealThemeColor(bitmap)
                        //dealPicture(bitmap)
                        //getTextArea(bitmap)
                        //getPollyBitmap(bitmap)
                        dealImg(bitmap)
                        //val pix = tessBaseApi.getThresholdedImage()
                        //tessBaseApi.strips
                        //WriteFile.writeBitmap(pix)
                    }
                    binding.imageView4.setImageBitmap(dealBitmap)
                }

                binding.imageView4.visibility = View.VISIBLE
                binding.imageView3.visibility = View.VISIBLE

                binding.imageView3.setOnClickListener {
                    if (binding.imageView4.visibility == View.VISIBLE) {
                        binding.imageView4.visibility = View.INVISIBLE
                    } else {
                        binding.imageView4.visibility = View.VISIBLE
                    }
                }

                binding.imageView4.setOnClickListener {
                    if (it.visibility == View.VISIBLE) {
                        it.visibility = View.INVISIBLE
                    }
                }
            }
        })

        binding.button.setOnClickListener { mCamera.takePictureSnapshot() }

        binding.button2.setOnClickListener {
            val intent = Intent(Intent.ACTION_PICK)

            intent.type = "image/*"

            startActivityForResult(
                intent,
                CameraFragment.REQUEST_CODE_SELECT_IMAGE
            )
        }
    }

    private suspend fun dealImg(bitmap: Bitmap): Bitmap {
        /*val recognizer = OcrDispatcher.dispatchOcrTranslator(this@TestActivity, "en")
        val ocr_result = recognizer.doOcr(bitmap)
        val photoAnalyzer = PhotoAnalyzer.createAnalyzer(bitmap)
        val renderSource = photoAnalyzer.testgenerateBgBitmap(
            ocr_result.blocks.map {
                PhotoAnalyzer.AnalyzerStub(null, it.rect, it.blockCorners, it.lines.map {
                    it.linePoint.toTypedArray()
                })
            }.toTypedArray()
        )*/

        val textArea = PhotoAnalyzer.findTextAreaFast(bitmap)
        val paint = Paint()
        paint.setColor(Color.RED)
        paint.strokeWidth = 2f
        paint.style = Paint.Style.STROKE
        val c = Canvas(bitmap)
        textArea.forEach {
            c.drawRect(it, paint)
        }
        /*return testBoundingArea(bitmap.width, bitmap.height, arrayOf(
            Point(156, 204), Point(863, 204), Point(863, 327), Point(156, 327)
        ))*/
        return bitmap
    }

    private fun setImageFromGallery(uri: Uri) {
        mCamera.close()
        mCamera.visibility = View.INVISIBLE
        binding.imageView4.visibility = View.VISIBLE
        binding.imageView3.visibility = View.VISIBLE

        binding.imageView3.setOnClickListener {
            if (binding.imageView4.visibility == View.VISIBLE) {
                binding.imageView4.visibility = View.INVISIBLE
            } else {
                binding.imageView4.visibility = View.VISIBLE
            }
        }

        binding.imageView4.setOnClickListener {
            if (it.visibility == View.VISIBLE) {
                it.visibility = View.INVISIBLE
            }
        }
        Glide.with(this)
            .asBitmap()
            .load(uri)
            .listener(object : RequestListener<Bitmap> {
                override fun onLoadFailed(
                    e: GlideException?,
                    model: Any?,
                    target: Target<Bitmap>?,
                    isFirstResource: Boolean
                ): Boolean {
                    return false
                }

                override fun onResourceReady(
                    resource: Bitmap,
                    model: Any?,
                    target: Target<Bitmap>?,
                    dataSource: DataSource?,
                    isFirstResource: Boolean
                ): Boolean {
                    lifecycleScope.launchWhenCreated {
                        val dealBitmap = withContext(Dispatchers.IO) {
                            //dealThemeColor(resource)
                            //dealPicture(resource)
                            //getTextArea(resource)
                            dealImg(resource)


                        }
                        binding.imageView4.setImageBitmap(dealBitmap)
                    }
                    return false
                }

            })
            .into(binding.imageView3)
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        when (requestCode) {
            CameraFragment.REQUEST_CODE_SELECT_IMAGE -> {
                val uri = data?.data
                //println("uri===$uri")

                if (uri != null) {
                    setImageFromGallery(uri)
                }

            }
        }
    }

    external fun dealPicture(bitmap: Bitmap) : Bitmap

    external fun dealThemeColor(bitmap: Bitmap)

    external fun getTextArea(bitmap: Bitmap) : Bitmap

    external fun getPollyBitmap(bitmap: Bitmap): Bitmap

    external fun testBoundingArea(width: Int, height: Int, points: Array<Point>) : Bitmap

    external fun findTextArea(bitmap: Bitmap): Array<Rect>
}