/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Utils {
    public static Bitmap mergeBitmap(Bitmap backBitmap, Bitmap frontBitmap) {
        if (backBitmap == null || backBitmap.isRecycled() || frontBitmap == null || frontBitmap.isRecycled()) {
            return null;
        }
        Bitmap bitmap2 = backBitmap.copy(Bitmap.Config.ARGB_8888, true);
        Canvas canvas = new Canvas(bitmap2);
        Rect baseRect = new Rect(0, 0, backBitmap.getWidth(), backBitmap.getHeight());
        Rect frontRect = new Rect(0, 0, frontBitmap.getWidth(), frontBitmap.getHeight());
        canvas.drawBitmap(frontBitmap, frontRect, baseRect, null);
        return bitmap2;
    }

    public static boolean saveBitmap(Context context, Bitmap bitmap2, String bitName) {
        String brand = Build.BRAND;
        String fileName = brand.equals("xiaomi") ? Environment.getExternalStorageDirectory().getPath() + "/DCIM/Camera/" + bitName : (brand.equalsIgnoreCase("Huawei") ? Environment.getExternalStorageDirectory().getPath() + "/DCIM/Camera/" + bitName : Environment.getExternalStorageDirectory().getPath() + "/DCIM/" + bitName);
        if (Build.VERSION.SDK_INT >= 29) {
            Utils.saveSignImage(context, bitName, bitmap2);
            return true;
        }
        Log.v((String)"saveBitmap brand", (String)("" + brand));
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            if (bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out)) {
                out.flush();
                out.close();
                if (Build.VERSION.SDK_INT >= 29) {
                    ContentValues values = new ContentValues();
                    values.put("_data", file.getAbsolutePath());
                    values.put("mime_type", "image/jpeg");
                    Uri uri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                } else {
                    MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (String)file.getAbsolutePath(), (String)bitName, null);
                }
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)"FileNotFoundException", (String)("FileNotFoundException:" + e.getMessage()));
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            Log.e((String)"IOException", (String)("IOException:" + e.getMessage()));
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            Log.e((String)"IOException", (String)("IOException:" + e.getMessage()));
            e.printStackTrace();
            return false;
        }
        context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + fileName))));
        return true;
    }

    public static void saveSignImage(Context context, String fileName, Bitmap bitmap2) {
        try {
            OutputStream outputStream;
            ContentValues contentValues = new ContentValues();
            contentValues.put("_display_name", fileName);
            if (Build.VERSION.SDK_INT >= 29) {
                contentValues.put("relative_path", "DCIM/");
            } else {
                contentValues.put("_data", Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getPath());
            }
            contentValues.put("mime_type", "image/JPEG");
            Uri uri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
            if (uri != null && (outputStream = context.getContentResolver().openOutputStream(uri)) != null) {
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, outputStream);
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Bitmap rotateBitmap(int degree, Bitmap bitmap2) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        return Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Matrix)matrix, (boolean)true);
    }
}

