package com.talpa

import android.app.Activity
import android.content.Context
import android.graphics.Bitmap
import android.graphics.Rect
import androidx.annotation.Keep
import com.talpa.translate.activity.CameraActivity
import com.talpa.translate.base.BaseApp
import com.talpa.translate.base.utils.PT_enter
import com.talpa.translate.base.utils.logEvent
import com.talpa.translate.ocr.OcrDispatcher
import com.talpa.translate.ocr.PhotoAnalyzer

/**
 * Create by chenjunsheng on 2020/4/26
 */
@Keep
object PhotoTranslateController {

    const val SCREENSHOT_PATH = "screenshot_path"
    const val SCREENSHOT_ID = "screenshot_id"
    var serverAppKey: String? = null
    var serverAppSecret: String? = null
    var googleKey: String? = null
    /*var sourceLanguage: String? = null
    set(value) {
        if (!firebaseSourceSupportLanguages.contains(value ?: "") && !googleVisionLanguages.contains(value ?: "")) {
            field = "en"
        } else {
            field = value
        }
    }
    var targetLanguage: String? = null
    set(value) {
        if (!targetSupportLanguages.contains(value ?: "")) {
            field = "en"
        } else {
            field = value
        }
    }*/

    private var initialized = false

    //fun hasInitialized() = initialized

    /**
     * SDK初始化，要求传入serverAppKey和serverAppSecret
     * 可多次调用，建议在Application启动时调用
     * 方法内部仅做了赋值操作，没有其他耗时调用
     */
    @JvmStatic
    @JvmOverloads
    fun initialize(
        context: Context, serverAppKey: String, serverAppSecret: String,
        googleKey: String? = null
    ) {
        initialized = true
        BaseApp.initialize(context.applicationContext)
        this.serverAppKey = serverAppKey
        this.serverAppSecret = serverAppSecret
        this.googleKey = googleKey
    }

    /*fun setDefaultLanguage(sourceLanguage: String, targetLanguage: String) {
        this.sourceLanguage = sourceLanguage
        this.targetLanguage = targetLanguage
    }*/

    /**
     * 控制GoogleOcr功能是否可用
     */
    @JvmStatic
    fun googleOcrEnable(enable: Boolean) {
        OcrDispatcher.setGoogleOcrEnable(enable)
    }

    /**
     * 启动CameraActivity进行拍照翻译，
     * 接口调用前请先确认是否有相机权限
     * 请用这个接口启动
     * 不要用startActivity的方式启动CameraActivity
     */
    @JvmOverloads
    @JvmStatic
    fun startCameraCollection(context: Activity, requestCode: Int = 0) {
        check(initialized)
        CameraActivity.start(context, requestCode)
        logEvent(PT_enter)
    }

    /**
     * 图片翻译
     * 图片由外部传入
     * @param context
     * @param screenShotPath 截图地址，需要传绝对路径
     */
    @JvmStatic
    fun startTranslateFromUri(context: Context, screenShotPath: String, id: Long) {
        check(initialized)
        CameraActivity.start(
            context = context,
            screenShotPath = screenShotPath,
            id = id
        )
    }

    @JvmStatic
    fun fastFindTextAreaForScreenOnly(bitmap: Bitmap): Array<Rect> {
        return PhotoAnalyzer.findTextAreaFast(bitmap)
    }
}