package com.talpa.translate.base.compose

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.RowScope
import androidx.compose.material.IconButton
import androidx.compose.material.Text
import androidx.compose.material.TopAppBar
import androidx.compose.material.ripple.LocalRippleTheme
import androidx.compose.material.ripple.RippleAlpha
import androidx.compose.material.ripple.RippleTheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.CompositionLocalProvider
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.colorResource
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.ExperimentalUnitApi
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.TextUnitType
import com.photo.translation.R

/**
 * Create by chenjunsheng on 2021/8/2
 */

@ExperimentalUnitApi
@Composable
fun HiAppbarTitle(title: String) {
    Text(
        text = title,
        fontFamily = FontFamily.Default,
        fontWeight = FontWeight.Bold,
        fontSize = TextUnit(18f, TextUnitType.Sp),
    )
}

object RippleCustomTheme: RippleTheme {

    //Your custom implementation...
    @Composable
    override fun defaultColor() =
        RippleTheme.defaultRippleColor(
            colorResource(id = R.color.ripple_color),
            lightTheme = true
        )

    @Composable
    override fun rippleAlpha(): RippleAlpha =
        RippleTheme.defaultRippleAlpha(
            Color.Black,
            lightTheme = true
        )
}

@ExperimentalUnitApi
@Composable
fun HiAppbar(
    modifier: Modifier = Modifier,
    onNavIconPressed: () -> Unit = { },
    title: String,
    actions: @Composable RowScope.() -> Unit = {}
) {
    TopAppBar(
        backgroundColor = Color.White,
        title = { HiAppbarTitle(title = title) },
        actions = actions,
        modifier = modifier,
        navigationIcon = {
            IconButton(
                onClick = onNavIconPressed
            ) {
                Image(
                    painter = painterResource(R.drawable.ic_back_dark),
                    contentDescription = "back"
                )
            }
        }
    )

}