package com.talpa.translate.imglabel

import android.content.Context
import android.graphics.Bitmap
import com.google.mlkit.vision.common.InputImage
import com.google.mlkit.vision.label.ImageLabel
import com.google.mlkit.vision.label.ImageLabeling
import com.google.mlkit.vision.label.defaults.ImageLabelerOptions
import com.photo.translation.R
import com.talpa.translate.ocr.exception.NoContentException
import kotlin.coroutines.resume
import kotlin.coroutines.resumeWithException
import kotlin.coroutines.suspendCoroutine

/**
 * Create by chenjunsheng on 2021/1/6
 */
class ImageLabelWorker(
    private val context: Context,
    private val bitmap: Bitmap,
    private val sourceLanguage: String,
    private val targetLanguage: String
) {

    private suspend fun detectorVisionImage(visionImage: InputImage) =
        suspendCoroutine<List<ImageLabel>> { continuation ->
            val labeler = ImageLabeling.getClient(
                ImageLabelerOptions.Builder()
                    .setConfidenceThreshold(0.4f).build()
            )
            labeler.process(visionImage)
                .addOnSuccessListener { labels ->
                    if (labels.isEmpty()) {
                        continuation.resumeWithException(NoContentException(context.getString(R.string.image_label_not_found)))
                    } else {
                        continuation.resume(labels)
                    }
                }
                .addOnFailureListener { e ->
                    continuation.resumeWithException(NoContentException(context.getString(R.string.image_label_not_found)))
                }
        }

    suspend fun doItemRecognize() : List<ImageLabel> {
        val image = InputImage.fromBitmap(bitmap, 0)
        return detectorVisionImage(image)
    }
}