package com.talpa.translate.ocr

import android.content.Context
import com.google.mlkit.vision.text.TextRecognition
import com.google.mlkit.vision.text.TextRecognizer
import com.google.mlkit.vision.text.chinese.ChineseTextRecognizerOptions
import com.google.mlkit.vision.text.devanagari.DevanagariTextRecognizerOptions
import com.google.mlkit.vision.text.japanese.JapaneseTextRecognizerOptions
import com.photo.translation.BuildConfig
import com.talpa.translate.factory.TranslatorFactory
import com.google.mlkit.vision.text.korean.KoreanTextRecognizerOptions
import com.google.mlkit.vision.text.latin.TextRecognizerOptions
import com.talpa.translate.base.utils.*


/**
 * Create by chenjunsheng on 2020/7/29
 */
object OcrDispatcher {

    private var googleOcrEnable = true

    fun setGoogleOcrEnable(googleOcrEnable: Boolean) {
        this.googleOcrEnable = googleOcrEnable
    }

    fun getGoogleOcrEnable() = googleOcrEnable

    fun dispatchOcrTranslator(context: Context, sourceLanguage: String): Recognizer {
        return if (nonFreeOcrLanguages.contains(sourceLanguage) && googleOcrEnable) {
            TranslatorFactory.getGoogleRecognizer(context)
        } else {
            TranslatorFactory.getFirebaseRecognizer(context)
        }
    }

    internal fun dispatchOcrClient(sourceLanguage: String): TextRecognizer {
        return when {
            sourceLanguage.equals(chineseTag, true) -> {
                TextRecognition.getClient(ChineseTextRecognizerOptions.Builder().build())
            }
            sourceLanguage.equals(japaneseTag, true) -> {
                TextRecognition.getClient(JapaneseTextRecognizerOptions.Builder().build())
            }
            sourceLanguage.equals(koreanTag, true) -> {
                TextRecognition.getClient(KoreanTextRecognizerOptions.Builder().build())
            }
            devanagariTags.contains(sourceLanguage) -> {
                TextRecognition.getClient(DevanagariTextRecognizerOptions.Builder().build())
            }
            else -> {
                TextRecognition.getClient(TextRecognizerOptions.DEFAULT_OPTIONS)
            }
        }
    }

}
