package com.talpa.translate.ocr.datasource

import android.graphics.Bitmap
import android.os.Parcelable
import androidx.annotation.Keep
import com.talpa.translate.network.TransResponse
import com.talpa.translate.ocr.result.OcrResult
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.RawValue

/**
 * Create by chenjunsheng on 2020/10/12
 */
@Keep
@Parcelize
data class CompleteResult(
    var sourceLanguage: String,
    var targetLanguage: String,
    var ocrResult: @RawValue OcrResult? = null,
    var transResponse: @RawValue TransResponse? = null,
    var renderResult: Bitmap? = null
) : Parcelable