package com.talpa.translate.ocr.result

import android.content.Intent
import android.os.Bundle
import android.widget.Toast
import androidx.activity.compose.setContent
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import androidx.compose.runtime.SideEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.ExperimentalUnitApi
import androidx.core.content.ContextCompat
import androidx.core.view.WindowCompat
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.google.accompanist.systemuicontroller.rememberSystemUiController
import com.photo.translation.R
import com.talpa.translate.base.utils.PT_contrast_copy
import com.talpa.translate.base.utils.PT_contrast_edit
import com.talpa.translate.base.utils.clipboard
import com.talpa.translate.base.utils.logEvent
import com.talpa.translate.camera.COMPLETE_RESULT


/**
 * Create by chenjunsheng on 2020/10/12
 */
class ContrastActivity : AppCompatActivity() {

    private val mContrastViewModel by viewModels<ContrastViewModel> {
        object : ViewModelProvider.Factory {
            override fun <T : ViewModel> create(modelClass: Class<T>): T {
                return ContrastViewModel() as T
            }
        }
    }

    @ExperimentalUnitApi
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        WindowCompat.setDecorFitsSystemWindows(window, true)

        intent.extras.let {
            val completeResult = it?.getBinder(COMPLETE_RESULT) as? CompleteTransfer
            completeResult?.let { transfer ->
                dealData(transfer)
            }
        }

        setContent {
            val completeResult by mContrastViewModel.completeModel.collectAsState()

            val systemUiController = rememberSystemUiController()
            SideEffect {
                // Update all of the system bar colors to be transparent, and use
                // dark icons if we're in light theme
                systemUiController.setSystemBarsColor(
                    color = Color(ContextCompat.getColor(this, R.color.actionbar_background_color)),
                )
                // setStatusBarsColor() and setNavigationBarsColor() also exist
            }

            GetContrastScreen(
                completeResult = completeResult,
                onNavIconPressed = { finish() },
                menuClick = {
                    val bundle = Bundle()
                    bundle.putBinder(COMPLETE_RESULT, CompleteTransfer(completeResult))
                    startActivity(
                        Intent(this, ContrastEditActivity::class.java)
                        .also { it.putExtras(bundle) })
                    //findNavController().navigate(R.id.action_contrastSentenceFragment_to_contrastEditFragment)
                    logEvent(PT_contrast_edit)
                },
                itemClick = { source, target ->
                    clipboard(label = "Contrast", text = "${source} ${target}")
                    logEvent(PT_contrast_copy)
                    Toast.makeText(this, R.string.copied_toast_contrast, Toast.LENGTH_SHORT).show()
                }
            )
        }
    }

    private fun dealData(completeTransfer: CompleteTransfer) {
        val completeResult = completeTransfer.completeResult ?: return
        mContrastViewModel.updateResult(completeResult)
    }
}