package com.talpa.translate.ocr.result

import androidx.lifecycle.ViewModel
import com.talpa.translate.ocr.datasource.CompleteResult
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow

/**
 * Create by chenjunsheng on 2020/10/15
 */
class ContrastViewModel : ViewModel() {

    private var _completeModel: MutableStateFlow<CompleteResult?> = MutableStateFlow(null)
    val completeModel: StateFlow<CompleteResult?>
        get() = _completeModel

    fun updateResult(completeResult: CompleteResult) {
        _completeModel.value = completeResult
    }
}