package com.talpa.translate.ocr.result

import android.app.Application
import android.content.Context
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.asLiveData
import com.talpa.translate.network.HiTranslator
import com.talpa.translate.network.TransResponse
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.catch
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.flowOn

/**
 * Create by chenjunsheng on 2020/10/15
 */
class TranslateViewModel(app: Application) : AndroidViewModel(app) {

    fun startTranslate(from: String, to: String, tests: List<String>): LiveData<Result<TransResponse?>> {
        return flow {
            emit(Result.success(HiTranslator.getInstance(getApplication()).postTranslate(from, to, tests)))
        }.catch {
            emit(Result.failure(it))
        }.flowOn(Dispatchers.IO)
                .asLiveData()
    }
}