package com.talpa.translate.render

import android.content.Context
import android.graphics.*
import android.text.Layout
import android.text.StaticLayout
import android.text.TextPaint
import android.util.Log
import android.util.TypedValue
import com.talpa.translate.base.utils.MAX_TEXT_SIZE
import com.talpa.translate.base.utils.SPACINGMULT
import com.talpa.translate.base.utils.getAutofitTextSize
import com.talpa.translate.ocr.datasource.CompleteResult
import kotlinx.coroutines.*
import kotlin.math.min
import kotlin.math.pow
import kotlin.math.sqrt


/**
 * Create by chenjunsheng on 2020/7/14
 */
class TranslatorRender(val context: Context) : Render {

    override fun renderOverlay(renderSource: Bitmap, completeResult: CompleteResult) {
        runBlocking {
            completeResult.ocrResult!!.blocks.mapIndexed { index, block ->
                async(Dispatchers.Default) {
                    val canvas = Canvas(renderSource)
                    var textPaint = TextPaint(Paint.ANTI_ALIAS_FLAG)
                    val path = Path()
                    textPaint.color = Color.BLACK
                    val pathMeasure = PathMeasure()
                    Log.d("cjslog", "start render")
                    val rect = block.rect

                    val border01X = block.blockCorners.getOrNull(0)?.x ?: rect.left
                    val border01Y = block.blockCorners.getOrNull(0)?.y ?: rect.top

                    val border02X = block.blockCorners.getOrNull(1)?.x ?: rect.right
                    val border02Y = block.blockCorners.getOrNull(1)?.y ?: rect.top

                    val border03X = block.blockCorners.getOrNull(2)?.x ?: rect.right
                    val border03Y = block.blockCorners.getOrNull(2)?.y ?: rect.bottom

                    val border04X = block.blockCorners.getOrNull(3)?.x ?: rect.left
                    val border04Y = block.blockCorners.getOrNull(3)?.y ?: rect.bottom

                    val borderTopLen = sqrt(
                        ((border01X - border02X).toDouble().pow(2)
                                + (border01Y - border02Y).toDouble().pow(2))
                    )
                    val borderRightLen = sqrt(
                        ((border02X - border03X).toDouble().pow(2)
                                + (border02Y - border03Y).toDouble().pow(2))
                    )
                    val borderBottomLen = sqrt(
                        ((border03X - border04X).toDouble().pow(2)
                                + (border03Y - border04Y).toDouble().pow(2))
                    )
                    val borderLeftLen = sqrt(
                        ((border01X - border04X).toDouble().pow(2)
                                + (border01Y - border04Y).toDouble().pow(2))
                    )

                    val textRectWidth = (borderTopLen + borderBottomLen) / 2
                    val textRectHeight = (borderRightLen + borderLeftLen) / 2

                    val textSize = getAutofitTextSize(
                        completeResult.transResponse!!.result!!.texts!![index],
                        textPaint,
                        Rect(0, 0, textRectWidth.toInt(), textRectHeight.toInt()),
                        MAX_TEXT_SIZE,
                        context
                    )
                    textPaint.textSize = TypedValue.applyDimension(
                        TypedValue.COMPLEX_UNIT_SP, textSize.toFloat(),
                        context.resources.displayMetrics
                    )
                    val translation = completeResult.transResponse!!.result!!.texts!![index]
                    val staticLayout = StaticLayout(
                        translation,
                        textPaint, rect.width(),
                        Layout.Alignment.ALIGN_NORMAL,
                        SPACINGMULT,
                        0.0f,
                        false
                    )

                    repeat(staticLayout.lineCount) {
                        path.reset()
                        //left
                        path.moveTo(border01X.toFloat(), border01Y.toFloat())
                        path.lineTo(border04X.toFloat(), border04Y.toFloat())
                        pathMeasure.setPath(path, false)

                        val leftEachLen = borderLeftLen / staticLayout.lineCount

                        val childPath = Path()
                        pathMeasure.getSegment((it * leftEachLen).toFloat(),
                            min((it * leftEachLen).toFloat() + leftEachLen.toFloat(), pathMeasure.length),
                            childPath, true)

                        pathMeasure.setPath(childPath, false)

                        val posLeft = FloatArray(2)
                        pathMeasure.getPosTan(pathMeasure.length / 2, posLeft, null)

                        //right
                        path.reset()
                        path.moveTo(border02X.toFloat(), border02Y.toFloat())
                        path.lineTo(border03X.toFloat(), border03Y.toFloat())
                        pathMeasure.setPath(path, false)

                        val rightEachLen = borderLeftLen / staticLayout.lineCount

                        childPath.reset()
                        pathMeasure.getSegment((it * rightEachLen).toFloat(),
                            min((it * rightEachLen).toFloat() + rightEachLen.toFloat(), pathMeasure.length),
                            childPath, true)

                        pathMeasure.setPath(childPath, false)

                        val posRight = FloatArray(2)
                        pathMeasure.getPosTan(pathMeasure.length / 2, posRight, null)

                        val centerLinePath = Path()
                        centerLinePath.moveTo(posLeft[0], posLeft[1])
                        centerLinePath.lineTo(posRight[0], posRight[1])

                        val drawingTextSb = StringBuilder(translation.substring(staticLayout.getLineStart(it),
                            staticLayout.getLineEnd(it)))

                        val fm = textPaint.fontMetrics

                        canvas.drawTextOnPath(
                            drawingTextSb.toString(), centerLinePath, 0f,
                            (fm.bottom - fm.top) / 2 - fm.bottom, textPaint
                        )
                        Log.d("cjslog", "end render")
                        /*val path01 = Path()
                        path01.moveTo(border01_x.toFloat(), border01_y.toFloat())
                        path01.lineTo(border02_x.toFloat(), border02_y.toFloat())
                        path01.lineTo(border03_x.toFloat(), border03_y.toFloat())
                        path01.lineTo(border04_x.toFloat(), border04_y.toFloat())
                        path01.close()

                        val p = Paint()
                        p.style = Paint.Style.STROKE
                        p.setColor(Color.RED)
                        p.strokeWidth = 2f
                        canvas.drawPath(path01, p)

                        p.setColor(Color.GREEN)
                        canvas.drawRect(block.rect, p)*/

                    }
                }
            }.awaitAll()

        }

    }


}