/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.surface.opengl.program;

import android.opengl.GLES20;
import androidx.compose.runtime.internal.StabilityInferred;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import com.talpa.translate.camera.surface.opengl.core.GlBindable;
import com.talpa.translate.camera.surface.opengl.core.GlBindableKt;
import com.talpa.translate.camera.surface.opengl.draw.GlDrawable;
import com.talpa.translate.camera.surface.opengl.program.GlProgramLocation;
import com.talpa.translate.camera.surface.opengl.program.GlShader;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB\u001b\b\u0016\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fB+\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0004J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0004J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\u0015H\u0016J\b\u0010#\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/talpa/translate/camera/surface/opengl/program/GlProgram;", "Lcom/talpa/translate/camera/surface/opengl/core/GlBindable;", "handle", "", "(I)V", "vertexShader", "", "fragmentShader", "(Ljava/lang/String;Ljava/lang/String;)V", "shaders", "", "Lcom/talpa/translate/camera/surface/opengl/program/GlShader;", "([Lcom/talpa/translate/camera/surface/opengl/program/GlShader;)V", "ownsHandle", "", "(IZ[Lcom/talpa/translate/camera/surface/opengl/program/GlShader;)V", "getHandle", "()I", "isReleased", "[Lcom/talpa/translate/camera/surface/opengl/program/GlShader;", "bind", "", "draw", "drawable", "Lcom/talpa/translate/camera/surface/opengl/draw/GlDrawable;", "modelViewProjectionMatrix", "", "getAttribHandle", "Lcom/talpa/translate/camera/surface/opengl/program/GlProgramLocation;", "name", "getUniformHandle", "onDraw", "onPostDraw", "onPreDraw", "release", "unbind", "Companion", "translation_foreignRelease"})
@StabilityInferred(parameters=0)
public class GlProgram
implements GlBindable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int handle;
    private final boolean ownsHandle;
    @NotNull
    private final GlShader[] shaders;
    private boolean isReleased;
    public static final int $stable = 8;
    private static final String TAG = GlProgram.class.getSimpleName();

    protected GlProgram(int handle, boolean ownsHandle, GlShader ... shaders) {
        Intrinsics.checkNotNullParameter((Object)shaders, (String)"shaders");
        this.handle = handle;
        this.ownsHandle = ownsHandle;
        this.shaders = shaders;
    }

    public final int getHandle() {
        return this.handle;
    }

    public GlProgram(int handle) {
        this(handle, false, new GlShader[0]);
    }

    public GlProgram(@NotNull String vertexShader, @NotNull String fragmentShader) {
        Intrinsics.checkNotNullParameter((Object)vertexShader, (String)"vertexShader");
        Intrinsics.checkNotNullParameter((Object)fragmentShader, (String)"fragmentShader");
        GlShader[] glShaderArray = new GlShader[]{new GlShader(35633, vertexShader), new GlShader(35632, fragmentShader)};
        this(glShaderArray);
    }

    public GlProgram(GlShader ... shaders) {
        Intrinsics.checkNotNullParameter((Object)shaders, (String)"shaders");
        this(Companion.create(Arrays.copyOf(shaders, shaders.length)), true, Arrays.copyOf(shaders, shaders.length));
    }

    public void release() {
        if (!this.isReleased) {
            if (this.ownsHandle) {
                GLES20.glDeleteProgram((int)this.handle);
            }
            GlShader[] $this$forEach$iv = this.shaders;
            boolean $i$f$forEach = false;
            GlShader[] glShaderArray = $this$forEach$iv;
            int n = glShaderArray.length;
            for (int i = 0; i < n; ++i) {
                GlShader element$iv;
                GlShader it = element$iv = glShaderArray[i];
                boolean bl = false;
                it.release();
            }
            this.isReleased = true;
        }
    }

    @Override
    public void bind() {
        GLES20.glUseProgram((int)this.handle);
        Egloo.checkGlError("glUseProgram");
    }

    @Override
    public void unbind() {
        GLES20.glUseProgram((int)0);
    }

    @JvmOverloads
    public final void draw(@NotNull GlDrawable drawable2, @NotNull float[] modelViewProjectionMatrix) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)modelViewProjectionMatrix, (String)"modelViewProjectionMatrix");
        Egloo.checkGlError("draw start");
        GlBindableKt.use(this, (Function0<Unit>)((Function0)new Function0<Unit>(this, drawable2, modelViewProjectionMatrix){
            final /* synthetic */ GlProgram this$0;
            final /* synthetic */ GlDrawable $drawable;
            final /* synthetic */ float[] $modelViewProjectionMatrix;
            {
                this.this$0 = $receiver;
                this.$drawable = $drawable;
                this.$modelViewProjectionMatrix = $modelViewProjectionMatrix;
                super(0);
            }

            public final void invoke() {
                this.this$0.onPreDraw(this.$drawable, this.$modelViewProjectionMatrix);
                this.this$0.onDraw(this.$drawable);
                this.this$0.onPostDraw(this.$drawable);
            }
        }));
        Egloo.checkGlError("draw end");
    }

    public static /* synthetic */ void draw$default(GlProgram glProgram, GlDrawable glDrawable, float[] fArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: draw");
        }
        if ((n & 2) != 0) {
            fArray = glDrawable.getModelMatrix();
        }
        glProgram.draw(glDrawable, fArray);
    }

    public void onPreDraw(@NotNull GlDrawable drawable2, @NotNull float[] modelViewProjectionMatrix) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)modelViewProjectionMatrix, (String)"modelViewProjectionMatrix");
    }

    public void onDraw(@NotNull GlDrawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        drawable2.draw();
    }

    public void onPostDraw(@NotNull GlDrawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
    }

    @NotNull
    protected final GlProgramLocation getAttribHandle(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return GlProgramLocation.Companion.getAttrib(this.handle, name);
    }

    @NotNull
    protected final GlProgramLocation getUniformHandle(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return GlProgramLocation.Companion.getUniform(this.handle, name);
    }

    @JvmOverloads
    public final void draw(@NotNull GlDrawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        GlProgram.draw$default(this, drawable2, null, 2, null);
    }

    @Deprecated(message="Use create(GlShader) signature.")
    @JvmStatic
    public static final int create(@NotNull String vertexShaderSource, @NotNull String fragmentShaderSource) {
        return Companion.create(vertexShaderSource, fragmentShaderSource);
    }

    @JvmStatic
    public static final int create(GlShader ... shaders) {
        return Companion.create(shaders);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007R\"\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/talpa/translate/camera/surface/opengl/program/GlProgram$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "getTAG$translation_foreignRelease$annotations", "getTAG$translation_foreignRelease", "()Ljava/lang/String;", "create", "", "shaders", "", "Lcom/talpa/translate/camera/surface/opengl/program/GlShader;", "([Lcom/talpa/translate/camera/surface/opengl/program/GlShader;)I", "vertexShaderSource", "fragmentShaderSource", "translation_foreignRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final String getTAG$translation_foreignRelease() {
            return TAG;
        }

        public static /* synthetic */ void getTAG$translation_foreignRelease$annotations() {
        }

        @Deprecated(message="Use create(GlShader) signature.")
        @JvmStatic
        public final int create(@NotNull String vertexShaderSource, @NotNull String fragmentShaderSource) {
            Intrinsics.checkNotNullParameter((Object)vertexShaderSource, (String)"vertexShaderSource");
            Intrinsics.checkNotNullParameter((Object)fragmentShaderSource, (String)"fragmentShaderSource");
            GlShader[] glShaderArray = new GlShader[]{new GlShader(35633, vertexShaderSource), new GlShader(35632, fragmentShaderSource)};
            return this.create(glShaderArray);
        }

        @JvmStatic
        public final int create(GlShader ... shaders) {
            Intrinsics.checkNotNullParameter((Object)shaders, (String)"shaders");
            int program = GLES20.glCreateProgram();
            Egloo.checkGlError("glCreateProgram");
            if (program == 0) {
                throw new RuntimeException("Could not create program");
            }
            GlShader[] $this$forEach$iv = shaders;
            boolean $i$f$forEach = false;
            GlShader[] glShaderArray = $this$forEach$iv;
            int n = glShaderArray.length;
            for (int i = 0; i < n; ++i) {
                GlShader element$iv;
                GlShader it = element$iv = glShaderArray[i];
                boolean bl = false;
                GLES20.glAttachShader((int)program, (int)it.getId());
                Egloo.checkGlError("glAttachShader");
            }
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                String message = Intrinsics.stringPlus((String)"Could not link program: ", (Object)GLES20.glGetProgramInfoLog((int)program));
                GLES20.glDeleteProgram((int)program);
                throw new RuntimeException(message);
            }
            return program;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

