/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.datasource;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.LifecycleOwner;
import com.talpa.translate.camera.view.CameraListener;
import com.talpa.translate.camera.view.CameraView;
import com.talpa.translate.camera.view.PictureResult;
import com.talpa.translate.camera.view.controls.Audio;
import com.talpa.translate.camera.view.controls.Engine;
import com.talpa.translate.camera.view.controls.Facing;
import com.talpa.translate.camera.view.controls.Flash;
import com.talpa.translate.camera.view.controls.Grid;
import com.talpa.translate.camera.view.controls.Mode;
import com.talpa.translate.camera.view.controls.Preview;
import com.talpa.translate.camera.view.gesture.Gesture;
import com.talpa.translate.camera.view.gesture.GestureAction;
import com.talpa.translate.camera.view.markers.DefaultAutoFocusMarker;
import com.talpa.translate.camera.view.preview.ViewTouchListener;
import com.talpa.translate.datasource.ICameraSource;
import com.talpa.translate.ocr.exception.NoContentException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/talpa/translate/datasource/CameraCompatSource;", "Lcom/talpa/translate/datasource/ICameraSource;", "()V", "mCamera", "Lcom/talpa/translate/camera/view/CameraView;", "getMCamera", "()Lcom/talpa/translate/camera/view/CameraView;", "setMCamera", "(Lcom/talpa/translate/camera/view/CameraView;)V", "mOrientation", "", "mStatus", "Lcom/talpa/translate/datasource/ICameraSource$Status;", "initialize", "", "context", "Landroid/content/Context;", "camera", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "open", "pause", "release", "setStatusCallback", "status", "setViewTouchListener", "listener", "Lcom/talpa/translate/camera/view/preview/ViewTouchListener;", "takePicture", "torch", "switch", "", "L", "translation_foreignRelease"})
@StabilityInferred(parameters=0)
public class CameraCompatSource
implements ICameraSource {
    protected CameraView mCamera;
    @Nullable
    private ICameraSource.Status mStatus;
    private int mOrientation;
    public static final int $stable = 8;

    @NotNull
    protected final CameraView getMCamera() {
        CameraView cameraView = this.mCamera;
        if (cameraView != null) {
            return cameraView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mCamera");
        throw null;
    }

    protected final void setMCamera(@NotNull CameraView cameraView) {
        Intrinsics.checkNotNullParameter((Object)((Object)cameraView), (String)"<set-?>");
        this.mCamera = cameraView;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(@NotNull Context context, @NotNull CameraView camera, @NotNull LifecycleOwner lifecycleOwner) {
        void $this$initialize_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)camera), (String)"camera");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        CameraView cameraView = camera;
        boolean bl = false;
        boolean bl2 = false;
        CameraView cameraView2 = cameraView;
        CameraCompatSource cameraCompatSource = this;
        boolean bl3 = false;
        $this$initialize_u24lambda_u2d0.setEngine(Engine.CAMERA2);
        $this$initialize_u24lambda_u2d0.setExperimental(true);
        $this$initialize_u24lambda_u2d0.setPreview(Preview.GL_SURFACE);
        $this$initialize_u24lambda_u2d0.setPlaySounds(false);
        $this$initialize_u24lambda_u2d0.setGrid(Grid.OFF);
        $this$initialize_u24lambda_u2d0.setFlash(Flash.OFF);
        $this$initialize_u24lambda_u2d0.setAudio(Audio.OFF);
        $this$initialize_u24lambda_u2d0.setFacing(Facing.BACK);
        $this$initialize_u24lambda_u2d0.mapGesture(Gesture.TAP, GestureAction.AUTO_FOCUS);
        $this$initialize_u24lambda_u2d0.mapGesture(Gesture.LONG_TAP, GestureAction.NONE);
        $this$initialize_u24lambda_u2d0.mapGesture(Gesture.PINCH, GestureAction.ZOOM);
        $this$initialize_u24lambda_u2d0.setMode(Mode.PICTURE);
        $this$initialize_u24lambda_u2d0.setAutoFocusMarker(new DefaultAutoFocusMarker());
        $this$initialize_u24lambda_u2d0.setUseDeviceOrientation(false);
        $this$initialize_u24lambda_u2d0.setFrameProcessingFormat(35);
        Unit unit = Unit.INSTANCE;
        cameraCompatSource.setMCamera(cameraView);
        this.getMCamera().setLifecycleOwner(lifecycleOwner);
        this.getMCamera().addCameraListener(new L());
    }

    public final void setViewTouchListener(@NotNull ViewTouchListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.getMCamera().setViewTouchListener(listener);
    }

    @Override
    public void setStatusCallback(@NotNull ICameraSource.Status status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.mStatus = status;
    }

    @Override
    public void open() {
        if (!this.getMCamera().isOpened()) {
            this.getMCamera().open();
        }
    }

    @Override
    public void pause() {
        if (this.getMCamera().isOpened()) {
            this.getMCamera().close();
        }
    }

    @Override
    public void release() {
        this.getMCamera().destroy();
    }

    @Override
    public void takePicture() {
        this.getMCamera().takePictureSnapshot();
    }

    @Override
    public void torch(boolean bl) {
        this.getMCamera().set(bl ? Flash.TORCH : Flash.OFF);
        ICameraSource.Status status = this.mStatus;
        if (status != null) {
            status.onStatusChange(bl ? 0 : 1);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/talpa/translate/datasource/CameraCompatSource$L;", "Lcom/talpa/translate/camera/view/CameraListener;", "(Lcom/talpa/translate/datasource/CameraCompatSource;)V", "onOrientationChanged", "", "orientation", "", "onPictureTaken", "result", "Lcom/talpa/translate/camera/view/PictureResult;", "translation_foreignRelease"})
    public final class L
    extends CameraListener {
        public L() {
            Intrinsics.checkNotNullParameter((Object)CameraCompatSource.this, (String)"this$0");
        }

        @Override
        public void onPictureTaken(@NotNull PictureResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (result.getData() != null) {
                ICameraSource.Status status = CameraCompatSource.this.mStatus;
                if (status != null) {
                    byte[] byArray = result.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"result.data");
                    status.onPicturetaked(byArray, CameraCompatSource.this.mOrientation);
                }
            } else {
                ICameraSource.Status status = CameraCompatSource.this.mStatus;
                if (status != null) {
                    status.onPicturetakeFail(new NoContentException(null, 1, null));
                }
            }
        }

        @Override
        public void onOrientationChanged(int orientation) {
            super.onOrientationChanged(orientation);
            CameraCompatSource.this.mOrientation = orientation;
        }
    }
}

