/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.surface.opengl.core;

import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.GLU;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.talpa.translate.camera.surface.opengl.extensions.MatrixKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/talpa/translate/camera/surface/opengl/core/Egloo;", "", "()V", "IDENTITY_MATRIX", "", "SIZE_OF_FLOAT", "", "checkEglError", "", "opName", "", "checkGlError", "checkGlProgramLocation", "location", "label", "logCurrent", "msg", "translation_foreignRelease"})
@StabilityInferred(parameters=0)
public final class Egloo {
    @NotNull
    public static final Egloo INSTANCE = new Egloo();
    public static final int SIZE_OF_FLOAT = 4;
    @JvmField
    @NotNull
    public static final float[] IDENTITY_MATRIX;
    public static final int $stable;

    private Egloo() {
    }

    @JvmStatic
    public static final void checkGlError(@NotNull String opName) {
        Intrinsics.checkNotNullParameter((Object)opName, (String)"opName");
        int error = GLES20.glGetError();
        if (error != 0) {
            String message = "Error during " + opName + ": glError 0x" + Integer.toHexString(error) + ": " + GLU.gluErrorString((int)error);
            Log.e((String)"Egloo", (String)message);
            throw new RuntimeException(message);
        }
    }

    @JvmStatic
    public static final void checkEglError(@NotNull String opName) {
        Intrinsics.checkNotNullParameter((Object)opName, (String)"opName");
        int error = EGL14.eglGetError();
        if (error != 12288) {
            String message = "Error during " + opName + ": EGL error 0x" + Integer.toHexString(error);
            Log.e((String)"Egloo", (String)message);
            throw new RuntimeException(message);
        }
    }

    @JvmStatic
    public static final void checkGlProgramLocation(int location, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        if (location < 0) {
            String message = "Unable to locate " + label + " in program";
            Log.e((String)"Egloo", (String)message);
            throw new RuntimeException(message);
        }
    }

    @JvmStatic
    public static final void logCurrent(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        EGLDisplay display = EGL14.eglGetCurrentDisplay();
        EGLContext context = EGL14.eglGetCurrentContext();
        EGLSurface surface = EGL14.eglGetCurrentSurface((int)12377);
        Log.i((String)"Egloo", (String)("Current EGL (" + msg + "): display=" + display + ", context=" + context + ", surface=" + surface));
    }

    static {
        float[] fArray = new float[16];
        boolean bl = false;
        boolean bl2 = false;
        float[] $this$IDENTITY_MATRIX_u24lambda_u2d0 = fArray;
        boolean bl3 = false;
        MatrixKt.makeIdentity($this$IDENTITY_MATRIX_u24lambda_u2d0);
        IDENTITY_MATRIX = fArray;
        $stable = 8;
    }
}

