/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view;

import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.talpa.translate.camera.view.controls.Audio;
import com.talpa.translate.camera.view.controls.Facing;
import com.talpa.translate.camera.view.controls.VideoCodec;
import com.talpa.translate.camera.view.size.Size;
import java.io.File;
import java.io.FileDescriptor;

public class VideoResult {
    public static final int REASON_USER = 0;
    public static final int REASON_MAX_SIZE_REACHED = 1;
    public static final int REASON_MAX_DURATION_REACHED = 2;
    private final boolean isSnapshot;
    private final Location location;
    private final int rotation;
    private final Size size;
    private final File file;
    private final FileDescriptor fileDescriptor;
    private final Facing facing;
    private final VideoCodec videoCodec;
    private final Audio audio;
    private final long maxSize;
    private final int maxDuration;
    private final int endReason;
    private final int videoBitRate;
    private final int videoFrameRate;
    private final int audioBitRate;

    VideoResult(@NonNull Stub builder2) {
        this.isSnapshot = builder2.isSnapshot;
        this.location = builder2.location;
        this.rotation = builder2.rotation;
        this.size = builder2.size;
        this.file = builder2.file;
        this.fileDescriptor = builder2.fileDescriptor;
        this.facing = builder2.facing;
        this.videoCodec = builder2.videoCodec;
        this.audio = builder2.audio;
        this.maxSize = builder2.maxSize;
        this.maxDuration = builder2.maxDuration;
        this.endReason = builder2.endReason;
        this.videoBitRate = builder2.videoBitRate;
        this.videoFrameRate = builder2.videoFrameRate;
        this.audioBitRate = builder2.audioBitRate;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    public int getRotation() {
        return this.rotation;
    }

    @NonNull
    public Size getSize() {
        return this.size;
    }

    @NonNull
    public File getFile() {
        if (this.file == null) {
            throw new RuntimeException("File is only available when takeVideo(File) is used.");
        }
        return this.file;
    }

    @NonNull
    public FileDescriptor getFileDescriptor() {
        if (this.fileDescriptor == null) {
            throw new RuntimeException("FileDescriptor is only available when takeVideo(FileDescriptor) is used.");
        }
        return this.fileDescriptor;
    }

    @NonNull
    public Facing getFacing() {
        return this.facing;
    }

    @NonNull
    public VideoCodec getVideoCodec() {
        return this.videoCodec;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    @NonNull
    public Audio getAudio() {
        return this.audio;
    }

    public int getTerminationReason() {
        return this.endReason;
    }

    public int getVideoBitRate() {
        return this.videoBitRate;
    }

    public int getVideoFrameRate() {
        return this.videoFrameRate;
    }

    public int getAudioBitRate() {
        return this.audioBitRate;
    }

    public static class Stub {
        public boolean isSnapshot;
        public Location location;
        public int rotation;
        public Size size;
        public File file;
        public FileDescriptor fileDescriptor;
        public Facing facing;
        public VideoCodec videoCodec;
        public Audio audio;
        public long maxSize;
        public int maxDuration;
        public int endReason;
        public int videoBitRate;
        public int videoFrameRate;
        public int audioBitRate;

        Stub() {
        }
    }
}

