/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.GradientDrawable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.talpa.translate.base.view.UtilsKt;
import com.talpa.translate.camera.view.controls.Grid;

public class GridLinesLayout
extends View {
    private static final float GOLDEN_RATIO_INV = 0.618034f;
    private static final float DEFAULT_TIPS_BOTTOM_MARGIN = 20.0f;
    public static final int[] DEFAULT_COLOR = new int[]{Color.argb((int)0, (int)255, (int)255, (int)255), Color.argb((int)255, (int)255, (int)255, (int)255), Color.argb((int)0, (int)255, (int)255, (int)255)};
    private Grid gridMode;
    private int[] gridColor = DEFAULT_COLOR;
    private GradientDrawable horiz;
    private GradientDrawable vert;
    private final float width;
    private String tips;
    private TextPaint mTextPaint = new TextPaint();
    @VisibleForTesting
    DrawCallback callback;

    public GridLinesLayout(@NonNull Context context) {
        this(context, null);
    }

    public GridLinesLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.horiz = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, DEFAULT_COLOR);
        this.vert = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, DEFAULT_COLOR);
        this.width = TypedValue.applyDimension((int)1, (float)0.9f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.mTextPaint.setTextSize(UtilsKt.sp2px(12.0f));
        this.mTextPaint.setColor(-1);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.horiz.setBounds(left, 0, right, (int)this.width);
        this.vert.setBounds(0, top, (int)this.width, bottom);
    }

    @NonNull
    public Grid getGridMode() {
        return this.gridMode;
    }

    public void setGridMode(@NonNull Grid gridMode) {
        this.gridMode = gridMode;
        this.postInvalidate();
    }

    public int[] getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(@ColorInt int[] gridColor) {
        this.gridColor = gridColor;
        this.horiz.setColors(gridColor);
        this.vert.setColors(gridColor);
        this.postInvalidate();
    }

    public void setTips(String text) {
        this.tips = text;
    }

    private int getLineCount() {
        switch (this.gridMode) {
            case OFF: {
                return 0;
            }
            case DRAW_3X3: {
                return 2;
            }
            case DRAW_PHI: {
                return 2;
            }
            case DRAW_4X4: {
                return 3;
            }
        }
        return 0;
    }

    private float getLinePosition(int lineNumber) {
        int lineCount = this.getLineCount();
        if (this.gridMode == Grid.DRAW_PHI) {
            float delta = 0.38196602f;
            return lineNumber == 1 ? delta : 1.0f - delta;
        }
        return 1.0f / (float)(lineCount + 1) * ((float)lineNumber + 1.0f);
    }

    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        int count = this.getLineCount();
        for (int n = 0; n < count; ++n) {
            float pos = this.getLinePosition(n);
            canvas.translate(0.0f, pos * (float)this.getHeight());
            this.horiz.draw(canvas);
            canvas.translate(0.0f, -pos * (float)this.getHeight());
            canvas.translate(pos * (float)this.getWidth(), 0.0f);
            this.vert.draw(canvas);
            canvas.translate(-pos * (float)this.getWidth(), 0.0f);
        }
        if (!TextUtils.isEmpty((CharSequence)this.tips)) {
            switch (this.gridMode) {
                case DRAW_3X3: {
                    float posStart = this.getLinePosition(0) * (float)this.getWidth();
                    float posEnd = this.getLinePosition(1) * (float)this.getWidth();
                    float textLen = this.mTextPaint.measureText(this.tips);
                    float posLen = Math.abs(posEnd - posStart);
                    float textStartX = (posLen - textLen) / 2.0f + posStart;
                    float textStartY = this.getLinePosition(0) * (float)this.getHeight();
                    canvas.drawText(this.tips, textStartX, textStartY - 20.0f, (Paint)this.mTextPaint);
                    break;
                }
                case DRAW_PHI: {
                    break;
                }
            }
        }
        if (this.callback != null) {
            this.callback.onDraw(count);
        }
    }

    static interface DrawCallback {
        public void onDraw(int var1);
    }
}

