/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.preview;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.photo.translation.R;
import com.talpa.translate.camera.view.filter.Filter;
import com.talpa.translate.camera.view.filter.NoFilter;
import com.talpa.translate.camera.view.internal.GlTextureDrawer;
import com.talpa.translate.camera.view.preview.CameraPreview;
import com.talpa.translate.camera.view.preview.FilterCameraPreview;
import com.talpa.translate.camera.view.preview.RendererCameraPreview;
import com.talpa.translate.camera.view.preview.RendererFrameCallback;
import com.talpa.translate.camera.view.preview.RendererThread;
import com.talpa.translate.camera.view.size.AspectRatio;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GlCameraPreview
extends CameraPreview<GLSurfaceView, SurfaceTexture>
implements FilterCameraPreview,
RendererCameraPreview {
    private boolean mDispatched;
    private SurfaceTexture mInputSurfaceTexture;
    private GlTextureDrawer mOutputTextureDrawer;
    private final Set<RendererFrameCallback> mRendererFrameCallbacks = new CopyOnWriteArraySet<RendererFrameCallback>();
    @VisibleForTesting
    float mCropScaleX = 1.0f;
    @VisibleForTesting
    float mCropScaleY = 1.0f;
    private View mRootView;
    private Filter mCurrentFilter;

    public GlCameraPreview(@NonNull Context context, @NonNull ViewGroup parent) {
        super(context, parent);
    }

    @Override
    @NonNull
    protected GLSurfaceView onCreateView(@NonNull Context context, @NonNull ViewGroup parent) {
        final GLSurfaceView glView = (GLSurfaceView)LayoutInflater.from((Context)context).inflate(R.layout.cameraview_gl_view, parent, false);
        final Renderer renderer = this.instantiateRenderer();
        glView.setEGLContextClientVersion(2);
        glView.setRenderer((GLSurfaceView.Renderer)renderer);
        glView.setRenderMode(0);
        glView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                GlCameraPreview.this.dispatchOnSurfaceDestroyed();
                glView.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        renderer.onSurfaceDestroyed();
                    }
                });
                GlCameraPreview.this.mDispatched = false;
            }
        });
        parent.addView((View)glView, 0);
        this.mRootView = glView;
        return glView;
    }

    @Override
    @NonNull
    public View getRootView() {
        return this.mRootView;
    }

    @Override
    public void onResume() {
        super.onResume();
        ((GLSurfaceView)this.getView()).onResume();
    }

    @Override
    public void onPause() {
        super.onPause();
        ((GLSurfaceView)this.getView()).onPause();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mRendererFrameCallbacks.clear();
    }

    @Override
    @NonNull
    public Class<SurfaceTexture> getOutputClass() {
        return SurfaceTexture.class;
    }

    @Override
    @NonNull
    public SurfaceTexture getOutput() {
        return this.mInputSurfaceTexture;
    }

    @Override
    public boolean supportsCropping() {
        return true;
    }

    @Override
    protected void crop(@Nullable CameraPreview.CropCallback callback) {
        if (this.mInputStreamWidth > 0 && this.mInputStreamHeight > 0 && this.mOutputSurfaceWidth > 0 && this.mOutputSurfaceHeight > 0) {
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            AspectRatio current = AspectRatio.of(this.mOutputSurfaceWidth, this.mOutputSurfaceHeight);
            AspectRatio target = AspectRatio.of(this.mInputStreamWidth, this.mInputStreamHeight);
            if (current.toFloat() >= target.toFloat()) {
                scaleY = current.toFloat() / target.toFloat();
            } else {
                scaleX = target.toFloat() / current.toFloat();
            }
            this.mCropping = scaleX > 1.02f || scaleY > 1.02f;
            this.mCropScaleX = 1.0f / scaleX;
            this.mCropScaleY = 1.0f / scaleY;
            ((GLSurfaceView)this.getView()).requestRender();
        }
        if (callback != null) {
            callback.onCrop();
        }
    }

    @Override
    public void addRendererFrameCallback(final @NonNull RendererFrameCallback callback) {
        ((GLSurfaceView)this.getView()).queueEvent(new Runnable(){

            @Override
            public void run() {
                GlCameraPreview.this.mRendererFrameCallbacks.add(callback);
                if (GlCameraPreview.this.mOutputTextureDrawer != null) {
                    int textureId = GlCameraPreview.this.mOutputTextureDrawer.getTexture().getId();
                    callback.onRendererTextureCreated(textureId);
                }
                callback.onRendererFilterChanged(GlCameraPreview.this.mCurrentFilter);
            }
        });
    }

    @Override
    public void removeRendererFrameCallback(@NonNull RendererFrameCallback callback) {
        this.mRendererFrameCallbacks.remove(callback);
    }

    protected int getTextureId() {
        return this.mOutputTextureDrawer != null ? this.mOutputTextureDrawer.getTexture().getId() : -1;
    }

    @NonNull
    protected Renderer instantiateRenderer() {
        return new Renderer();
    }

    @Override
    @NonNull
    public Filter getCurrentFilter() {
        return this.mCurrentFilter;
    }

    @Override
    public void setFilter(final @NonNull Filter filter) {
        this.mCurrentFilter = filter;
        if (this.hasSurface()) {
            filter.setSize(this.mOutputSurfaceWidth, this.mOutputSurfaceHeight);
        }
        ((GLSurfaceView)this.getView()).queueEvent(new Runnable(){

            @Override
            public void run() {
                if (GlCameraPreview.this.mOutputTextureDrawer != null) {
                    GlCameraPreview.this.mOutputTextureDrawer.setFilter(filter);
                }
                for (RendererFrameCallback callback : GlCameraPreview.this.mRendererFrameCallbacks) {
                    callback.onRendererFilterChanged(filter);
                }
            }
        });
    }

    public class Renderer
    implements GLSurfaceView.Renderer {
        @RendererThread
        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            if (GlCameraPreview.this.mCurrentFilter == null) {
                GlCameraPreview.this.mCurrentFilter = new NoFilter();
            }
            GlCameraPreview.this.mOutputTextureDrawer = new GlTextureDrawer();
            GlCameraPreview.this.mOutputTextureDrawer.setFilter(GlCameraPreview.this.mCurrentFilter);
            final int textureId = GlCameraPreview.this.mOutputTextureDrawer.getTexture().getId();
            GlCameraPreview.this.mInputSurfaceTexture = new SurfaceTexture(textureId);
            ((GLSurfaceView)GlCameraPreview.this.getView()).queueEvent(new Runnable(){

                @Override
                public void run() {
                    for (RendererFrameCallback callback : GlCameraPreview.this.mRendererFrameCallbacks) {
                        callback.onRendererTextureCreated(textureId);
                    }
                }
            });
            GlCameraPreview.this.mInputSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    ((GLSurfaceView)GlCameraPreview.this.getView()).requestRender();
                }
            });
        }

        @RendererThread
        public void onSurfaceDestroyed() {
            if (GlCameraPreview.this.mInputSurfaceTexture != null) {
                GlCameraPreview.this.mInputSurfaceTexture.setOnFrameAvailableListener(null);
                GlCameraPreview.this.mInputSurfaceTexture.release();
                GlCameraPreview.this.mInputSurfaceTexture = null;
            }
            if (GlCameraPreview.this.mOutputTextureDrawer != null) {
                GlCameraPreview.this.mOutputTextureDrawer.release();
                GlCameraPreview.this.mOutputTextureDrawer = null;
            }
        }

        @RendererThread
        public void onSurfaceChanged(GL10 gl, int width, int height) {
            gl.glViewport(0, 0, width, height);
            GlCameraPreview.this.mCurrentFilter.setSize(width, height);
            if (!GlCameraPreview.this.mDispatched) {
                GlCameraPreview.this.dispatchOnSurfaceAvailable(width, height);
                GlCameraPreview.this.mDispatched = true;
            } else if (width != GlCameraPreview.this.mOutputSurfaceWidth || height != GlCameraPreview.this.mOutputSurfaceHeight) {
                GlCameraPreview.this.dispatchOnSurfaceSizeChanged(width, height);
            }
        }

        @RendererThread
        public void onDrawFrame(GL10 gl) {
            if (GlCameraPreview.this.mInputSurfaceTexture == null) {
                return;
            }
            if (GlCameraPreview.this.mInputStreamWidth <= 0 || GlCameraPreview.this.mInputStreamHeight <= 0) {
                return;
            }
            float[] transform = GlCameraPreview.this.mOutputTextureDrawer.getTextureTransform();
            GlCameraPreview.this.mInputSurfaceTexture.updateTexImage();
            GlCameraPreview.this.mInputSurfaceTexture.getTransformMatrix(transform);
            if (GlCameraPreview.this.mDrawRotation != 0) {
                Matrix.translateM((float[])transform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
                Matrix.rotateM((float[])transform, (int)0, (float)GlCameraPreview.this.mDrawRotation, (float)0.0f, (float)0.0f, (float)1.0f);
                Matrix.translateM((float[])transform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
            }
            if (GlCameraPreview.this.isCropping()) {
                float translX = (1.0f - GlCameraPreview.this.mCropScaleX) / 2.0f;
                float translY = (1.0f - GlCameraPreview.this.mCropScaleY) / 2.0f;
                Matrix.translateM((float[])transform, (int)0, (float)translX, (float)translY, (float)0.0f);
                Matrix.scaleM((float[])transform, (int)0, (float)GlCameraPreview.this.mCropScaleX, (float)GlCameraPreview.this.mCropScaleY, (float)1.0f);
            }
            GlCameraPreview.this.mOutputTextureDrawer.draw(GlCameraPreview.this.mInputSurfaceTexture.getTimestamp() / 1000L);
            for (RendererFrameCallback callback : GlCameraPreview.this.mRendererFrameCallbacks) {
                callback.onRendererFrame(GlCameraPreview.this.mInputSurfaceTexture, GlCameraPreview.this.mDrawRotation, GlCameraPreview.this.mCropScaleX, GlCameraPreview.this.mCropScaleY);
            }
        }
    }
}

