/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.video.encoding;

import androidx.annotation.NonNull;
import com.talpa.translate.camera.view.video.encoding.AudioConfig;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.Random;

class AudioNoise {
    private static final int FRAMES = 1;
    private static final Random RANDOM = new Random();
    private final ByteBuffer mNoiseBuffer;

    AudioNoise(@NonNull AudioConfig config) {
        Objects.requireNonNull(config);
        if (2 != 2) {
            throw new IllegalArgumentException("AudioNoise expects 2bytes-1short samples.");
        }
        this.mNoiseBuffer = ByteBuffer.allocateDirect(config.frameSize() * 1).order(ByteOrder.nativeOrder());
        double i = 0.0;
        double frequency = (double)config.frameSize() / 2.0;
        double step = Math.PI / frequency;
        double max = 10.0;
        while (this.mNoiseBuffer.hasRemaining()) {
            short noise = (short)(Math.sin((i += 1.0) * step) * max);
            this.mNoiseBuffer.put((byte)noise);
            this.mNoiseBuffer.put((byte)(noise >> 8));
        }
        this.mNoiseBuffer.rewind();
    }

    void fill(@NonNull ByteBuffer outBuffer) {
        this.mNoiseBuffer.clear();
        if (this.mNoiseBuffer.capacity() == outBuffer.remaining()) {
            this.mNoiseBuffer.position(0);
        } else {
            this.mNoiseBuffer.position(RANDOM.nextInt(this.mNoiseBuffer.capacity() - outBuffer.remaining()));
        }
        this.mNoiseBuffer.limit(this.mNoiseBuffer.position() + outBuffer.remaining());
        outBuffer.put(this.mNoiseBuffer);
    }
}

