/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view;

import androidx.annotation.NonNull;
import com.talpa.translate.camera.view.controls.Audio;
import com.talpa.translate.camera.view.controls.Control;
import com.talpa.translate.camera.view.controls.Engine;
import com.talpa.translate.camera.view.controls.Facing;
import com.talpa.translate.camera.view.controls.Flash;
import com.talpa.translate.camera.view.controls.Grid;
import com.talpa.translate.camera.view.controls.Hdr;
import com.talpa.translate.camera.view.controls.Mode;
import com.talpa.translate.camera.view.controls.PictureFormat;
import com.talpa.translate.camera.view.controls.Preview;
import com.talpa.translate.camera.view.controls.VideoCodec;
import com.talpa.translate.camera.view.controls.WhiteBalance;
import com.talpa.translate.camera.view.gesture.GestureAction;
import com.talpa.translate.camera.view.size.AspectRatio;
import com.talpa.translate.camera.view.size.Size;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class CameraOptions {
    protected Set<WhiteBalance> supportedWhiteBalance = new HashSet<WhiteBalance>(5);
    protected Set<Facing> supportedFacing = new HashSet<Facing>(2);
    protected Set<Flash> supportedFlash = new HashSet<Flash>(4);
    protected Set<Hdr> supportedHdr = new HashSet<Hdr>(2);
    protected Set<Size> supportedPictureSizes = new HashSet<Size>(15);
    protected Set<Size> supportedVideoSizes = new HashSet<Size>(5);
    protected Set<AspectRatio> supportedPictureAspectRatio = new HashSet<AspectRatio>(4);
    protected Set<AspectRatio> supportedVideoAspectRatio = new HashSet<AspectRatio>(3);
    protected Set<PictureFormat> supportedPictureFormats = new HashSet<PictureFormat>(2);
    protected Set<Integer> supportedFrameProcessingFormats = new HashSet<Integer>(2);
    protected boolean zoomSupported;
    protected boolean exposureCorrectionSupported;
    protected float exposureCorrectionMinValue;
    protected float exposureCorrectionMaxValue;
    protected boolean autoFocusSupported;
    protected float previewFrameRateMinValue;
    protected float previewFrameRateMaxValue;

    protected CameraOptions() {
    }

    public final boolean supports(@NonNull Control control) {
        return this.getSupportedControls(control.getClass()).contains(control);
    }

    public final boolean supports(@NonNull GestureAction action) {
        switch (action) {
            case AUTO_FOCUS: {
                return this.isAutoFocusSupported();
            }
            case TAKE_PICTURE: 
            case FILTER_CONTROL_1: 
            case FILTER_CONTROL_2: 
            case NONE: {
                return true;
            }
            case ZOOM: {
                return this.isZoomSupported();
            }
            case EXPOSURE_CORRECTION: {
                return this.isExposureCorrectionSupported();
            }
        }
        return false;
    }

    @NonNull
    public final <T extends Control> Collection<T> getSupportedControls(@NonNull Class<T> controlClass) {
        if (controlClass.equals(Audio.class)) {
            return Arrays.asList(Audio.values());
        }
        if (controlClass.equals(Facing.class)) {
            return this.getSupportedFacing();
        }
        if (controlClass.equals(Flash.class)) {
            return this.getSupportedFlash();
        }
        if (controlClass.equals(Grid.class)) {
            return Arrays.asList(Grid.values());
        }
        if (controlClass.equals(Hdr.class)) {
            return this.getSupportedHdr();
        }
        if (controlClass.equals(Mode.class)) {
            return Arrays.asList(Mode.values());
        }
        if (controlClass.equals(VideoCodec.class)) {
            return Arrays.asList(VideoCodec.values());
        }
        if (controlClass.equals(WhiteBalance.class)) {
            return this.getSupportedWhiteBalance();
        }
        if (controlClass.equals(Engine.class)) {
            return Arrays.asList(Engine.values());
        }
        if (controlClass.equals(Preview.class)) {
            return Arrays.asList(Preview.values());
        }
        if (controlClass.equals(PictureFormat.class)) {
            return this.getSupportedPictureFormats();
        }
        return Collections.emptyList();
    }

    @NonNull
    public final Collection<Size> getSupportedPictureSizes() {
        return Collections.unmodifiableSet(this.supportedPictureSizes);
    }

    @NonNull
    public final Collection<AspectRatio> getSupportedPictureAspectRatios() {
        return Collections.unmodifiableSet(this.supportedPictureAspectRatio);
    }

    @NonNull
    public final Collection<Size> getSupportedVideoSizes() {
        return Collections.unmodifiableSet(this.supportedVideoSizes);
    }

    @NonNull
    public final Collection<AspectRatio> getSupportedVideoAspectRatios() {
        return Collections.unmodifiableSet(this.supportedVideoAspectRatio);
    }

    @NonNull
    public final Collection<Facing> getSupportedFacing() {
        return Collections.unmodifiableSet(this.supportedFacing);
    }

    @NonNull
    public final Collection<Flash> getSupportedFlash() {
        return Collections.unmodifiableSet(this.supportedFlash);
    }

    @NonNull
    public final Collection<WhiteBalance> getSupportedWhiteBalance() {
        return Collections.unmodifiableSet(this.supportedWhiteBalance);
    }

    @NonNull
    public final Collection<Hdr> getSupportedHdr() {
        return Collections.unmodifiableSet(this.supportedHdr);
    }

    @NonNull
    public final Collection<PictureFormat> getSupportedPictureFormats() {
        return Collections.unmodifiableSet(this.supportedPictureFormats);
    }

    @NonNull
    public final Collection<Integer> getSupportedFrameProcessingFormats() {
        return Collections.unmodifiableSet(this.supportedFrameProcessingFormats);
    }

    public final boolean isZoomSupported() {
        return this.zoomSupported;
    }

    public final boolean isAutoFocusSupported() {
        return this.autoFocusSupported;
    }

    public final boolean isExposureCorrectionSupported() {
        return this.exposureCorrectionSupported;
    }

    public final float getExposureCorrectionMinValue() {
        return this.exposureCorrectionMinValue;
    }

    public final float getExposureCorrectionMaxValue() {
        return this.exposureCorrectionMaxValue;
    }

    public final float getPreviewFrameRateMinValue() {
        return this.previewFrameRateMinValue;
    }

    public final float getPreviewFrameRateMaxValue() {
        return this.previewFrameRateMaxValue;
    }
}

