/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.picture;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.DngCreator;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.media.ImageReader;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.exifinterface.media.ExifInterface;
import com.talpa.translate.camera.view.PictureResult;
import com.talpa.translate.camera.view.controls.PictureFormat;
import com.talpa.translate.camera.view.engine.Camera2Engine;
import com.talpa.translate.camera.view.engine.action.Action;
import com.talpa.translate.camera.view.engine.action.ActionHolder;
import com.talpa.translate.camera.view.engine.action.BaseAction;
import com.talpa.translate.camera.view.internal.ExifHelper;
import com.talpa.translate.camera.view.internal.WorkerHandler;
import com.talpa.translate.camera.view.picture.FullPictureRecorder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

@RequiresApi(value=21)
public class Full2PictureRecorder
extends FullPictureRecorder
implements ImageReader.OnImageAvailableListener {
    private final ActionHolder mHolder;
    private final Action mAction;
    private final ImageReader mPictureReader;
    private final CaptureRequest.Builder mPictureBuilder;
    private DngCreator mDngCreator;

    public Full2PictureRecorder(@NonNull PictureResult.Stub stub, @NonNull Camera2Engine engine, @NonNull CaptureRequest.Builder pictureBuilder, @NonNull ImageReader pictureReader) {
        super(stub, engine);
        this.mHolder = engine;
        this.mPictureBuilder = pictureBuilder;
        this.mPictureReader = pictureReader;
        this.mPictureReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, WorkerHandler.get().getHandler());
        this.mAction = new BaseAction(){

            @Override
            protected void onStart(@NonNull ActionHolder holder) {
                super.onStart(holder);
                Full2PictureRecorder.this.mPictureBuilder.addTarget(Full2PictureRecorder.this.mPictureReader.getSurface());
                if (Full2PictureRecorder.this.mResult.format == PictureFormat.JPEG) {
                    Full2PictureRecorder.this.mPictureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)Full2PictureRecorder.this.mResult.rotation);
                }
                Full2PictureRecorder.this.mPictureBuilder.setTag((Object)2);
                try {
                    holder.applyBuilder(this, Full2PictureRecorder.this.mPictureBuilder);
                }
                catch (CameraAccessException e) {
                    Full2PictureRecorder.this.mResult = null;
                    Full2PictureRecorder.this.mError = e;
                    Full2PictureRecorder.this.dispatchResult();
                    this.setState(Integer.MAX_VALUE);
                }
            }

            @Override
            public void onCaptureStarted(@NonNull ActionHolder holder, @NonNull CaptureRequest request) {
                super.onCaptureStarted(holder, request);
                if (request.getTag() == Integer.valueOf(2)) {
                    FullPictureRecorder.LOG.i("onCaptureStarted:", "Dispatching picture shutter.");
                    Full2PictureRecorder.this.dispatchOnShutter(false);
                    this.setState(Integer.MAX_VALUE);
                }
            }

            @Override
            public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                super.onCaptureCompleted(holder, request, result);
                if (Full2PictureRecorder.this.mResult.format == PictureFormat.DNG) {
                    Full2PictureRecorder.this.mDngCreator = new DngCreator(holder.getCharacteristics(this), (CaptureResult)result);
                    Full2PictureRecorder.this.mDngCreator.setOrientation(ExifHelper.getExifOrientation(Full2PictureRecorder.this.mResult.rotation));
                    if (Full2PictureRecorder.this.mResult.location != null) {
                        Full2PictureRecorder.this.mDngCreator.setLocation(Full2PictureRecorder.this.mResult.location);
                    }
                }
            }
        };
    }

    @Override
    public void take() {
        this.mAction.start(this.mHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onImageAvailable(ImageReader reader) {
        Full2PictureRecorder.LOG.i(new Object[]{"onImageAvailable started."});
        image = null;
        try {
            image = reader.acquireNextImage();
            switch (2.$SwitchMap$com$talpa$translate$camera$view$controls$PictureFormat[this.mResult.format.ordinal()]) {
                case 1: {
                    this.readJpegImage(image);
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.readRawImage(image);
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown format: " + this.mResult.format);
                }
            }
        }
        catch (Exception e) {
            this.mResult = null;
            this.mError = e;
            this.dispatchResult();
            return;
        }
        finally {
            if (image != null) {
                image.close();
            }
        }
        Full2PictureRecorder.LOG.i(new Object[]{"onImageAvailable ended."});
        this.dispatchResult();
    }

    private void readJpegImage(@NonNull Image image) {
        ByteBuffer buffer = image.getPlanes()[0].getBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        this.mResult.data = bytes;
        this.mResult.rotation = 0;
        try {
            ExifInterface exif = new ExifInterface((InputStream)new ByteArrayInputStream(this.mResult.data));
            int exifOrientation = exif.getAttributeInt("Orientation", 1);
            this.mResult.rotation = ExifHelper.getOrientation(exifOrientation);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readRawImage(@NonNull Image image) {
        ByteArrayOutputStream array = new ByteArrayOutputStream();
        BufferedOutputStream stream = new BufferedOutputStream(array);
        try {
            this.mDngCreator.writeImage((OutputStream)stream, image);
            stream.flush();
            this.mResult.data = array.toByteArray();
        }
        catch (IOException e) {
            this.mDngCreator.close();
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }
}

