/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.internal;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.talpa.translate.camera.view.CameraLogger;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;

public class WorkerHandler {
    private static final CameraLogger LOG = CameraLogger.create(WorkerHandler.class.getSimpleName());
    private static final ConcurrentHashMap<String, WeakReference<WorkerHandler>> sCache = new ConcurrentHashMap(4);
    private static final String FALLBACK_NAME = "FallbackCameraThread";
    private static WorkerHandler sFallbackHandler;
    private String mName;
    private HandlerThread mThread;
    private Handler mHandler;
    private Executor mExecutor;

    @NonNull
    public static WorkerHandler get(@NonNull String name) {
        if (sCache.containsKey(name)) {
            WorkerHandler cached = (WorkerHandler)sCache.get(name).get();
            if (cached != null) {
                if (cached.getThread().isAlive() && !cached.getThread().isInterrupted()) {
                    LOG.w("get:", "Reusing cached worker handler.", name);
                    return cached;
                }
                cached.destroy();
                LOG.w("get:", "Thread reference found, but not alive or interrupted.", "Removing.", name);
                sCache.remove(name);
            } else {
                LOG.w("get:", "Thread reference died. Removing.", name);
                sCache.remove(name);
            }
        }
        LOG.i("get:", "Creating new handler.", name);
        WorkerHandler handler = new WorkerHandler(name);
        sCache.put(name, new WeakReference<WorkerHandler>(handler));
        return handler;
    }

    @NonNull
    public static WorkerHandler get() {
        sFallbackHandler = WorkerHandler.get(FALLBACK_NAME);
        return sFallbackHandler;
    }

    public static void execute(@NonNull Runnable action) {
        WorkerHandler.get().post(action);
    }

    private WorkerHandler(@NonNull String name) {
        this.mName = name;
        this.mThread = new HandlerThread(name){

            @NonNull
            public String toString() {
                return super.toString() + "[" + this.getThreadId() + "]";
            }
        };
        this.mThread.setDaemon(true);
        this.mThread.start();
        this.mHandler = new Handler(this.mThread.getLooper());
        this.mExecutor = new Executor(){

            @Override
            public void execute(@NonNull Runnable command) {
                WorkerHandler.this.run(command);
            }
        };
        final CountDownLatch latch = new CountDownLatch(1);
        this.post(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run(@NonNull Runnable runnable) {
        if (Thread.currentThread() == this.getThread()) {
            runnable.run();
        } else {
            this.post(runnable);
        }
    }

    public <T> Task<T> run(@NonNull Callable<T> callable) {
        if (Thread.currentThread() == this.getThread()) {
            try {
                return Tasks.forResult(callable.call());
            }
            catch (Exception e) {
                return Tasks.forException((Exception)e);
            }
        }
        return this.post(callable);
    }

    public void post(@NonNull Runnable runnable) {
        this.mHandler.post(runnable);
    }

    public <T> Task<T> post(final @NonNull Callable<T> callable) {
        final TaskCompletionSource source = new TaskCompletionSource();
        this.post(new Runnable(){

            @Override
            public void run() {
                try {
                    source.trySetResult(callable.call());
                }
                catch (Exception e) {
                    source.trySetException(e);
                }
            }
        });
        return source.getTask();
    }

    public void post(long delay, @NonNull Runnable runnable) {
        this.mHandler.postDelayed(runnable, delay);
    }

    public void remove(@NonNull Runnable runnable) {
        this.mHandler.removeCallbacks(runnable);
    }

    @NonNull
    public Handler getHandler() {
        return this.mHandler;
    }

    @NonNull
    public HandlerThread getThread() {
        return this.mThread;
    }

    @NonNull
    public Looper getLooper() {
        return this.mThread.getLooper();
    }

    @NonNull
    public Executor getExecutor() {
        return this.mExecutor;
    }

    public void destroy() {
        HandlerThread thread = this.getThread();
        if (thread.isAlive()) {
            thread.interrupt();
            thread.quit();
        }
        sCache.remove(this.mName);
    }

    public static void destroyAll() {
        for (String key : sCache.keySet()) {
            WeakReference<WorkerHandler> ref = sCache.get(key);
            WorkerHandler handler = (WorkerHandler)ref.get();
            if (handler != null) {
                handler.destroy();
            }
            ref.clear();
        }
        sCache.clear();
    }
}

