/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.base.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import androidx.core.content.ContextCompat;
import com.photo.translation.R;
import com.talpa.translate.base.view.CaptureButtonState;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0003)*+B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0018\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0014J\u0006\u0010&\u001a\u00020\u001fJ\u0010\u0010'\u001a\u00020\u001f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0006\u0010(\u001a\u00020\u001fR\u0015\u0010\u000b\u001a\u00060\fR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0014\u001a\u00060\u0015R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u001dR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/talpa/translate/base/view/CaptureButton;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributes", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cameraState", "Lcom/talpa/translate/base/view/CaptureButton$CameraState;", "getCameraState", "()Lcom/talpa/translate/base/view/CaptureButton$CameraState;", "mAlpha", "mPaint", "Landroid/graphics/Paint;", "mRestartBitmap", "Landroid/graphics/Bitmap;", "resultState", "Lcom/talpa/translate/base/view/CaptureButton$ResultState;", "getResultState", "()Lcom/talpa/translate/base/view/CaptureButton$ResultState;", "state", "Lcom/talpa/translate/base/view/CaptureButtonState;", "transformRate", "", "transparentAnim", "Lcom/talpa/translate/base/view/CaptureButton$TransparentAnim;", "cameraDraw", "", "canvas", "Landroid/graphics/Canvas;", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "revertAnim", "setState", "startAnim", "CameraState", "ResultState", "TransparentAnim", "translation_googleRelease"})
public final class CaptureButton
extends View {
    private int mAlpha;
    private Paint mPaint;
    private final TransparentAnim transparentAnim;
    private float transformRate;
    @NotNull
    private final CameraState cameraState;
    @NotNull
    private final ResultState resultState;
    private final Bitmap mRestartBitmap;
    private CaptureButtonState state;
    private HashMap _$_findViewCache;

    @NotNull
    public final CameraState getCameraState() {
        return this.cameraState;
    }

    @NotNull
    public final ResultState getResultState() {
        return this.resultState;
    }

    public final void startAnim() {
        this.startAnimation(this.transparentAnim);
    }

    public final void revertAnim() {
        block0: {
            Animation animation = this.getAnimation();
            if (animation == null) break block0;
            animation.cancel();
        }
    }

    public final void setState(@Nullable CaptureButtonState state) {
        this.state = state;
        this.requestLayout();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            CaptureButtonState captureButtonState = this.state;
            if (captureButtonState == null) break block0;
            captureButtonState.onDraw(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        block0: {
            CaptureButtonState captureButtonState = this.state;
            if (captureButtonState == null) break block0;
            captureButtonState.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private final void cameraDraw(Canvas canvas) {
        this.mPaint.setColor(-1);
        this.mPaint.setAlpha(this.mAlpha);
        float circleCenter = (float)this.getMeasuredHeight() / 2.0f;
        float radius = (float)this.getMeasuredHeight() / 2.0f * this.transformRate;
        canvas.drawCircle(circleCenter, circleCenter, radius, this.mPaint);
        this.mPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.pickerview_bg_topbar));
        this.mPaint.setAlpha(this.mAlpha);
        canvas.drawCircle(circleCenter, circleCenter, radius - (float)8 * this.transformRate, this.mPaint);
        this.mPaint.setColor(-1);
        this.mPaint.setAlpha(this.mAlpha);
        canvas.drawCircle(circleCenter, circleCenter, radius - (float)8 * this.transformRate - (float)8 * this.transformRate, this.mPaint);
    }

    public CaptureButton(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public CaptureButton(@NotNull Context context, @Nullable AttributeSet attributes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributes, 0);
    }

    public CaptureButton(@NotNull Context context, @Nullable AttributeSet attributes, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributes, defStyle);
        this.mAlpha = 255;
        this.mPaint = new Paint();
        this.transparentAnim = new TransparentAnim();
        this.transformRate = 1.0f;
        this.cameraState = new CameraState();
        this.resultState = new ResultState();
        this.state = this.cameraState;
        this.mPaint.setAntiAlias(true);
        Drawable drawable2 = this.getBackground();
        RippleDrawable rippleDrawable = new RippleDrawable(ColorStateList.valueOf((int)ContextCompat.getColor((Context)context, (int)R.color.capture_foreground)), drawable2, null);
        this.setBackground((Drawable)rippleDrawable);
        Bitmap bitmap2 = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.mipmap.ic_restart);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"BitmapFactory.decodeReso\u2026ces, R.mipmap.ic_restart)");
        this.mRestartBitmap = bitmap2;
    }

    public static final /* synthetic */ void access$setMPaint$p(CaptureButton $this, Paint paint) {
        $this.mPaint = paint;
    }

    public static final /* synthetic */ float access$getTransformRate$p(CaptureButton $this) {
        return $this.transformRate;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/talpa/translate/base/view/CaptureButton$CameraState;", "Lcom/talpa/translate/base/view/CaptureButtonState;", "(Lcom/talpa/translate/base/view/CaptureButton;)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "translation_googleRelease"})
    public final class CameraState
    implements CaptureButtonState {
        @Override
        public void onDraw(@NotNull Canvas canvas) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            CaptureButton.this.cameraDraw(canvas);
        }

        @Override
        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            CaptureButton.this.setMeasuredDimension(View.MeasureSpec.makeMeasureSpec((int)CaptureButton.this.getResources().getDimensionPixelSize(R.dimen.camera_capture), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)CaptureButton.this.getResources().getDimensionPixelSize(R.dimen.camera_capture), (int)0x40000000));
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/talpa/translate/base/view/CaptureButton$ResultState;", "Lcom/talpa/translate/base/view/CaptureButtonState;", "(Lcom/talpa/translate/base/view/CaptureButton;)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "translation_googleRelease"})
    public final class ResultState
    implements CaptureButtonState {
        @Override
        public void onDraw(@NotNull Canvas canvas) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            CaptureButton.this.mPaint.setAlpha(CaptureButton.this.mAlpha);
            canvas.drawBitmap(CaptureButton.this.mRestartBitmap, 0.0f, 0.0f, CaptureButton.this.mPaint);
        }

        @Override
        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            CaptureButton.this.setMeasuredDimension(View.MeasureSpec.makeMeasureSpec((int)CaptureButton.this.getResources().getDimensionPixelSize(R.dimen.translation_result), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)CaptureButton.this.getResources().getDimensionPixelSize(R.dimen.translation_result), (int)0x40000000));
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J(\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/talpa/translate/base/view/CaptureButton$TransparentAnim;", "Landroid/view/animation/Animation;", "(Lcom/talpa/translate/base/view/CaptureButton;)V", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "initialize", "width", "", "height", "parentWidth", "parentHeight", "translation_googleRelease"})
    public final class TransparentAnim
    extends Animation {
        protected void applyTransformation(float interpolatedTime, @Nullable Transformation t) {
            super.applyTransformation(interpolatedTime, t);
            CaptureButton.this.mAlpha = 255 - (int)(0.5 * (double)interpolatedTime * (double)255);
            CaptureButton.this.transformRate = 1.0f - 0.25f * interpolatedTime;
            CaptureButton.this.postInvalidate();
        }

        public void initialize(int width, int height, int parentWidth, int parentHeight) {
            super.initialize(width, height, parentWidth, parentHeight);
            this.setDuration(50L);
            this.setFillAfter(true);
            this.setInterpolator((Interpolator)new LinearInterpolator());
        }
    }
}

