/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.video;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.VideoResult;

public abstract class VideoRecorder {
    private static final String TAG = VideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int STATE_IDLE = 0;
    private static final int STATE_RECORDING = 1;
    private static final int STATE_STOPPING = 2;
    @VisibleForTesting(otherwise=4)
    VideoResult.Stub mResult;
    private final VideoResultListener mListener;
    protected Exception mError;
    private int mState;
    private final Object mStateLock = new Object();

    VideoRecorder(@Nullable VideoResultListener listener) {
        this.mListener = listener;
        this.mState = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(@NonNull VideoResult.Stub stub) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 0) {
                LOG.e("start:", "called twice, or while stopping! Ignoring. state:", this.mState);
                return;
            }
            LOG.i("start:", "Changed state to STATE_RECORDING");
            this.mState = 1;
        }
        this.mResult = stub;
        this.onStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(boolean isCameraShutdown) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == 0) {
                LOG.e("stop:", "called twice, or called before start! Ignoring. isCameraShutdown:", isCameraShutdown);
                return;
            }
            LOG.i("stop:", "Changed state to STATE_STOPPING");
            this.mState = 2;
        }
        this.onStop(isCameraShutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecording() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mState != 0;
        }
    }

    protected abstract void onStart();

    protected abstract void onStop(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void dispatchResult() {
        Object object = this.mStateLock;
        synchronized (object) {
            if (!this.isRecording()) {
                LOG.w("dispatchResult:", "Called, but not recording! Aborting.");
                return;
            }
            LOG.i("dispatchResult:", "Changed state to STATE_IDLE.");
            this.mState = 0;
        }
        this.onDispatchResult();
        LOG.i("dispatchResult:", "About to dispatch result:", this.mResult, this.mError);
        if (this.mListener != null) {
            this.mListener.onVideoResult(this.mResult, this.mError);
        }
        this.mResult = null;
        this.mError = null;
    }

    protected void onDispatchResult() {
    }

    @CallSuper
    protected void dispatchVideoRecordingStart() {
        LOG.i("dispatchVideoRecordingStart:", "About to dispatch.");
        if (this.mListener != null) {
            this.mListener.onVideoRecordingStart();
        }
    }

    @CallSuper
    protected void dispatchVideoRecordingEnd() {
        LOG.i("dispatchVideoRecordingEnd:", "About to dispatch.");
        if (this.mListener != null) {
            this.mListener.onVideoRecordingEnd();
        }
    }

    public static interface VideoResultListener {
        public void onVideoResult(@Nullable VideoResult.Stub var1, @Nullable Exception var2);

        public void onVideoRecordingStart();

        public void onVideoRecordingEnd();
    }
}

