/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr.text;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.text.Html;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.talpa.translate.base.common.FrameMetadata;
import com.talpa.translate.base.utils.UtilsKt;
import com.talpa.translate.ocr.TextDrawer;
import com.talpa.translate.ocr.datasource.RenderSource;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0016J2\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000e2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/talpa/translate/ocr/text/NormalTextDrawer;", "Lcom/talpa/translate/ocr/TextDrawer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "mTextPaint", "Landroid/text/TextPaint;", "draw", "Landroid/graphics/Bitmap;", "renderSource", "Lcom/talpa/translate/ocr/datasource/RenderSource;", "frameMetadata", "Lcom/talpa/translate/base/common/FrameMetadata;", "ocrResult", "Lcom/talpa/translate/ocr/result/OcrResult;", "transResult", "", "", "handleVisionTextToBitmap", "metadata", "translation_googleRelease"})
public final class NormalTextDrawer
implements TextDrawer {
    private TextPaint mTextPaint;
    @NotNull
    private final Context context;

    @Override
    @Nullable
    public Bitmap draw(@NotNull RenderSource renderSource, @NotNull FrameMetadata frameMetadata, @NotNull OcrResult ocrResult, @NotNull List<String> transResult) {
        Intrinsics.checkNotNullParameter((Object)renderSource, (String)"renderSource");
        Intrinsics.checkNotNullParameter((Object)frameMetadata, (String)"frameMetadata");
        Intrinsics.checkNotNullParameter((Object)ocrResult, (String)"ocrResult");
        Intrinsics.checkNotNullParameter(transResult, (String)"transResult");
        return this.handleVisionTextToBitmap(renderSource, ocrResult, frameMetadata, transResult);
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap handleVisionTextToBitmap(RenderSource renderSource, OcrResult ocrResult, FrameMetadata metadata, List<String> transResult) {
        if (renderSource.getBitmap() == null) {
            return null;
        }
        Bitmap bitmap2 = renderSource.getBitmap();
        Intrinsics.checkNotNull((Object)bitmap2);
        Canvas canvas = new Canvas(bitmap2);
        Iterable $this$forEachIndexed$iv = ocrResult.getBlocks();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void block;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Block block2 = (Block)item$iv;
            int index = n;
            boolean bl2 = false;
            this.mTextPaint.setColor(renderSource.getColors()[index]);
            Rect rect = block.getRect();
            String string2 = transResult.get(index);
            if (string2 == null) {
                string2 = "";
            }
            int textSize = UtilsKt.getAutofitTextSize(string2, this.mTextPaint, rect, 16, this.context);
            float f = textSize;
            Resources resources = this.context.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
            this.mTextPaint.setTextSize(TypedValue.applyDimension((int)2, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            String string3 = transResult.get(index);
            if (string3 == null) {
                string3 = "";
            }
            StaticLayout staticLayout = new StaticLayout((CharSequence)Html.fromHtml((String)string3), this.mTextPaint, rect.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            canvas.save();
            canvas.translate((float)rect.left, (float)rect.top);
            staticLayout.draw(canvas);
            canvas.restore();
        }
        return renderSource.getBitmap();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public NormalTextDrawer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.mTextPaint = new TextPaint(1);
    }
}

