package com.talpa.translate.record

import android.content.Context
import android.content.Intent
import android.view.MotionEvent
import com.talpa.TranslationController
import com.talpa.translate.ocr.result.OcrResult

/**
 * Create by chenjunsheng on 2020/8/11
 */
interface ICaptureController {

    fun captureFrameSync(context: Context) : CaptureResult

    fun setTextRecognizeListener(listener: TranslationController.TextRecognizeListener)

    fun startRecordService(context: Context, resultCode: Int, data: Intent)

    suspend fun doTextRecognize(index: Int, captureResult: CaptureResult) : OcrResult?

    fun destroyRecognizeService()

    fun delegateRecTouchEvent(e: MotionEvent)

    fun setCurrentState(state: Int)

}